/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.api.DRJDBCDataTypeUtils;
import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRJDBCResultSet;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.TypeUtilities;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCColumnsMetadataSource
implements IMetadataSource {
    private DRJDBCClient m_client;
    private DRJDBCConnectionSettings m_settings;
    private ILogger m_logger;
    private DRJDBCExecutionContext m_context;
    private DRJDBCResultSet m_results;
    private String m_typeName;
    private boolean m_isFetching = false;

    public DRJDBCColumnsMetadataSource(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_client = dRJDBCClient;
        this.m_settings = dRJDBCClient.getSettings();
        this.m_logger = iLogger;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string5 = "SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, ";
        if (this.m_settings.isAnyToVarchar().booleanValue()) {
            string5 = string5 + "CASE DATA_TYPE WHEN 'ANY', 'MAP' THEN 'CHARACTER VARYING' ELSE DATA_TYPE END as DATA_TYPE, ";
            string5 = string5 + "CASE DATA_TYPE WHEN 'ANY', 'MAP' THEN 'CHARACTER VARYING'ELSE DATA_TYPE END as DATA_TYPE_NAME, ";
        } else {
            string5 = string5 + "DATA_TYPE, DATA_TYPE as DATA_TYPE_NAME, ";
        }
        string5 = string5 + "CASE DATA_TYPE WHEN 'BINARY' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'CHARACTER VARYING' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'CHARACTER' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'DATE' THEN DATETIME_PRECISION WHEN 'INTERVAL' THEN INTERVAL_PRECISION WHEN 'VARCHAR' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'VARBINARY' THEN CHARACTER_MAXIMUM_LENGTH ELSE NUMERIC_PRECISION END as COLUMN_SIZE, NUMERIC_SCALE as DECIMAL_DIGITS, CASE DATA_TYPE WHEN 'CHARACTER VARYING' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'CHARACTER' THEN CHARACTER_MAXIMUM_LENGTH WHEN 'VARCHAR' THEN CHARACTER_MAXIMUM_LENGTH ELSE 9 END as BUFFER_LENGTH, NUMERIC_PRECISION_RADIX, CASE IS_NULLABLE WHEN 'NO' THEN 0 WHEN 'YES' THEN 1 ELSE 1 END as NULLABLE, 12 as REMARKS, 13 as COLUMN_DEF, 14 as SQL_DATA_TYPE, 15 as SQL_DATETIME_SUB, CHARACTER_MAXIMUM_LENGTH as CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, 18 as USER_DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS";
        boolean bl = false;
        if (null != string4 && !string4.equals("")) {
            if (bl) {
                string5 = string5 + " AND TABLE_CATALOG LIKE '" + string4 + "' ESCAPE '\\'";
            } else {
                string5 = string5 + " WHERE TABLE_CATALOG LIKE '" + string4 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string && !string.equals("")) {
            if (bl) {
                string5 = string5 + " AND TABLE_SCHEMA LIKE '" + string + "' ESCAPE '\\'";
            } else {
                string5 = string5 + " WHERE TABLE_SCHEMA LIKE '" + string + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                string5 = string5 + " AND COLUMN_NAME LIKE '" + string3 + "' ESCAPE '\\'";
            } else {
                string5 = string5 + " WHERE COLUMN_NAME LIKE '" + string3 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                string5 = string5 + " AND TABLE_NAME LIKE '" + string2 + "' ESCAPE '\\'";
            } else {
                string5 = string5 + " WHERE TABLE_NAME LIKE '" + string2 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        string5 = string5 + " ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION, COLUMN_NAME";
        this.m_context = this.m_client.executeStatementDirect(string5);
        this.m_results = new DRJDBCResultSet(this.m_client, this.m_context, this.m_logger);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.close();
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.closeCursor();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE: {
                this.m_results.getData(4, l, l2, dataWrapper);
                try {
                    this.m_typeName = dataWrapper.getVarChar();
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    // empty catch block
                }
                try {
                    dataWrapper.setSmallInt(DRJDBCDataTypeUtils.mapDrillTypeNameToSqltype(this.m_typeName));
                }
                catch (Exception exception) {
                    dataWrapper.setSmallInt(1111);
                }
                return false;
            }
            case NULLABLE: {
                return this.m_results.getData(10, l, l2, dataWrapper);
            }
            case REMARKS: {
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                return this.m_results.getData(15, l, l2, dataWrapper);
            }
            case COLUMN_SIZE: {
                return this.m_results.getData(6, l, l2, dataWrapper);
            }
            case BUFFER_LENGTH: {
                return this.m_results.getData(8, l, l2, dataWrapper);
            }
            case DECIMAL_DIGITS: {
                return this.m_results.getData(7, l, l2, dataWrapper);
            }
            case SQL_DATETIME_SUB: {
                this.m_results.getData(4, l, l2, dataWrapper);
                try {
                    this.m_typeName = DRJDBCDataTypeUtils.mapDrillTypeToDriverTypeName(dataWrapper.getVarChar());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    // empty catch block
                }
                if (this.m_typeName.equals("DATE")) {
                    short s = TypeUtilities.getIntervalCodeFromConciseType(91);
                    if (s == 0) {
                        dataWrapper.setNull(5);
                    } else {
                        dataWrapper.setSmallInt(s);
                    }
                } else if (this.m_typeName.equals("TIME") || this.m_typeName.equals("TIMETZ")) {
                    short s = TypeUtilities.getIntervalCodeFromConciseType(92);
                    if (s == 0) {
                        dataWrapper.setNull(5);
                    } else {
                        dataWrapper.setSmallInt(s);
                    }
                } else if (this.m_typeName.equals("TIMESTAMP") || this.m_typeName.equals("TIMESTAMPTZ")) {
                    short s = TypeUtilities.getIntervalCodeFromConciseType(93);
                    if (s == 0) {
                        dataWrapper.setNull(5);
                    } else {
                        dataWrapper.setSmallInt(s);
                    }
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case CATALOG_NAME: {
                return this.m_results.getData(0, l, l2, dataWrapper);
            }
            case SCHEMA_NAME: {
                return this.m_results.getData(1, l, l2, dataWrapper);
            }
            case TABLE_NAME: {
                return this.m_results.getData(2, l, l2, dataWrapper);
            }
            case COLUMN_NAME: {
                return this.m_results.getData(3, l, l2, dataWrapper);
            }
            case NUM_PREC_RADIX: {
                return this.m_results.getData(9, l, l2, dataWrapper);
            }
            case COLUMN_DEF: {
                return false;
            }
            case IS_NULLABLE: {
                return this.m_results.getData(17, l, l2, dataWrapper);
            }
            case DATA_TYPE_NAME: {
                return this.m_results.getData(5, l, l2, dataWrapper);
            }
            case ORDINAL_POSITION: {
                return this.m_results.getData(16, l, l2, dataWrapper);
            }
            case SQL_DATA_TYPE: {
                this.m_results.getData(4, l, l2, dataWrapper);
                try {
                    this.m_typeName = DRJDBCDataTypeUtils.mapDrillTypeToDriverTypeName(dataWrapper.getVarChar());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    // empty catch block
                }
                int n = 0;
                try {
                    n = TypeUtilities.getVerboseTypeFromConciseType(DRJDBCDataTypeUtils.mapDrillTypeNameToSqltype(this.m_typeName));
                }
                catch (Exception exception) {
                    dataWrapper.setNull(5);
                }
                dataWrapper.setSmallInt(n);
                return false;
            }
            case IS_AUTOINCREMENT: {
                return false;
            }
            case IS_GENERATEDCOLUMN: {
                return false;
            }
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            try {
                return this.hasMoreRows();
            }
            catch (ErrorException errorException) {
                return false;
            }
        }
        this.m_isFetching = true;
        try {
            this.m_results.moveToNextRow();
            return this.m_results.moveToNextRow();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }
}

