/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCNumberConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCIntConverter
extends DRJDBCNumberConverter {
    private static final String TYPE_NAME = "Int";

    public static DRJDBCIntConverter getInstance() {
        return DRJDBCConverterHelper.INSTANCE;
    }

    @Override
    public BigDecimal getAsBigDecimal(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return new BigDecimal(DRJDBCIntConverter.getData(sqlAccessor, n));
    }

    @Override
    public byte getAsByte(SqlAccessor sqlAccessor, int n) throws ErrorException {
        int n2 = DRJDBCIntConverter.getData(sqlAccessor, n);
        DRJDBCIntConverter.verifyByteRange(n2, TYPE_NAME);
        return (byte)n2;
    }

    @Override
    public double getAsDouble(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public float getAsFloat(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public int getAsInt(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public long getAsLong(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public short getAsShort(SqlAccessor sqlAccessor, int n) throws ErrorException {
        int n2 = DRJDBCIntConverter.getData(sqlAccessor, n);
        DRJDBCIntConverter.verifyShortRange(n2, TYPE_NAME);
        return (short)n2;
    }

    private DRJDBCIntConverter() {
    }

    private static int getData(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return sqlAccessor.getInt(n);
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static class DRJDBCConverterHelper {
        private static final DRJDBCIntConverter INSTANCE = new DRJDBCIntConverter();

        private DRJDBCConverterHelper() {
        }
    }
}

