/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCNumberConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCFloatConverter
extends DRJDBCNumberConverter {
    private static final String TYPE_NAME = "Float";

    public static DRJDBCFloatConverter getInstance() {
        return DRJDBCConverterHelper.INSTANCE;
    }

    @Override
    public BigDecimal getAsBigDecimal(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return new BigDecimal(Float.toString(DRJDBCFloatConverter.getData(sqlAccessor, n)));
    }

    @Override
    public byte getAsByte(SqlAccessor sqlAccessor, int n) throws ErrorException {
        float f = DRJDBCFloatConverter.getData(sqlAccessor, n);
        DRJDBCFloatConverter.verifyByteRange(f, TYPE_NAME);
        return (byte)f;
    }

    @Override
    public double getAsDouble(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCFloatConverter.getData(sqlAccessor, n);
    }

    @Override
    public float getAsFloat(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCFloatConverter.getData(sqlAccessor, n);
    }

    @Override
    public int getAsInt(SqlAccessor sqlAccessor, int n) throws ErrorException {
        float f = DRJDBCFloatConverter.getData(sqlAccessor, n);
        DRJDBCFloatConverter.verifyIntRange(f, TYPE_NAME);
        return (int)f;
    }

    @Override
    public long getAsLong(SqlAccessor sqlAccessor, int n) throws ErrorException {
        float f = DRJDBCFloatConverter.getData(sqlAccessor, n);
        DRJDBCFloatConverter.verifyLongRange(f, TYPE_NAME);
        return (long)f;
    }

    @Override
    public short getAsShort(SqlAccessor sqlAccessor, int n) throws ErrorException {
        float f = DRJDBCFloatConverter.getData(sqlAccessor, n);
        DRJDBCFloatConverter.verifyShortRange(f, TYPE_NAME);
        return (short)f;
    }

    private DRJDBCFloatConverter() {
    }

    private static float getData(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return sqlAccessor.getFloat(n);
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static class DRJDBCConverterHelper {
        private static final DRJDBCFloatConverter INSTANCE = new DRJDBCFloatConverter();

        private DRJDBCConverterHelper() {
        }
    }
}

