/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.jdbc.common.CommonCoreUtils;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class DRJDBCCoreUtils
extends CommonCoreUtils {
    private static final String DRILLBIT_KEY = "drillbit";
    private static final String ZOOKEEPER_KEY = "zk";
    private static final String DESCRIBE_CASE = "DESCRIBE";
    private static final String EXPLAIN_CASE = "EXPLAIN";
    private static final String SELECT_CASE = "SELECT";
    private static final String SHOW_CASE = "SHOW";
    private static final String VALUES_UCASE = "VALUES";
    private static final String WITH_CASE = "WITH";

    public static boolean isRowCountResultHelper(String string) {
        boolean bl = true;
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith(WITH_CASE)) {
            string2 = DRJDBCCoreUtils.removeWithExpression(string2);
        }
        if (string2.startsWith(SELECT_CASE) || string2.startsWith(DESCRIBE_CASE) || string2.startsWith(EXPLAIN_CASE) || string2.startsWith(SHOW_CASE) || string2.startsWith(VALUES_UCASE)) {
            bl = false;
        }
        return bl;
    }

    public static boolean parseSubName(String string, Properties properties) {
        Object object;
        boolean bl = false;
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = string.trim().split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].split("=");
            String string2 = object[0].toLowerCase().trim();
            if (string2.startsWith(DRILLBIT_KEY) || string2.startsWith(ZOOKEEPER_KEY)) {
                bl = true;
            }
            if (((String[])object).length < 2) {
                treeMap.put(object[0], "");
                continue;
            }
            treeMap.put(object[0], object[1]);
        }
        if (!bl) {
            return false;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (treeMap.containsKey(object)) continue;
            treeMap.put(object, properties.getProperty((String)object));
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static String removeWithExpression(String string) {
        if (!string.startsWith(WITH_CASE)) {
            return string;
        }
        string = string.substring(WITH_CASE.length());
        int n = 0;
        ParseState parseState = ParseState.INITIAL;
        char c = '\u0000';
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (parseState) {
                case INITIAL: {
                    char c2 = string.charAt(i);
                    switch (c2) {
                        case '(': {
                            ++n;
                            continue block11;
                        }
                        case ')': {
                            if (0 != --n) continue block11;
                            parseState = ParseState.AFTER_SUBQ;
                            continue block11;
                        }
                        case '\"': 
                        case '\'': 
                        case '`': {
                            c = c2;
                            parseState = ParseState.QUOTE;
                            continue block11;
                        }
                        case '[': {
                            c = ']';
                            parseState = ParseState.QUOTE;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case QUOTE: {
                    char c2;
                    while (i < string.length()) {
                        c2 = string.charAt(i);
                        if ('\\' == c2) {
                            ++i;
                        } else if (c == c2) {
                            parseState = ParseState.INITIAL;
                            continue block11;
                        }
                        ++i;
                    }
                    continue block11;
                }
                case AFTER_SUBQ: {
                    char c2 = string.charAt(i);
                    if (',' == c2) {
                        parseState = ParseState.INITIAL;
                        continue block11;
                    }
                    if (Character.isWhitespace(c2)) {
                        parseState = ParseState.AFTER_SUBQ;
                        continue block11;
                    }
                    return string.substring(i);
                }
            }
        }
        return "";
    }

    private static enum ParseState {
        INITIAL,
        QUOTE,
        AFTER_SUBQ;

    }
}

