/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.streams;

import java.io.IOException;
import java.io.Reader;

public class TruncatedReader
extends Reader {
    private final Reader m_wrapped;
    private long m_allowedLength;

    public TruncatedReader(Reader reader, long l) {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("allowedLength cannot be negative!");
        }
        this.m_wrapped = reader;
        this.m_allowedLength = l;
    }

    @Override
    public void close() throws IOException {
        this.m_wrapped.close();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.m_allowedLength == 0L) {
            return -1;
        }
        int n3 = this.m_wrapped.read(cArray, n, n2 = (int)Math.min((long)n2, this.m_allowedLength));
        if (n3 != -1) {
            this.m_allowedLength -= (long)n3;
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        if (this.m_allowedLength == 0L) {
            return -1;
        }
        int n = this.m_wrapped.read();
        if (n != -1) {
            --this.m_allowedLength;
        }
        return n;
    }
}

