/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.interfaces.future;

import com.mapr.drill.dsi.dataengine.interfaces.future.IExecution;
import com.mapr.drill.dsi.dataengine.utilities.SqlTypeWrapper;
import com.mapr.drill.support.exceptions.ErrorException;
import java.sql.SQLException;

public interface IJDBCExecution
extends IExecution {
    public RegistrationResult registerOutParameter(int var1, OutputParameterRegistration var2) throws SQLException, ErrorException;

    public static enum RegistrationResult {
        REGISTRATION_SUCEEDED,
        REGISTERED_TYPE_NOT_SUPPORTED,
        CONVERSION_TO_REGISTERED_TYPE_NOT_SUPPORTED;

    }

    public static final class OutputParameterRegistration {
        private final Object m_type;
        private final String m_typeName;
        private final Integer m_scale;

        public OutputParameterRegistration(int n) {
            this.m_type = n;
            this.m_typeName = null;
            this.m_scale = null;
        }

        public OutputParameterRegistration(int n, int n2) {
            this.m_type = n;
            this.m_typeName = null;
            this.m_scale = n2;
        }

        public OutputParameterRegistration(int n, String string) {
            this.m_type = n;
            this.m_typeName = string;
            this.m_scale = null;
        }

        public OutputParameterRegistration(Object object) {
            this.checkType(object);
            this.m_type = object;
            this.m_typeName = null;
            this.m_scale = null;
        }

        public OutputParameterRegistration(Object object, int n) {
            this.checkType(object);
            this.m_type = object;
            this.m_typeName = null;
            this.m_scale = n;
        }

        public OutputParameterRegistration(Object object, String string) {
            this.checkType(object);
            this.m_type = object;
            this.m_typeName = string;
            this.m_scale = null;
        }

        private void checkType(Object object) {
            if (!SqlTypeWrapper.isSQLType(object)) {
                throw new RuntimeException(String.format("'sqlType' parameter must implement java.sql.SQLType, was of type \"%s\" that did not!", object.getClass().getCanonicalName()));
            }
        }

        public Object getSqlType() {
            return this.m_type;
        }

        public String getTypeName() {
            return this.m_typeName;
        }

        public Integer getScale() {
            return this.m_scale;
        }
    }
}

