/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.impl;

import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.core.impl.DSIDriverSingleton;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.dataengine.filters.IFilter;
import com.mapr.drill.dsi.dataengine.impl.DSISimpleResultSet;
import com.mapr.drill.dsi.dataengine.interfaces.IColumn;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSourceExt;
import com.mapr.drill.dsi.dataengine.interfaces.future.ISqlDataSource;
import com.mapr.drill.dsi.dataengine.interfaces.future.ISqlDataSourceVector;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataColumn;
import com.mapr.drill.dsi.dataengine.utilities.MetadataColumnFactory;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceID;
import com.mapr.drill.dsi.dataengine.utilities.OrderType;
import com.mapr.drill.dsi.dataengine.utilities.TypeUtilities;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Pair;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DSIMetadataResultSet
extends DSISimpleResultSet
implements ISqlDataSourceVector {
    protected ILogger m_logger;
    private IMetadataSource m_metadataSource;
    private List<IFilter> m_filters;
    protected List<MetadataColumn> m_columns;
    protected List<MetadataSourceColumnTag> m_sortOrder;
    private boolean m_performFiltering = true;
    protected List<MetadataRow> m_rows = null;
    private int m_currentRowIndex = -1;
    protected final OrderType m_orderType;
    protected final boolean m_isODBC2;
    private final DataSource[] m_dataSources;

    public DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType) throws ErrorException {
        this(iStatement, metadataSourceID, iMetadataSource, list, orderType, false);
    }

    public DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID, iMetadataSource, list});
        assert (null != iMetadataSource);
        this.m_logger = iStatement.getLog();
        this.m_filters = list;
        this.m_metadataSource = iMetadataSource;
        this.m_orderType = orderType;
        this.m_isODBC2 = bl;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(iStatement, metadataSourceID);
        this.m_dataSources = this.createDataSources(this.m_columns);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(iStatement.getLog(), metadataSourceID, list, orderType);
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
        }
        if (this.m_performFiltering && this.m_metadataSource instanceof IMetadataSourceExt) {
            ((IMetadataSourceExt)this.m_metadataSource).passdownFilters(this.m_filters);
        }
        if (OrderType.NONE != orderType) {
            try {
                this.sortData();
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.SORTING_ERROR.name(), (Throwable)exception);
            }
        } else {
            this.initializeRows();
        }
    }

    protected DataSource[] createDataSources(List<MetadataColumn> list) {
        DataSource[] dataSourceArray = new DataSource[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dataSourceArray[i] = new DataSource(i);
        }
        return dataSourceArray;
    }

    protected DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, List<IFilter> list, OrderType orderType) throws ErrorException {
        this(iStatement, metadataSourceID, list, orderType, false);
    }

    protected DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, List<IFilter> list, OrderType orderType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID, list});
        this.m_logger = iStatement.getLog();
        this.m_filters = list;
        this.m_orderType = orderType;
        this.m_isODBC2 = bl;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(iStatement, metadataSourceID);
        this.m_dataSources = this.createDataSources(this.m_columns);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(iStatement.getLog(), metadataSourceID, list, orderType);
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        DataWrapper dataWrapper2 = (DataWrapper)this.m_rows.get(this.m_currentRowIndex).m_rowData.get(n);
        try {
            if (null != dataWrapper2.getObject()) {
                dataWrapper.setData(dataWrapper2.getType(), dataWrapper2.getObject());
            } else {
                dataWrapper.setNull(dataWrapper2.getType());
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(dataWrapper2.getType()), dataWrapper2.getObject().getClass().getName()});
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return (ArrayList)this.m_columns;
    }

    public List<MetadataSourceColumnTag> getSortOrder() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_sortOrder;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentRowIndex < this.m_rows.size() - 1;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.closeCursor();
        }
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return ++this.m_currentRowIndex < this.m_rows.size();
    }

    protected boolean getUnsortedData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        if (n >= this.m_columns.size()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(n), ExceptionType.DATA);
        }
        if (this.m_columns.get(n).isNullColumn()) {
            dataWrapper.setNull(this.m_columns.get(n).getTypeMetadata().getType());
            return false;
        }
        MetadataSourceColumnTag metadataSourceColumnTag = this.m_columns.get(n).getColumnTag();
        boolean bl = this.m_metadataSource.getMetadata(metadataSourceColumnTag, l, l2, dataWrapper);
        if (this.m_isODBC2 && MetadataSourceColumnTag.DATA_TYPE == metadataSourceColumnTag) {
            int n2 = 0;
            try {
                n2 = dataWrapper.getSmallInt();
            }
            catch (IncorrectTypeException incorrectTypeException) {
                // empty catch block
            }
            switch (n2) {
                case 91: {
                    dataWrapper.setSmallInt(9);
                    break;
                }
                case 92: {
                    dataWrapper.setSmallInt(10);
                    break;
                }
                case 93: {
                    dataWrapper.setSmallInt(11);
                }
            }
        }
        return bl;
    }

    protected void initializeRows() throws ErrorException {
        Object object;
        int n;
        Pair[] pairArray = new Pair[this.m_sortOrder.size()];
        for (int i = 0; i < this.m_sortOrder.size(); ++i) {
            for (n = 0; n < this.m_columns.size(); ++n) {
                object = this.m_columns.get(n).getColumnTag();
                if (object != this.m_sortOrder.get(i)) continue;
                pairArray[i] = new Pair<Integer, MetadataSourceColumnTag>(n, (MetadataSourceColumnTag)((Object)object));
            }
        }
        if (null == this.m_rows) {
            this.m_rows = new ArrayList<MetadataRow>();
        }
        while (this.moveToNextUnsortedRow()) {
            ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>(this.m_columns.size());
            for (n = 0; n < this.m_columns.size(); ++n) {
                object = new DataWrapper();
                try {
                    this.getUnsortedData(n, 0L, -1L, (DataWrapper)object);
                }
                catch (ErrorException errorException) {
                    if (this.m_columns.get(n).getColumnTag() == MetadataSourceColumnTag.USER_DATA_TYPE) {
                        LogUtilities.logError(errorException, this.m_logger);
                        ((DataWrapper)object).setNull(5);
                    }
                    throw errorException;
                }
                arrayList.add((DataWrapper)object);
            }
            this.m_rows.add(new MetadataRow(pairArray, arrayList, this.m_orderType));
        }
    }

    protected boolean moveToNextUnsortedRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_performFiltering) {
            return this.m_metadataSource.moveToNextRow();
        }
        while (this.m_metadataSource.moveToNextRow()) {
            if (!this.checkRow()) continue;
            return true;
        }
        return false;
    }

    protected void sortData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.initializeRows();
        Collections.sort(this.m_rows);
    }

    private boolean checkRow() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        for (IFilter iFilter : this.m_filters) {
            this.m_metadataSource.getMetadata(iFilter.getColumnTag(), 0L, -1L, dataWrapper);
            if (iFilter.filter(dataWrapper)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DataSource getSqlDataSource(int n) throws ErrorException {
        return this.m_dataSources[n];
    }

    protected static class MetadataRow
    implements Comparable<MetadataRow> {
        private final Pair<Integer, MetadataSourceColumnTag>[] m_columnsSortIndex;
        private final List<DataWrapper> m_rowData;
        private final OrderType m_orderType;

        public MetadataRow(Pair<Integer, MetadataSourceColumnTag>[] pairArray, List<DataWrapper> list, OrderType orderType) {
            this.m_columnsSortIndex = pairArray;
            this.m_rowData = list;
            this.m_orderType = orderType;
        }

        @Override
        public int compareTo(MetadataRow metadataRow) {
            for (Pair<Integer, MetadataSourceColumnTag> pair : this.m_columnsSortIndex) {
                DataWrapper dataWrapper = metadataRow.m_rowData.get(pair.key());
                DataWrapper dataWrapper2 = this.m_rowData.get(pair.key());
                if (dataWrapper.getType() != dataWrapper2.getType()) {
                    throw new ClassCastException("Unable to compare rows. Data type mismatch.");
                }
                int n = this.doCompareTo(dataWrapper2, dataWrapper, pair.value());
                if (0 == n) continue;
                return n;
            }
            return 0;
        }

        private int doCompareTo(DataWrapper dataWrapper, DataWrapper dataWrapper2, MetadataSourceColumnTag metadataSourceColumnTag) {
            try {
                boolean bl;
                boolean bl2 = null == dataWrapper.getObject();
                boolean bl3 = bl = null == dataWrapper2.getObject();
                if (bl2 || bl) {
                    if (bl2 && bl) {
                        return 0;
                    }
                    if (bl2) {
                        return -1;
                    }
                    return 1;
                }
                if (metadataSourceColumnTag == MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE) {
                    return this.compareProcedureColumnType(dataWrapper.getSmallInt(), dataWrapper2.getSmallInt());
                }
                if (TypeUtilities.isIntegerType(dataWrapper.getType())) {
                    if (dataWrapper.getType() == -5) {
                        BigInteger bigInteger = dataWrapper.getBigInt();
                        BigInteger bigInteger2 = dataWrapper.getBigInt();
                        if (metadataSourceColumnTag == MetadataSourceColumnTag.DATA_TYPE && OrderType.ODBC != this.m_orderType) {
                            bigInteger = BigInteger.valueOf(TypeUtilities.mapDataTypes(bigInteger.intValue()));
                            bigInteger2 = BigInteger.valueOf(TypeUtilities.mapDataTypes(bigInteger2.intValue()));
                        }
                        return bigInteger.compareTo(bigInteger2);
                    }
                    Long l = this.getIntegerValue(dataWrapper);
                    Long l2 = this.getIntegerValue(dataWrapper2);
                    if (metadataSourceColumnTag == MetadataSourceColumnTag.DATA_TYPE && OrderType.ODBC != this.m_orderType) {
                        l = TypeUtilities.mapDataTypes(l.intValue());
                        l2 = TypeUtilities.mapDataTypes(l2.intValue());
                    }
                    return l.compareTo(l2);
                }
                if (TypeUtilities.isBooleanType(dataWrapper.getType())) {
                    if (dataWrapper.getBoolean() != dataWrapper2.getBoolean()) {
                        return dataWrapper.getBoolean() != false ? 1 : -1;
                    }
                    return 0;
                }
                return this.getStringValue(dataWrapper).compareTo(this.getStringValue(dataWrapper2));
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new ClassCastException(incorrectTypeException.getMessage());
            }
        }

        private int compareProcedureColumnType(int n, int n2) {
            int n3 = MetadataRow.getProcedureColumnTypeComparisonKey(n);
            int n4 = MetadataRow.getProcedureColumnTypeComparisonKey(n2);
            return n3 - n4;
        }

        private static int getProcedureColumnTypeComparisonKey(int n) {
            if (5 == n) {
                return 0;
            }
            if (1 == n || 2 == n || 4 == n) {
                return 1;
            }
            if (3 == n) {
                return 2;
            }
            assert (0 == n) : "Unknown column type " + n;
            return 3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataWrapper dataWrapper : this.m_rowData) {
                if (null != dataWrapper.getObject()) {
                    stringBuilder.append(dataWrapper.getObject().toString());
                } else {
                    stringBuilder.append("null");
                }
                stringBuilder.append("-");
            }
            return stringBuilder.toString();
        }

        private Long getIntegerValue(DataWrapper dataWrapper) throws IncorrectTypeException {
            int n = dataWrapper.getType();
            if (-6 == n) {
                return (long)dataWrapper.getTinyInt();
            }
            if (5 == n) {
                return (long)dataWrapper.getSmallInt();
            }
            if (4 == n) {
                return dataWrapper.getInteger();
            }
            return null;
        }

        private String getStringValue(DataWrapper dataWrapper) throws IncorrectTypeException {
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    return dataWrapper.getChar();
                }
                case -9: 
                case 12: {
                    return dataWrapper.getVarChar();
                }
                case -10: 
                case -1: {
                    return dataWrapper.getLongVarChar();
                }
            }
            return null;
        }
    }

    protected class DataSource
    implements ISqlDataSource {
        private final int m_column;

        public DataSource(int n) {
            this.m_column = n;
        }

        protected final int getColumn() {
            return this.m_column;
        }

        protected final DataWrapper getDataWrapperForCurrentCell() {
            return (DataWrapper)DSIMetadataResultSet.this.m_rows.get(DSIMetadataResultSet.this.m_currentRowIndex).m_rowData.get(this.m_column);
        }

        @Override
        public Object get() throws ErrorException {
            DataWrapper dataWrapper = this.getDataWrapperForCurrentCell();
            return dataWrapper == null ? null : dataWrapper.getObject();
        }

        @Override
        public Reader getAsReader() throws IncorrectTypeException, ErrorException {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return new StringReader((String)object);
            }
            throw new IncorrectTypeException();
        }

        @Override
        public InputStream getAsInputStream() throws IncorrectTypeException, ErrorException {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return new ByteArrayInputStream((byte[])object);
            }
            throw new IncorrectTypeException();
        }
    }
}

