/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.List;

public abstract class DRJDBCMetadataSourceClientAPI<T>
implements IMetadataSource {
    protected static final String DR_UNDEF_ERROR_MSG = "Unknown Error.";
    protected static final String DR_CAT_FN_PATTERN_ESCAPE = "\\";
    protected DRJDBCClient m_client;
    protected ILogger m_logger;
    protected List<T> m_data;
    protected int m_numData;
    protected int m_currIdx;
    protected DRJDBCConnectionSettings m_settings;

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_data = null;
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_currIdx = this.m_numData;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currIdx < this.m_numData - 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ++this.m_currIdx;
        return this.m_currIdx < this.m_numData;
    }

    protected void throwFailedMetadataColumnError(String string) throws ErrorException {
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{"Failed to find catalog name."});
    }

    protected void throwMetadataColumnNotFoundException(MetadataSourceColumnTag metadataSourceColumnTag) throws ErrorException {
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    protected void throwNullDataResponseException(String string) throws ErrorException {
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_FN_ERROR.name(), new String[]{"Got null data in response for : " + string + " object."});
    }
}

