/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.commons.SettingsKeys;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCMetadataSourceClientAPI;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCCatalogOnlyMetadataClientAPI
extends DRJDBCMetadataSourceClientAPI<UserProtos.CatalogMetadata> {
    public DRJDBCCatalogOnlyMetadataClientAPI(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
        this.m_client = dRJDBCClient;
        this.m_currIdx = -1;
        this.m_numData = 0;
        this.m_data = null;
        this.m_settings = this.m_client.getSettings();
        this.getData();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                if (SettingsKeys.CATALOG_SUPPORT_ENUM.NOT_SUPPORTED == this.m_settings.getCatalogSupport()) {
                    dataWrapper.setNull(12);
                    return false;
                }
                if (((UserProtos.CatalogMetadata)this.m_data.get(this.m_currIdx)).hasCatalogName()) {
                    return DSITypeUtilities.outputVarCharStringData(((UserProtos.CatalogMetadata)this.m_data.get(this.m_currIdx)).getCatalogName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find catalog name.");
                return false;
            }
        }
        this.throwMetadataColumnNotFoundException(metadataSourceColumnTag);
        return false;
    }

    private void getData() throws ErrorException {
        UserProtos.GetCatalogsResp getCatalogsResp = this.m_client.getCatalogs(null);
        this.m_data = getCatalogsResp.getCatalogsList();
        if (null == this.m_data) {
            this.throwNullDataResponseException(getCatalogsResp.getClass().getSimpleName());
        }
        this.m_numData = getCatalogsResp.getCatalogsCount();
    }
}

