/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCIRBConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public abstract class DRJDBCNumberConverter
implements DRJDBCIRBConverter {
    public static final String ERR_OUTOFRANGE_MSG = "Value is out of expected range for data type ";

    @Override
    public String getAsString(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return null;
    }

    public static void verifyByteRange(int n, String string) throws ErrorException {
        if (-128 > n || 127 < n) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyByteRange(long l, String string) throws ErrorException {
        if (-128L > l || 127L < l) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyByteRange(short s, String string) throws ErrorException {
        if (-128 > s || 127 < s) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyByteRange(float f, String string) throws ErrorException {
        if (!(-128.0f <= f) || !(127.0f >= f)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyByteRange(double d, String string) throws ErrorException {
        if (!(-128.0 <= d) || !(127.0 >= d)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyFloatRange(double d, String string) throws ErrorException {
        if (!((double)1.4E-45f <= d) || !(3.4028234663852886E38 >= d)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyIntRange(long l, String string) throws ErrorException {
        if (Integer.MIN_VALUE > l || Integer.MAX_VALUE < l) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyIntRange(float f, String string) throws ErrorException {
        if (!(-2.1474836E9f <= f) || !(2.1474836E9f >= f)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyIntRange(double d, String string) throws ErrorException {
        if (!(-2.147483648E9 <= d) || !(2.147483647E9 >= d)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyLongRange(float f, String string) throws ErrorException {
        if (!(-9.223372E18f <= f) || !(9.223372E18f >= f)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyLongRange(double d, String string) throws ErrorException {
        if (!(-9.223372036854776E18 <= d) || !(9.223372036854776E18 >= d)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyShortRange(int n, String string) throws ErrorException {
        if (Short.MIN_VALUE > n || Short.MAX_VALUE < n) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyShortRange(long l, String string) throws ErrorException {
        if (-32768L > l || 32767L < l) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyShortRange(float f, String string) throws ErrorException {
        if (!(-32768.0f <= f) || !(32767.0f >= f)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    public static void verifyShortRange(double d, String string) throws ErrorException {
        if (!(-32768.0 <= d) || !(32767.0 >= d)) {
            DRJDBCNumberConverter.throwOutOfRangeException(string);
        }
    }

    private static void throwOutOfRangeException(String string) throws ErrorException {
        ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), ERR_OUTOFRANGE_MSG + string);
        throw errorException;
    }
}

