/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;

public class DRQryResultListener
implements UserResultsListener {
    private static final int DEFAULT_LATCH_COUNT = 1;
    private static final int DEFAULT_BUFFER_SIZE = 2;
    private volatile AtomicReferenceArray<QueryDataBatch> m_buffer = new AtomicReferenceArray(2);
    private UserBitShared.QueryId m_qid;
    private ILogger m_logger;
    private UserBitShared.QueryResult.QueryState m_queryState;
    private Exception m_err;
    private CountDownLatch m_qidLatch;
    private final Semaphore m_cacheBufferSemaphore;
    private final Semaphore m_fetchBufferSemaphore;
    private volatile int m_bufferCacheIndex;
    private volatile int m_bufferFetchIndex;
    private volatile boolean isTerminated = false;
    private AtomicBoolean hasNextBatch;
    private volatile boolean hasExecutionStatus = false;
    private volatile ConnectionThrottle m_connectionThrottle = null;

    public DRQryResultListener(ILogger iLogger) {
        this.m_logger = iLogger;
        this.m_queryState = null;
        this.m_err = null;
        this.m_qidLatch = new CountDownLatch(1);
        this.m_cacheBufferSemaphore = new Semaphore(0);
        this.m_fetchBufferSemaphore = new Semaphore(1);
        this.m_bufferCacheIndex = 1;
        this.m_bufferFetchIndex = 0;
        this.isTerminated = false;
        this.hasNextBatch = new AtomicBoolean(false);
        this.hasExecutionStatus = false;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    public void checkAndThrowException() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_err) {
            LogUtilities.logFunctionEntrance(this.m_logger, this.m_err.getMessage());
            this.terminate();
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.QUERY_EXECUTION_ERR.name(), new String[]{this.m_err.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataArrived(QueryDataBatch queryDataBatch, ConnectionThrottle connectionThrottle) {
        LogUtilities.logFunctionEntrance(this.m_logger, null != queryDataBatch);
        if (this.isTerminated) {
            if (null != queryDataBatch) {
                queryDataBatch.release();
            }
            return;
        }
        try {
            this.m_fetchBufferSemaphore.acquire();
            this.m_connectionThrottle = connectionThrottle;
            if (null != this.m_connectionThrottle) {
                this.m_connectionThrottle.setAutoRead(false);
            }
            this.hasNextBatch.set(true);
            AtomicReferenceArray<QueryDataBatch> atomicReferenceArray = this.m_buffer;
            synchronized (atomicReferenceArray) {
                if (null != this.m_buffer.get(this.m_bufferFetchIndex)) {
                    this.m_buffer.get(this.m_bufferFetchIndex).release();
                    this.m_buffer.set(this.m_bufferFetchIndex, null);
                }
                this.m_buffer.set(this.m_bufferFetchIndex, queryDataBatch);
            }
            this.m_bufferCacheIndex = this.m_bufferFetchIndex;
            this.m_bufferFetchIndex = 1 - this.m_bufferFetchIndex;
        }
        catch (Exception exception) {
            this.m_err = exception;
        }
        finally {
            this.m_cacheBufferSemaphore.release();
        }
    }

    public synchronized QueryDataBatch getNextBatch() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkAndThrowException();
        try {
            this.m_cacheBufferSemaphore.acquire();
            this.checkAndThrowException();
            if (!this.hasNextBatch()) {
                QueryDataBatch queryDataBatch = null;
                return queryDataBatch;
            }
            this.hasNextBatch.set(false);
            QueryDataBatch queryDataBatch = this.m_buffer.get(this.m_bufferCacheIndex);
            return queryDataBatch;
        }
        catch (InterruptedException interruptedException) {
            if (null != this.m_err) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_FETCH_ERR.name(), new String[]{this.m_err.getMessage()});
            }
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_FETCH_ERR.name(), new String[]{interruptedException.getMessage()});
        }
        finally {
            if (null != this.m_connectionThrottle) {
                this.m_connectionThrottle.setAutoRead(true);
                this.m_connectionThrottle = null;
            }
            this.m_fetchBufferSemaphore.release();
        }
    }

    public UserBitShared.QueryId getQueryId() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_qid) {
            try {
                this.m_qidLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.m_err = interruptedException;
                this.checkAndThrowException();
            }
        }
        return this.m_qid;
    }

    public void releaseQuerIdLatchForCancel() {
        this.m_qidLatch.countDown();
    }

    public UserBitShared.QueryResult.QueryState getStatus() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_queryState;
    }

    public boolean hasExecutionResult() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.hasExecutionStatus;
    }

    public boolean hasNextBatch() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.hasNextBatch.get();
    }

    public void queryCompleted(UserBitShared.QueryResult.QueryState queryState) {
        LogUtilities.logFunctionEntrance(this.m_logger, queryState);
        this.m_queryState = queryState;
        this.hasExecutionStatus = true;
        this.dataArrived(null, null);
    }

    public void queryIdArrived(UserBitShared.QueryId queryId) {
        LogUtilities.logFunctionEntrance(this.m_logger, queryId);
        this.m_qid = queryId;
        this.m_qidLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_connectionThrottle) {
            this.m_connectionThrottle.setAutoRead(true);
            this.m_connectionThrottle = null;
        }
        this.isTerminated = true;
        this.m_qidLatch.countDown();
        AtomicReferenceArray<QueryDataBatch> atomicReferenceArray = this.m_buffer;
        synchronized (atomicReferenceArray) {
            if (null != this.m_buffer) {
                for (int i = 0; i < 2; ++i) {
                    if (null == this.m_buffer.get(i)) continue;
                    this.m_buffer.get(i).release();
                    this.m_buffer.set(i, null);
                }
            }
        }
        this.m_fetchBufferSemaphore.release();
        this.m_cacheBufferSemaphore.release();
    }

    public void submissionFailed(UserException userException) {
        LogUtilities.logFunctionEntrance(this.m_logger, userException);
        this.m_err = userException;
        this.m_queryState = UserBitShared.QueryResult.QueryState.FAILED;
        this.hasExecutionStatus = true;
        this.dataArrived(null, null);
    }
}

