/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.drill.commons.SettingsKeys;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;

public class DRJDBCConnectionSettings {
    private final String m_drillbit;
    private final String m_zooKeeper;
    private final Boolean m_isDirect;
    private final String m_username;
    private final String m_password;
    private final Boolean m_isAnyToVarchar;
    private final String m_excludedSchemas;
    private final String m_includedSchemas;
    private final MetadataQueryMode m_queryMode;
    private final int m_stringColumnLength;
    private final int m_nettyDArenas;
    private final boolean m_removeCatalog;
    private final long m_maxDirectMem;
    private final SettingsKeys.CATALOG_SUPPORT_ENUM m_catalogSupport;
    private final boolean m_updateColMetadataOnSchemaChange;
    private final boolean m_fetchResultsetForRowCountQueries;
    private final boolean m_useComplexTypeToJson;
    private final int m_repeatModeColumnSize;
    private final boolean m_enableRowCountQuery;

    private DRJDBCConnectionSettings(String string, String string2, String string3, String string4, Boolean bl, String string5, String string6, MetadataQueryMode metadataQueryMode, int n, int n2, long l, SettingsKeys.CATALOG_SUPPORT_ENUM cATALOG_SUPPORT_ENUM, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n3, boolean bl6, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{string, string2, string3, bl, string5, string6, metadataQueryMode});
        this.m_drillbit = string == null ? null : string.trim();
        String string7 = this.m_zooKeeper = string2 == null ? null : string2.trim();
        if (string == null && string2 == null) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{null, null, "A connection type is required. Please format like such: drillbit=host:port or zk=zk_quorum:zk_port/schema/drillbit_node"});
        }
        this.m_isDirect = string2 != null && string2.toLowerCase().trim().startsWith("zk") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.m_username = string3;
        this.m_password = string4;
        this.m_isAnyToVarchar = bl == null ? Boolean.valueOf(false) : bl;
        this.m_excludedSchemas = string5;
        this.m_includedSchemas = string6;
        this.m_queryMode = metadataQueryMode;
        this.m_stringColumnLength = n;
        this.m_nettyDArenas = n2;
        this.m_maxDirectMem = l;
        this.m_removeCatalog = bl3;
        this.m_catalogSupport = cATALOG_SUPPORT_ENUM;
        this.m_useComplexTypeToJson = bl2;
        this.m_updateColMetadataOnSchemaChange = bl4;
        this.m_fetchResultsetForRowCountQueries = bl5;
        this.m_repeatModeColumnSize = n3;
        this.m_enableRowCountQuery = bl6;
    }

    public String getDrillbit() {
        return this.m_drillbit;
    }

    public String getZooKeeper() {
        return this.m_zooKeeper;
    }

    public Boolean isDirect() {
        return this.m_isDirect;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public Boolean isAnyToVarchar() {
        return this.m_isAnyToVarchar;
    }

    public String getExcludedSchemas() {
        return this.m_excludedSchemas;
    }

    public String getIncludedSchemas() {
        return this.m_includedSchemas;
    }

    public MetadataQueryMode getQueryMode() {
        return this.m_queryMode;
    }

    public int getStringColumnLength() {
        return this.m_stringColumnLength;
    }

    public int getNettyDArenas() {
        return this.m_nettyDArenas;
    }

    public boolean isRemoveCatalog() {
        return this.m_removeCatalog;
    }

    public long getMaxDirectMem() {
        return this.m_maxDirectMem;
    }

    public SettingsKeys.CATALOG_SUPPORT_ENUM getCatalogSupport() {
        return this.m_catalogSupport;
    }

    public boolean isUpdateColMetadataOnSchemaChange() {
        return this.m_updateColMetadataOnSchemaChange;
    }

    public boolean isFetchResultsetForRowCountQueries() {
        return this.m_fetchResultsetForRowCountQueries;
    }

    public boolean isUseComplexTypeToJson() {
        return this.m_useComplexTypeToJson;
    }

    public int getRepeatModeColumnSize() {
        return this.m_repeatModeColumnSize;
    }

    public boolean getEnableRowCountQuerySupport() {
        return this.m_enableRowCountQuery;
    }

    public static class DRJDBCConnectionSettingsBuilder {
        private String m_drillbit;
        private String m_zooKeeper;
        private Boolean m_isDirect;
        private String m_username;
        private String m_password;
        private Boolean m_isAnyToVarchar;
        private String m_excludedSchemas;
        private String m_includedSchemas;
        private MetadataQueryMode m_queryMode;
        private int m_stringColumnLength;
        private int m_nettyDArenas;
        private boolean m_removeCatalog;
        private long m_maxDirectMem;
        private SettingsKeys.CATALOG_SUPPORT_ENUM m_catalogSupport;
        private boolean m_updateColMetadataOnSchemaChange;
        private boolean m_fetchResultsetForRowCountQueries;
        private boolean m_useComplexTypeToJson;
        private int m_repeatModeColumnSize;
        private boolean m_enableRowCountQuery;
        private ILogger m_logger;
        private IWarningListener m_warningListener;

        public DRJDBCConnectionSettingsBuilder setDrillbit(String string) {
            this.m_drillbit = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setZooKeeper(String string) {
            this.m_zooKeeper = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setIsDirect(Boolean bl) {
            this.m_isDirect = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setUsername(String string) {
            this.m_username = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setPassword(String string) {
            this.m_password = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setAnyToVarchar(Boolean bl) {
            this.m_isAnyToVarchar = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setExcludedSchemas(String string) {
            this.m_excludedSchemas = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setIncludedSchemas(String string) {
            this.m_includedSchemas = string;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setQueryMode(MetadataQueryMode metadataQueryMode) {
            this.m_queryMode = metadataQueryMode;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setStringColumnLength(int n) {
            this.m_stringColumnLength = n;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setNettyDArenas(int n) {
            this.m_nettyDArenas = n;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setRemoveCatalog(boolean bl) {
            this.m_removeCatalog = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setMaxDirectMem(long l) {
            this.m_maxDirectMem = l;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setCatalogSupport(SettingsKeys.CATALOG_SUPPORT_ENUM cATALOG_SUPPORT_ENUM) {
            this.m_catalogSupport = cATALOG_SUPPORT_ENUM;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setUpdateColMetadataOnSchemaChange(boolean bl) {
            this.m_updateColMetadataOnSchemaChange = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setFetchResultsetForRowCountQueries(boolean bl) {
            this.m_fetchResultsetForRowCountQueries = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setUseComplexTypeToJson(boolean bl) {
            this.m_useComplexTypeToJson = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setRepeatModeColumnSize(int n) {
            this.m_repeatModeColumnSize = n;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setRowCountQuerySupport(boolean bl) {
            this.m_enableRowCountQuery = bl;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setLogger(ILogger iLogger) {
            this.m_logger = iLogger;
            return this;
        }

        public DRJDBCConnectionSettingsBuilder setWarningListener(IWarningListener iWarningListener) {
            this.m_warningListener = iWarningListener;
            return this;
        }

        public DRJDBCConnectionSettings build() throws ErrorException {
            return new DRJDBCConnectionSettings(this.m_drillbit, this.m_zooKeeper, this.m_username, this.m_password, this.m_isAnyToVarchar, this.m_excludedSchemas, this.m_includedSchemas, this.m_queryMode, this.m_stringColumnLength, this.m_nettyDArenas, this.m_maxDirectMem, this.m_catalogSupport, this.m_useComplexTypeToJson, this.m_removeCatalog, this.m_updateColMetadataOnSchemaChange, this.m_fetchResultsetForRowCountQueries, this.m_repeatModeColumnSize, this.m_enableRowCountQuery, this.m_logger, this.m_warningListener);
        }
    }

    public static enum MetadataQueryMode {
        CHECK_SERVER,
        USE_METADATA_API,
        USE_QUERY_METHOD;

    }
}

