/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.client;

import com.mapr.drill.drill.api.DRJDBCDataTypeUtils;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRQryResultListener;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCColumnMetadata;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.DiagState;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.drill.common.Version;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;

public class DRJDBCClient {
    public static final boolean NO_ROW_COUNT_QUERY_SUPPORT = false;
    public static final boolean ROW_COUNT_QUERY_SUPPORT = true;
    protected DrillClient m_drillClient;
    protected DRJDBCConnectionSettings m_settings;
    protected ILogger m_logger;
    protected IWarningListener m_warningListener;
    private boolean m_hasOpenSession;
    private boolean m_supportMetadataAPI;
    private boolean m_serverHasRowCountSupport;
    private static final String IBM_JVM = "IBM";
    protected static final String DR_UNDEF_ERROR_MSG = "Undefined Error.";
    private static final String SET_RESULT_SET_FOR_DDL_QRY = "SET `exec.query.return_result_set_for_ddl`=";
    private static final String RETURN_RS_FOR_DDL = "true";
    private static final String NOT_RETURN_RS_FOR_DDL = "false";

    public DRJDBCClient(DRJDBCConnectionSettings dRJDBCConnectionSettings, Properties properties, IWarningListener iWarningListener, ILogger iLogger) throws ErrorException {
        Properties properties2 = new Properties();
        properties2 = (Properties)properties.clone();
        properties2.replace("user", "****");
        properties2.replace("password", "****");
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCConnectionSettings, properties2);
        this.m_settings = dRJDBCConnectionSettings;
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_hasOpenSession = false;
        this.setSystemProperties(this.m_settings);
        if (this.m_settings.isDirect().booleanValue()) {
            this.openSession(properties.getProperty("drillbit"), properties);
        } else {
            this.openSession(properties.getProperty("zk"), properties);
        }
        this.m_supportMetadataAPI = this.checkMetadataAPISupport();
        this.m_serverHasRowCountSupport = this.checkRowCountQuerySupport();
        this.setCustomSessionProperties(dRJDBCConnectionSettings);
    }

    public void cancel(UserBitShared.QueryId queryId) {
        LogUtilities.logFunctionEntrance(this.m_logger, queryId);
        if (null != queryId) {
            this.m_drillClient.cancelQuery(queryId);
        }
    }

    public void closeSession() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasOpenSession) {
            this.m_drillClient.close();
            this.m_hasOpenSession = false;
        }
    }

    public DRJDBCExecutionContext executeStatementDirect(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        DRJDBCExecutionContext dRJDBCExecutionContext = new DRJDBCExecutionContext();
        dRJDBCExecutionContext.m_resultListener = new DRQryResultListener(this.m_logger);
        BufferAllocator bufferAllocator = this.m_drillClient.getAllocator();
        if (bufferAllocator == null) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.BUFFER_ALLOC_ERR.name(), new String[]{"Unable to getAllocator."});
        }
        dRJDBCExecutionContext.m_buffalloc = bufferAllocator;
        this.m_drillClient.runQuery(UserBitShared.QueryType.SQL, string, (UserResultsListener)dRJDBCExecutionContext.m_resultListener);
        return dRJDBCExecutionContext;
    }

    public String[] getCatalogNames() throws ErrorException {
        UserProtos.GetCatalogsResp getCatalogsResp = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        getCatalogsResp = this.getCatalogs(null);
        List list = getCatalogsResp.getCatalogsList();
        for (UserProtos.CatalogMetadata catalogMetadata : list) {
            if (!catalogMetadata.hasCatalogName()) continue;
            arrayList.add(catalogMetadata.getCatalogName());
        }
        return arrayList.toArray(new String[0]);
    }

    public UserProtos.GetCatalogsResp getCatalogs(UserProtos.LikeFilter likeFilter) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, likeFilter);
        UserProtos.GetCatalogsResp getCatalogsResp = null;
        try {
            getCatalogsResp = (UserProtos.GetCatalogsResp)this.m_drillClient.getCatalogs(likeFilter).get();
            if (null == getCatalogsResp) {
                this.throwNullResponseError("getCatalogs");
            }
            if (getCatalogsResp.hasError()) {
                UserBitShared.DrillPBError drillPBError = getCatalogsResp.getError();
                this.throwResponseError(drillPBError);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.throwResponseException(exception);
        }
        return getCatalogsResp;
    }

    public UserProtos.GetColumnsResp getColumns(UserProtos.LikeFilter likeFilter, UserProtos.LikeFilter likeFilter2, UserProtos.LikeFilter likeFilter3, UserProtos.LikeFilter likeFilter4) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, likeFilter, likeFilter2, likeFilter3, likeFilter4);
        UserProtos.GetColumnsResp getColumnsResp = null;
        try {
            getColumnsResp = (UserProtos.GetColumnsResp)this.m_drillClient.getColumns(likeFilter, likeFilter2, likeFilter3, likeFilter4).get();
            if (null == getColumnsResp) {
                this.throwNullResponseError("getColumns");
            }
            if (getColumnsResp.hasError()) {
                UserBitShared.DrillPBError drillPBError = getColumnsResp.getError();
                this.throwResponseError(drillPBError);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.throwResponseException(exception);
        }
        return getColumnsResp;
    }

    public ArrayList<DRJDBCColumnMetadata> getResultSetMetadata(QueryDataBatch queryDataBatch, RecordBatchLoader recordBatchLoader) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, queryDataBatch.hasData());
        UserBitShared.QueryData queryData = queryDataBatch.getHeader();
        UserBitShared.RecordBatchDefOrBuilder recordBatchDefOrBuilder = queryData.getDefOrBuilder();
        List list = recordBatchDefOrBuilder.getFieldList();
        ArrayList<DRJDBCColumnMetadata> arrayList = new ArrayList<DRJDBCColumnMetadata>();
        if (null != recordBatchLoader && null != recordBatchLoader.getSchema() && list.size() == recordBatchLoader.getSchema().getFieldCount()) {
            BatchSchema batchSchema = recordBatchLoader.getSchema();
            for (int i = 0; i < batchSchema.getFieldCount(); ++i) {
                MaterializedField materializedField = batchSchema.getColumn(i);
                UserBitShared.SerializedField serializedField = (UserBitShared.SerializedField)list.get(i);
                try {
                    arrayList.add(DRJDBCDataTypeUtils.createColumn(null, null, null, serializedField, materializedField, this.m_settings));
                    continue;
                }
                catch (Exception exception) {
                    throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{exception.getMessage()}, (Throwable)exception);
                }
            }
        } else {
            for (UserBitShared.SerializedField serializedField : list) {
                try {
                    arrayList.add(DRJDBCDataTypeUtils.createColumn(null, null, null, serializedField, null, this.m_settings));
                }
                catch (Exception exception) {
                    throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{exception.getMessage()}, (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public UserProtos.GetSchemasResp getSchemas(UserProtos.LikeFilter likeFilter, UserProtos.LikeFilter likeFilter2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, likeFilter, likeFilter2);
        UserProtos.GetSchemasResp getSchemasResp = null;
        try {
            getSchemasResp = (UserProtos.GetSchemasResp)this.m_drillClient.getSchemas(likeFilter, likeFilter2).get();
            if (null == getSchemasResp) {
                this.throwNullResponseError("getSchemas");
            }
            if (getSchemasResp.hasError()) {
                UserBitShared.DrillPBError drillPBError = getSchemasResp.getError();
                this.throwResponseError(drillPBError);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.throwResponseException(exception);
        }
        return getSchemasResp;
    }

    public String getServerName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasOpenSession) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, "No valid connection");
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
        }
        return this.m_drillClient.getServerName();
    }

    public Version getServerVersionInfo() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasOpenSession) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, "No valid connection");
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
        }
        return this.m_drillClient.getServerVersion();
    }

    public DRJDBCConnectionSettings getSettings() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_settings;
    }

    public UserProtos.GetTablesResp getTables(UserProtos.LikeFilter likeFilter, UserProtos.LikeFilter likeFilter2, UserProtos.LikeFilter likeFilter3, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, likeFilter, likeFilter2, likeFilter3, list);
        UserProtos.GetTablesResp getTablesResp = null;
        try {
            getTablesResp = (UserProtos.GetTablesResp)this.m_drillClient.getTables(likeFilter, likeFilter2, likeFilter3, list).get();
            if (null == getTablesResp) {
                this.throwNullResponseError("getTables");
            }
            if (getTablesResp.hasError()) {
                UserBitShared.DrillPBError drillPBError = getTablesResp.getError();
                this.throwResponseError(drillPBError);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.throwResponseException(exception);
        }
        return getTablesResp;
    }

    public boolean hasMetadataAPISupport() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_supportMetadataAPI;
    }

    public boolean serverHasRowCountSupport() {
        return this.m_serverHasRowCountSupport;
    }

    public UserProtos.PreparedStatement createPrepareStatement(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        try {
            UserProtos.CreatePreparedStatementResp createPreparedStatementResp = (UserProtos.CreatePreparedStatementResp)this.m_drillClient.createPreparedStatement(string).get();
            if (null == createPreparedStatementResp) {
                this.throwPreparedStatementException("RPCFuture returned a null prepared statement response.");
            } else if (createPreparedStatementResp.hasError()) {
                this.throwPreparedStatementException(createPreparedStatementResp.getError().getMessage());
            }
            return createPreparedStatementResp.getPreparedStatement();
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            String string2 = exception instanceof ExecutionException ? exception.getCause().getMessage() : exception.getMessage();
            this.throwPreparedStatementException(string2);
            return null;
        }
    }

    public DRJDBCExecutionContext executePrepareStatement(UserProtos.PreparedStatementHandle preparedStatementHandle) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        DRJDBCExecutionContext dRJDBCExecutionContext = new DRJDBCExecutionContext();
        dRJDBCExecutionContext.m_resultListener = new DRQryResultListener(this.m_logger);
        BufferAllocator bufferAllocator = this.m_drillClient.getAllocator();
        if (bufferAllocator == null) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.QUERY_EXECUTION_ERR.name(), new String[]{"Unable to getAllocator."});
        }
        dRJDBCExecutionContext.m_buffalloc = bufferAllocator;
        this.m_drillClient.executePreparedStatement(preparedStatementHandle, (UserResultsListener)dRJDBCExecutionContext.m_resultListener);
        return dRJDBCExecutionContext;
    }

    public DrillRpcFuture<UserProtos.GetServerMetaResp> getServerMeta() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasOpenSession) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, "No valid connection");
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
        }
        return this.m_drillClient.getServerMeta();
    }

    private boolean checkMetadataAPISupport() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = this.checkServerSupport();
        if (null == this.m_settings.getQueryMode()) {
            return bl;
        }
        switch (this.m_settings.getQueryMode()) {
            case USE_METADATA_API: {
                if (bl) break;
                LogUtilities.logWarning("Server does not support metadata API, revert to using query mode.", this.m_logger);
                break;
            }
            case USE_QUERY_METHOD: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean checkServerSupport() {
        boolean bl = false;
        try {
            String string;
            String[] stringArray;
            Version version = this.getServerVersionInfo();
            if (null != version && (stringArray = (string = version.getVersion()).split("\\.")).length >= 2) {
                int n = Integer.valueOf(stringArray[0]);
                int n2 = Integer.valueOf(stringArray[1]);
                bl = 1 == n && 9 < n2 || 2 <= n;
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to get server version", this.m_logger);
        }
        return bl;
    }

    private boolean checkRowCountQuerySupport() {
        boolean bl = false;
        try {
            String string;
            String[] stringArray;
            Version version = this.getServerVersionInfo();
            if (null != version && (stringArray = (string = version.getVersion()).split("\\.")).length >= 2) {
                int n = Integer.valueOf(stringArray[0]);
                int n2 = Integer.valueOf(stringArray[1]);
                bl = 1 == n && 15 <= n2 || 2 <= n;
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to get server version", this.m_logger);
        }
        return bl;
    }

    private void openSession(String string, Properties properties) throws ErrorException {
        DrillConfig drillConfig = DrillConfig.forClient();
        ClusterCoordinator clusterCoordinator = null;
        BufferAllocator bufferAllocator = RootAllocatorFactory.newRoot((DrillConfig)drillConfig);
        this.m_drillClient = new DrillClient(drillConfig, clusterCoordinator, bufferAllocator, this.m_settings.isDirect().booleanValue());
        if (this.m_settings.isUseComplexTypeToJson()) {
            this.m_drillClient.setSupportComplexTypes(false);
        } else {
            this.m_drillClient.setSupportComplexTypes(true);
        }
        try {
            this.m_drillClient.connect(string, properties);
            this.m_hasOpenSession = true;
        }
        catch (RpcException rpcException) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 6, string);
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{rpcException.getMessage()}, (Throwable)errorException);
        }
    }

    private void setCustomSessionProperties(DRJDBCConnectionSettings dRJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_serverHasRowCountSupport) {
            try {
                this.m_drillClient.runQuery(UserBitShared.QueryType.SQL, SET_RESULT_SET_FOR_DDL_QRY + (false == dRJDBCConnectionSettings.getEnableRowCountQuerySupport() ? RETURN_RS_FOR_DDL : NOT_RETURN_RS_FOR_DDL));
            }
            catch (Exception exception) {
                LogUtilities.logDebug("Unable to set session setting for 'exec.query.return_result_set_for_ddl' disabling feature. Details: " + exception, this.m_logger);
                this.m_serverHasRowCountSupport = false;
            }
        }
    }

    private void setSystemProperties(DRJDBCConnectionSettings dRJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Properties properties = System.getProperties();
        if (!this.m_settings.isDirect().booleanValue() && !properties.containsKey("zookeeper.sasl.client")) {
            properties.setProperty("zookeeper.sasl.client", NOT_RETURN_RS_FOR_DDL);
        }
        if ("MapR".equalsIgnoreCase("MapR")) {
            properties.setProperty("drill.customAuthFactories", "org.apache.drill.exec.rpc.security.maprsasl.MapRSaslFactory");
        }
        LogUtilities.logInfo("JVM VENDOR: " + properties.getProperty("java.vendor"), this.m_logger);
        if (properties.getProperty("java.vendor", IBM_JVM).contains(IBM_JVM)) {
            properties.setProperty("io.netty.allocator.numDirectArenas", String.valueOf(this.m_settings.getNettyDArenas()));
            LogUtilities.logDebug("Setting the value of io.netty.allocator.numDirectArenas as: " + String.valueOf(this.m_settings.getNettyDArenas()), this.m_logger);
            if (0L < this.m_settings.getMaxDirectMem()) {
                properties.setProperty("io.netty.maxDirectMemory", String.valueOf(this.m_settings.getMaxDirectMem()));
                LogUtilities.logDebug("Setting the value of io.netty.maxDirectMemory as: " + String.valueOf(this.m_settings.getMaxDirectMem()), this.m_logger);
            }
        }
    }

    private void throwPreparedStatementException(String string) throws ErrorException {
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.PREPARE_STATEMENT_ERR.name(), new String[]{string});
    }

    private void throwNullResponseError(String string) throws ErrorException {
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_FN_ERROR.name(), new String[]{"Got null response for " + string});
    }

    private void throwResponseError(UserBitShared.DrillPBError drillPBError) throws ErrorException {
        String string = DR_UNDEF_ERROR_MSG;
        if (null != drillPBError && drillPBError.hasMessage()) {
            string = drillPBError.getMessage();
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_FN_ERROR.name(), new String[]{string});
    }

    private void throwResponseException(Exception exception) throws ErrorException {
        if (exception instanceof ExecutionException && null != exception.getCause()) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_FN_ERROR.name(), new String[]{exception.getCause().getMessage()});
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_FN_ERROR.name(), new String[]{exception.getMessage()});
    }

    public boolean checkConnection() {
        return this.m_drillClient.connectionIsActive();
    }
}

