/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.license;

import com.mapr.drill.license.interfaces.IProductInfo;
import com.mapr.drill.license.interfaces.IValidationInfoProvider;
import com.mapr.drill.license.interfaces.LicenseInfo;
import com.mapr.drill.license.interfaces.MapRLicenseException;
import com.mapr.drill.license.interfaces.MapRRsaKey;
import java.security.interfaces.RSAPublicKey;

public class BasicValidationProvider
implements IValidationInfoProvider {
    private static final String evalModulus = "ujEmmnItGTZEkG1LY10MeTZo9e9DyDybfEDt74x3dg9pHetSsU/LZEAMDCUVs6/cthQR4y1bNb4eHrH6qxmEivonf8gcoDnrB9kCGrOruGcZPnMvebENlpO3WmAn+Tls6v79skcWfQAPY5um/hmkovLt8VRT3FD3HeYXr2DcBXljR51qDW2tatt/uhMzEK4936ORyYe1iOtgvpXnp07K9H3NCbXLHKcR0fuShvnSo0muiHG7tOD8v52dOXVI86Ob2K2LGSgp/z2bMsQ7CT4gzNJXmcLJIUlmOlRv1EbPhUc/xCaU9kOyacQ6BlMpFeTRMHR6V5i3we40nI+ChkL/NQ==";
    private static final String evalExponent = "AQAB";
    private static final String prodModulus = "tC501NaHXB133CJ/x8Qbju/XPNJzPZC1QuxqL/AS0M3pOIqt5g4vJCeYoS1u9OxHageagbWKwY5y4lF+0INmGEs59CwahUt6cb5rlXojcTwtlPEZGCLJnxuRydGOxAc6rxfKoB5zqLT3gW5w3fdFPRg9TMrET8k9wvKSSa2ZK5osK0O9VrRiTHe+H+NooTNzEec+XdwyHgjkfWz3GSbr3WFp1qV3wcGT24glT8PX0ttn0sPQ9Jq+rhqgCPWj7zeI9PPi8zdw/vqqzldxLokpNDIHDyp1ETai/4Wd5XMKCBNjNmQtli5cM7LbgqKs7aStYM1XBJ1kKiAINa0yb+bVNw==";
    private static final String prodExponent = "AQAB";
    private IProductInfo mProduct;
    private LicenseInfo mLicense;
    private MapRRsaKey mProductionKey;
    private MapRRsaKey mTrialKey;

    public BasicValidationProvider(IProductInfo iProductInfo, String string) throws MapRLicenseException {
        this.mLicense = new LicenseInfo(string);
        this.mProduct = iProductInfo;
        this.mProductionKey = new MapRRsaKey("AQAB", prodModulus);
        this.mTrialKey = new MapRRsaKey("AQAB", evalModulus);
    }

    public LicenseInfo getLicenseInfo() {
        return this.mLicense;
    }

    public IProductInfo getProductInfo() {
        return this.mProduct;
    }

    public RSAPublicKey getProductionPublicKey() {
        if (this.mProductionKey != null) {
            return this.mProductionKey.getRSAPublicKey();
        }
        return null;
    }

    public RSAPublicKey getTrialPublicKey() {
        if (this.mTrialKey != null) {
            return this.mTrialKey.getRSAPublicKey();
        }
        return null;
    }
}

