/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.core;

import com.mapr.drill.dsi.core.impl.DSIConnection;
import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.core.interfaces.IEnvironment;
import com.mapr.drill.dsi.core.utilities.ConnSettingRequestMap;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.exceptions.BadAttrValException;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.dsi.exceptions.NumericOverflowException;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.jdbc.common.SWarningListener;
import com.mapr.drill.jdbc.core.DSDriver;
import com.mapr.drill.jdbc.exceptions.CommonJDBCMessageKey;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Warning;
import com.mapr.drill.support.WarningCode;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import com.mapr.drill.utilities.FunctionID;

public abstract class DSCommonConnection
extends DSIConnection {
    protected boolean m_ignoreTransactions = false;
    protected boolean m_claimTransactionSupportWhenIgnoreTransactionsEnabled = false;

    protected DSCommonConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    public void readAndApplyTransactionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        this.readIgnoreTransactionsSettings(connSettingRequestMap);
        try {
            if (this.m_ignoreTransactions) {
                if (!this.m_claimTransactionSupportWhenIgnoreTransactionsEnabled) {
                    this.fakeTransactionSupport('\u0000');
                } else {
                    this.fakeTransactionSupport('\u0002');
                }
            }
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAKE_TRANSACTION_SUPPORT_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void rollback() throws ErrorException {
        if (!this.m_ignoreTransactions) {
            LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    public boolean setAutoCommit(boolean bl, boolean bl2, SWarningListener sWarningListener) throws ErrorException {
        Variant variant = new Variant("");
        try {
            if (!bl && this.m_ignoreTransactions && !bl2) {
                variant = new Variant(3, 0L);
                sWarningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
                this.setProperty(19, variant);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.SET_AUTO_COMMIT_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    public void fakeTransactionSupport(char c) throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        this.m_ignoreTransactions = true;
        this.setProperty(136, new Variant(2, Character.valueOf(c)));
    }

    private void readIgnoreTransactionsSettings(ConnSettingRequestMap connSettingRequestMap) {
        block17: {
            int n;
            Variant variant;
            block16: {
                LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
                variant = connSettingRequestMap.getProperty("IgnoreTransactions");
                if (null != variant) {
                    try {
                        n = variant.getInt();
                        if (n == 0) {
                            this.m_ignoreTransactions = false;
                        } else if (n == 1) {
                            this.m_ignoreTransactions = true;
                        } else if (null != this.getWarningListener()) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"IgnoreTransactions", variant.getString(), "0 or 1"}));
                        }
                    }
                    catch (Exception exception) {
                        LogUtilities.logWarning(exception, this.getConnectionLog());
                        if (null == this.getWarningListener()) break block16;
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"IgnoreTransactions", variant.getString(), "Integers: 0 or 1"}));
                    }
                }
            }
            if (this.m_ignoreTransactions && null != (variant = connSettingRequestMap.getProperty("ClaimTransactionSupportWhenIgnoreTransactionsEnabled"))) {
                try {
                    n = variant.getInt();
                    if (n == 0) {
                        this.m_claimTransactionSupportWhenIgnoreTransactionsEnabled = false;
                    } else if (n == 1) {
                        this.m_claimTransactionSupportWhenIgnoreTransactionsEnabled = true;
                    } else if (null != this.getWarningListener()) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ClaimTransactionSupportWhenIgnoreTransactionsEnabled", variant.getString(), "0 or 1"}));
                    }
                }
                catch (Exception exception) {
                    LogUtilities.logWarning(exception, this.getConnectionLog());
                    if (null == this.getWarningListener()) break block17;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ClaimTransactionSupportWhenIgnoreTransactionsEnabled", variant.getString(), "Integers: 0 or 1"}));
                }
            }
        }
    }
}

