/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.common;

import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.jdbc.common.SConnection;
import com.mapr.drill.jdbc.common.utilities.WrapperUtilities;
import com.mapr.drill.jdbc.interfaces.IConnectionHandle;
import com.mapr.drill.jdbc.interfaces.IPooledConnection;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public abstract class BaseConnectionHandle<T extends SConnection, P extends IPooledConnection>
implements IConnectionHandle {
    protected boolean m_isClosed = true;
    protected T m_connection;
    protected P m_pooledConnection;

    public BaseConnectionHandle(T t, P p) throws SQLException {
        if (t == null || p == null) {
            throw null;
        }
        this.m_connection = t;
        this.m_pooledConnection = p;
    }

    protected <E extends SQLException> E handleException(E e) {
        if (!((SConnection)this.m_connection).getConnection().isAlive()) {
            this.m_pooledConnection.onHandleError(e);
        }
        return e;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).clearWarnings();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.m_isClosed = true;
        try {
            ((SConnection)this.m_connection).closeChildObjects();
        }
        finally {
            this.m_pooledConnection.onHandleClose();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).commit();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createStatement();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).prepareCall(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getCatalog();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getHoldability();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    protected ILogger getLogger() {
        return ((SConnection)this.m_connection).m_logger;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getMetaData();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getTypeMap();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getWarnings();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    protected IWarningListener getWarningListener() {
        return ((SConnection)this.m_connection).m_warningListener;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed || ((SConnection)this.m_connection).isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).isReadOnly();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).nativeSQL(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).rollback();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).rollback(savepoint);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setCatalog(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setHoldability(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).setSavepoint();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).setSavepoint(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkIfOpen();
        try {
            ((SConnection)this.m_connection).setTypeMap(map);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createBlob();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createClob();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createNClob();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createSQLXML();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException, SQLFeatureNotSupportedException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return !this.isClosed() && ((SConnection)this.m_connection).getDSIConnection().isAlive();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    public <S> S unwrap(Class<S> clazz) throws SQLException {
        this.checkIfOpen();
        try {
            return WrapperUtilities.unwrap(clazz, this);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void open() throws SQLException {
        if (!this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_OPEN, ((SConnection)this.m_connection).getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        this.m_isClosed = false;
    }

    @Override
    public void forceClose() throws SQLException {
        ((SConnection)this.m_connection).close();
    }

    protected void checkIfOpen() throws SQLException {
        if (this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, ((SConnection)this.m_connection).getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getClientInfo();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((SConnection)this.m_connection).getClientInfo(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, ((SConnection)this.m_connection).getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((SConnection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw this.handleException(sQLClientInfoException);
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, ((SConnection)this.m_connection).getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((SConnection)this.m_connection).setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw this.handleException(sQLClientInfoException);
        }
    }
}

