/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.common;

import com.mapr.drill.dsi.core.impl.DSIDriverSingleton;
import com.mapr.drill.dsi.core.impl.DSILogger;
import com.mapr.drill.dsi.core.interfaces.IConnection;
import com.mapr.drill.dsi.core.interfaces.IDriver;
import com.mapr.drill.dsi.core.interfaces.IEnvironment;
import com.mapr.drill.dsi.core.utilities.ConnSettingRequestMap;
import com.mapr.drill.dsi.core.utilities.ConnSettingResponseMap;
import com.mapr.drill.dsi.core.utilities.ConnectionSetting;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.core.utilities.Variants;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.exceptions.JDBCMessageBuilder;
import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.exceptions.jdbc4.JDBC4ExceptionConverter;
import com.mapr.drill.jdbc.common.JDBCObjectFactory;
import com.mapr.drill.jdbc.common.SConnection;
import com.mapr.drill.jdbc.common.SWarningListener;
import com.mapr.drill.jdbc.interfaces.IJDBCObjectFactory;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogLevel;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Pair;
import com.mapr.drill.support.SettingReader;
import com.mapr.drill.support.Warning;
import com.mapr.drill.support.exceptions.ExceptionBuilder;
import com.mapr.drill.support.exceptions.ExceptionType;
import com.mapr.drill.support.exceptions.ExceptionUtilities;
import com.mapr.drill.support.exceptions.GeneralException;
import com.mapr.drill.support.security.ICredentialFactory;
import com.mapr.drill.utilities.FunctionID;
import com.mapr.drill.utilities.PropertyTypeConverter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class BaseConnectionFactory {
    public static final String URL_SEPARATOR = ":";
    public static final String CONNECTION_LOCALE_KEY = "Locale";
    public static ExceptionBuilder s_Messages = new ExceptionBuilder(1);
    private IJDBCObjectFactory m_jdbcObjectFactory = null;

    public BaseConnectionFactory() {
        ExceptionConverter.setInstance(this.getExceptionConverter());
    }

    protected ExceptionConverter getExceptionConverter() {
        return new JDBC4ExceptionConverter();
    }

    protected boolean acceptsSubProtocol(String string) {
        String string2 = this.getSubProtocol();
        if (null == string2) {
            return false;
        }
        return string2.equals(string);
    }

    protected final boolean acceptsURL(String string, Properties properties) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, URL_SEPARATOR);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if ("jdbc".equals(string2) && this.acceptsSubProtocol(string3)) {
                int n = string.indexOf(string3) + string3.length() + 1;
                String string4 = "";
                if (n < string.length()) {
                    string4 = string.substring(n);
                }
                SettingReader.clearAllSettings();
                if (SettingReader.isSuccessfulLoad()) {
                    properties.putAll((Map<?, ?>)SettingReader.retrieveAllSettings());
                }
                return this.parseSubName(string4, properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Deprecated
    protected JDBCObjectFactory createJDBCObjectFactory() {
        throw new RuntimeException("This method (or preferably createIJDBCObjectFactory()) must be overriden!");
    }

    protected IJDBCObjectFactory createIJDBCObjectFactory() {
        return this.createJDBCObjectFactory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IJDBCObjectFactory getJDBCObjectFactory() {
        if (this.m_jdbcObjectFactory != null) return this.m_jdbcObjectFactory;
        if (JDBCObjectFactory.getInstance() == null) {
            try {
                this.m_jdbcObjectFactory = this.createIJDBCObjectFactory();
                if (!(this.m_jdbcObjectFactory instanceof JDBCObjectFactory)) return this.m_jdbcObjectFactory;
                JDBCObjectFactory.setInstance((JDBCObjectFactory)this.m_jdbcObjectFactory);
                return this.m_jdbcObjectFactory;
            }
            catch (GeneralException generalException) {
                throw new RuntimeException(generalException);
            }
        } else {
            this.m_jdbcObjectFactory = JDBCObjectFactory.getInstance();
        }
        return this.m_jdbcObjectFactory;
    }

    protected SConnection doConnect(Pair<IConnection, ConnSettingRequestMap> pair, String string) throws SQLException {
        assert (null != pair);
        IConnection iConnection = pair.key();
        IWarningListener iWarningListener = iConnection.getWarningListener();
        try {
            IJDBCObjectFactory iJDBCObjectFactory = this.getJDBCObjectFactory();
            ConnSettingResponseMap connSettingResponseMap = null;
            if (null == iWarningListener) {
                iWarningListener = new SWarningListener(iConnection.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                iConnection.registerWarningListener(iWarningListener);
            }
            connSettingResponseMap = iConnection.updateConnectionSettings(pair.value());
            this.checkResponseMap(connSettingResponseMap, iWarningListener);
            iConnection.connect(pair.value());
            for (Warning warning : iWarningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            return iJDBCObjectFactory.newConnection(iConnection, string);
        }
        catch (Exception exception) {
            ILogger iLogger = null;
            try {
                iLogger = pair.key().getConnectionLog();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (null == iLogger) {
                throw ExceptionConverter.getInstance().toSQLException(exception, iWarningListener);
            }
            throw ExceptionConverter.getInstance().toSQLException(exception, iWarningListener, iLogger);
        }
    }

    protected Pair<IConnection, ConnSettingRequestMap> getConnection(Properties properties) throws SQLException {
        assert (null != properties);
        IDriver iDriver = DSIDriverSingleton.getInstance();
        SWarningListener sWarningListener = new SWarningListener(iDriver.getMessageSource(), FunctionID.BEFORE_CONNECTION);
        try {
            Object object;
            ILogger iLogger;
            this.mapJDBCtoODBCAuthentication(properties);
            this.saveLoggingAttributes(properties);
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (null != printWriter) {
                SettingReader.storeAdditionalSetting("LogPrintWriter", printWriter);
            }
            if ((iLogger = iDriver.getDriverLog()) instanceof DSILogger) {
                ((DSILogger)iLogger).prepareSettings(((DSILogger)iLogger).getFileName());
            }
            if (LogUtilities.shouldLogLevel(LogLevel.INFO, iLogger)) {
                LogUtilities.logInfo("SDK Version: 10.1.22.1189", iLogger);
                object = iDriver.getProperty(5);
                LogUtilities.logInfo("Driver Version: " + ((Variant)object).getString(), iLogger);
                LogUtilities.logInfo("JVM Name: " + System.getProperty("java.vm.name"), iLogger);
                LogUtilities.logInfo("JVM Specification Version: " + System.getProperty("java.vm.specification.version"), iLogger);
                LogUtilities.logInfo("JVM Implementation Version: " + System.getProperty("java.vm.version"), iLogger);
                LogUtilities.logInfo("JVM Vendor: " + System.getProperty("java.vm.specification.vendor"), iLogger);
                LogUtilities.logInfo("Operating System Name: " + System.getProperty("os.name"), iLogger);
                LogUtilities.logInfo("Operating System Version: " + System.getProperty("os.version"), iLogger);
                LogUtilities.logInfo("Operating System Architecture: " + System.getProperty("os.arch"), iLogger);
                LogUtilities.logInfo("Locale Name: " + iDriver.getLocale().toString(), iLogger);
                LogUtilities.logInfo("Default Charset Encoding: " + Charset.defaultCharset().displayName(), iLogger);
            }
            object = null;
            try {
                ICredentialFactory iCredentialFactory;
                long l = iDriver.getProperty(20).getLong();
                IEnvironment iEnvironment = iDriver.createEnvironment();
                iEnvironment.registerWarningListener(sWarningListener);
                object = (l & 1L) != 0L ? ((iCredentialFactory = iDriver.createCredentialFactory()) != null ? iEnvironment.createConnection(iCredentialFactory.getLocalCredentials()) : iEnvironment.createConnection()) : iEnvironment.createConnection();
            }
            catch (Exception exception) {
                try {
                    throw ExceptionConverter.getInstance().toSQLException(exception, sWarningListener, iLogger);
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
            ConnSettingRequestMap connSettingRequestMap = PropertyTypeConverter.toConnSettingRequestMap(properties);
            SettingReader.storeSettings(properties);
            if (connSettingRequestMap.containsKey(CONNECTION_LOCALE_KEY)) {
                Variant variant = connSettingRequestMap.getProperty(CONNECTION_LOCALE_KEY);
                object.setLocale(ExceptionUtilities.createLocale(variant.getString()));
            }
            if (DriverManager.getLoginTimeout() >= 0) {
                object.setProperty(23, Variants.makeUInt32(DriverManager.getLoginTimeout()));
            }
            return new Pair<Object, ConnSettingRequestMap>(object, connSettingRequestMap);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, sWarningListener);
        }
    }

    protected abstract String getSubProtocol();

    protected abstract boolean parseSubName(String var1, Properties var2);

    private void checkResponseMap(ConnSettingResponseMap connSettingResponseMap, IWarningListener iWarningListener) throws SQLException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        while (iterator.hasNext()) {
            charSequence = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty((String)charSequence);
            if (connectionSetting.isRequired()) {
                arrayList.add((String)charSequence);
                continue;
            }
            if (connectionSetting.isOptional()) {
                arrayList2.add((String)charSequence);
                continue;
            }
            arrayList3.add((String)charSequence);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        charSequence = new StringBuilder(JDBCMessageBuilder.getMessage(JDBCMessageKey.REQUIRED_KEYS_MSG, iWarningListener, false, false));
        ((StringBuilder)charSequence).append(": ");
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)charSequence).append(iterator.next());
            if (!iterator.hasNext()) continue;
            ((StringBuilder)charSequence).append(", ");
        }
        if (!arrayList2.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.OPTIONAL_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        if (!arrayList3.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.PROCESSED_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_REFUSED, iWarningListener, ExceptionType.NON_TRANSIENT_CONNECTION, ((StringBuilder)charSequence).toString());
    }

    private void mapJDBCtoODBCAuthentication(Properties properties) {
        Object object;
        IDriver iDriver = DSIDriverSingleton.getInstance();
        assert (null != iDriver);
        try {
            object = iDriver.getProperty(1000);
            if (1 != ((Variant)object).getShort()) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        object = properties.keys();
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            if (string2.equalsIgnoreCase("USER")) {
                string = properties.getProperty(string2);
                properties.remove(string2);
                properties.setProperty("UID", string);
                continue;
            }
            if (!string2.equalsIgnoreCase("PASSWORD")) continue;
            string = properties.getProperty(string2);
            properties.remove(string2);
            properties.setProperty("PWD", string);
        }
    }

    private void saveLoggingAttributes(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.regionMatches(true, 0, "log", 0, 3)) continue;
            SettingReader.storeSetting(string, properties.get(string).toString());
        }
    }
}

