/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.mapr.drill.dsi.exceptions.ConversionFailed;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public abstract class UnsignedBigIntJDBCDataSource
extends NumericJDBCDataSource {
    private static final BigInteger s_twoTo64 = BigInteger.valueOf(2L).pow(64);

    public UnsignedBigIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(long l, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                throw new RuntimeException("Unexpected fractional truncation!");
            }
            case OVERFLOW: {
                this.onOverflow(this.toNumber(l), string);
            }
        }
    }

    protected abstract long doGet() throws ErrorException;

    @Override
    public Number get() throws ErrorException {
        try {
            long l = this.doGet();
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return this.toNumber(l);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected final Number toNumber(long l) {
        if (l < 0L) {
            return this.negativeToUnsigned(l);
        }
        return l;
    }

    protected final BigInteger negativeToUnsigned(long l) {
        assert (l < 0L);
        return BigInteger.valueOf(l).add(s_twoTo64);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        if (l < 0L) {
            return this.negativeToUnsigned(l).toString();
        }
        return Long.toString(l);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.doGet() != 0L;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l > 127L || l < 0L) {
            this.onOverflow(l, "getByte");
        }
        return (byte)l;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l > 32767L || l < 0L) {
            this.onOverflow(l, "getShort");
        }
        return (short)l;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l > Integer.MAX_VALUE || l < 0L) {
            this.onOverflow(l, "getInt");
        }
        return (int)l;
    }

    @Override
    public long getLong() throws ErrorException, SQLException, ConversionFailed {
        long l = this.doGet();
        if (l < 0L) {
            this.onOverflow(this.negativeToUnsigned(l), "getLong");
        }
        return l;
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l < 0L) {
            return this.negativeToUnsigned(l).doubleValue();
        }
        return l;
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.doGet();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        if (l < 0L) {
            return new BigDecimal(this.negativeToUnsigned(l));
        }
        return BigDecimal.valueOf(l);
    }
}

