/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.mapr.drill.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.mapr.drill.dsi.exceptions.ConversionFailed;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class StringJDBCDataSource
extends ConvertingJDBCDataSource {
    public StringJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(String string, int n, String string2) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(string, n, string2);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(string, string2);
            }
        }
    }

    @Override
    public abstract String get() throws ErrorException;

    @Override
    public Reader getAsReader() throws ErrorException {
        String string = this.get();
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.get();
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return false;
        }
        return NonTrivialJDBCConversions.stringToBoolean(string);
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return 0;
        }
        string = string.trim();
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            byte by = NonTrivialJDBCConversions.DecimalConverter.toByte(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
            this.handleConversionResult(string, 0, "getByte");
            return by;
        }
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return 0;
        }
        string = string.trim();
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            short s = NonTrivialJDBCConversions.DecimalConverter.toShort(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
            this.handleConversionResult(string, 0, "getShort");
            return s;
        }
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return 0;
        }
        string = string.trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n = NonTrivialJDBCConversions.DecimalConverter.toInt(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
            this.handleConversionResult(string, 0, "getInt");
            return n;
        }
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return 0L;
        }
        string = string.trim();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            long l = NonTrivialJDBCConversions.DecimalConverter.toLong(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
            this.handleConversionResult(string, 0, "getLong");
            return l;
        }
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return 0.0;
        }
        return NonTrivialJDBCConversions.stringToDouble(string);
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return null;
        }
        return NonTrivialJDBCConversions.stringToBigDecimal(string);
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        } else if (!(calendar instanceof GregorianCalendar)) {
            throw new IllegalArgumentException("Cal must be an instance of GregorianCalendar");
        }
        return NonTrivialJDBCConversions.stringToDate(string, (GregorianCalendar)calendar);
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        } else if (!(calendar instanceof GregorianCalendar)) {
            throw new IllegalArgumentException("Cal must be an instance of GregorianCalendar");
        }
        return NonTrivialJDBCConversions.stringToTime(string, 3, (GregorianCalendar)calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        String string = this.get();
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        } else if (!(calendar instanceof GregorianCalendar)) {
            throw new IllegalArgumentException("Cal must be an instance of GregorianCalendar");
        }
        return NonTrivialJDBCConversions.stringToTimestamp(string, 9, (GregorianCalendar)calendar);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        return true;
    }
}

