/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.mapr.drill.dsi.exceptions.ConversionFailed;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class DoubleJDBCDataSource
extends NumericJDBCDataSource {
    public DoubleJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(double d, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(d, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(d, string);
            }
        }
    }

    @Override
    public Double get() throws ErrorException {
        try {
            double d = this.getDouble();
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return d;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        if (d == 0.0 && this.wasNull()) {
            return null;
        }
        return Double.toString(d);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getDouble() != 0.0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        byte by = NonTrivialJDBCConversions.DoubleConverter.toByte(d, this.getAndClearListener());
        this.handleConversionResult(d, "getByte");
        return by;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        short s = NonTrivialJDBCConversions.DoubleConverter.toShort(d, this.getAndClearListener());
        this.handleConversionResult(d, "getShort");
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        int n = NonTrivialJDBCConversions.DoubleConverter.toInt(d, this.getAndClearListener());
        this.handleConversionResult(d, "getInt");
        return n;
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(d, this.getAndClearListener());
        this.handleConversionResult(d, "getLong");
        return l;
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return (float)this.getDouble();
    }

    @Override
    public abstract double getDouble() throws ErrorException, SQLException;

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        double d = this.getDouble();
        if (d == 0.0 && this.wasNull()) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }
}

