/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.exceptions.ConversionFailed;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public abstract class DecimalJDBCDataSink
extends NumberJDBCDataSink<BigDecimal> {
    private static final int MAX_BYTE_DIGITS = 3;
    private static final int MAX_SHORT_DIGITS = 5;
    private static final int MAX_INT_DIGITS = 10;
    private static final int MAX_LONG_DIGITS = 19;
    private final short m_precision;
    private final short m_scale;

    public DecimalJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_precision = typeMetadata.getPrecision();
        this.m_scale = typeMetadata.getScale();
        if (this.m_precision <= 0) {
            throw new IllegalArgumentException("Precision must be positive");
        }
        if (this.m_scale < 0) {
            throw new IllegalArgumentException("Scale must be non-negative");
        }
        if (this.m_scale > this.m_precision) {
            throw new IllegalArgumentException("Scale cannot be greater than precision");
        }
    }

    protected final int getPrecision() {
        return this.m_precision;
    }

    protected final int getScale() {
        return this.m_scale;
    }

    protected void setFromBigDecimal(BigDecimal bigDecimal, String string) throws ErrorException, ConversionFailed {
        assert (bigDecimal != null);
        BigDecimal bigDecimal2 = NonTrivialJDBCConversions.checkPrecisionAndLimitScale(bigDecimal, this.m_precision, this.m_scale, this.getAndClearListener());
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(bigDecimal, this.m_scale, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(bigDecimal, string);
            }
        }
        this.doSet(bigDecimal2);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ConversionFailed, ErrorException {
        if (object == null) {
            this.doSet(null);
        } else if (object instanceof BigDecimal) {
            this.setFromBigDecimal((BigDecimal)object, "set");
        } else if (object instanceof BigInteger) {
            this.setFromBigDecimal(new BigDecimal((BigInteger)object), "set");
        } else if (object instanceof Number) {
            this.setFromBigDecimal(new BigDecimal(((Number)object).toString()), "set");
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigDecimal bigDecimal = BigDecimal.valueOf(by);
        if (this.m_precision < 3) {
            this.setFromBigDecimal(bigDecimal, "setByte");
        } else {
            this.doSet(bigDecimal);
        }
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigDecimal bigDecimal = BigDecimal.valueOf(s);
        if (this.m_precision < 5) {
            this.setFromBigDecimal(bigDecimal, "setShort");
        } else {
            this.doSet(bigDecimal);
        }
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigDecimal bigDecimal = BigDecimal.valueOf(n);
        if (this.m_precision < 10) {
            this.setFromBigDecimal(bigDecimal, "setInt");
        } else {
            this.doSet(bigDecimal);
        }
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        BigDecimal bigDecimal = BigDecimal.valueOf(l);
        if (this.m_precision < 19) {
            this.setFromBigDecimal(bigDecimal, "setLong");
        } else {
            this.doSet(bigDecimal);
        }
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setFromBigDecimal(BigDecimal.valueOf(f), "setFloat");
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setFromBigDecimal(BigDecimal.valueOf(d), "setDouble");
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setFromBigDecimal(bigDecimal, "setBigDecimal");
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionFailed(numberFormatException);
            }
            this.setFromBigDecimal(bigDecimal, "setString");
        }
    }
}

