/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCNumberConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCDecimalConverter
extends DRJDBCNumberConverter {
    private static final String TYPE_NAME = "Decimal";

    public static DRJDBCDecimalConverter getInstance() {
        return DRJDBCConverterHelper.INSTANCE;
    }

    @Override
    public BigDecimal getAsBigDecimal(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCDecimalConverter.getData(sqlAccessor, n);
    }

    @Override
    public byte getAsByte(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return DRJDBCDecimalConverter.getData(sqlAccessor, n).byteValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), arithmeticException.getMessage());
            errorException.initCause(arithmeticException);
            throw errorException;
        }
    }

    @Override
    public double getAsDouble(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCDecimalConverter.getData(sqlAccessor, n).doubleValue();
    }

    @Override
    public float getAsFloat(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCDecimalConverter.getData(sqlAccessor, n).floatValue();
    }

    @Override
    public int getAsInt(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return DRJDBCDecimalConverter.getData(sqlAccessor, n).intValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), arithmeticException.getMessage());
            errorException.initCause(arithmeticException);
            throw errorException;
        }
    }

    @Override
    public long getAsLong(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return DRJDBCDecimalConverter.getData(sqlAccessor, n).longValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), arithmeticException.getMessage());
            errorException.initCause(arithmeticException);
            throw errorException;
        }
    }

    @Override
    public short getAsShort(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return DRJDBCDecimalConverter.getData(sqlAccessor, n).shortValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), arithmeticException.getMessage());
            errorException.initCause(arithmeticException);
            throw errorException;
        }
    }

    private DRJDBCDecimalConverter() {
    }

    public static BigDecimal getData(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return sqlAccessor.getBigDecimal(n);
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static class DRJDBCConverterHelper {
        private static final DRJDBCDecimalConverter INSTANCE = new DRJDBCDecimalConverter();

        private DRJDBCConverterHelper() {
        }
    }
}

