/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCConnectionHelper {
    private static HashMap<String, Long> numericFunctions = new HashMap();
    private static HashMap<String, Long> systemFunctions = new HashMap();
    private static HashMap<String, Long> stringFunctions = new HashMap();
    private static HashMap<String, Long> dateTimeFunctions = new HashMap();
    private static HashMap<Integer, Long> supportedDataTypeConversions = new HashMap();
    private static HashMap<String, Long> datatypeToCVT = new HashMap();

    public static long getNumericFunctionCapability(List<String> list) {
        long l = 0L;
        for (String string : list) {
            if (!numericFunctions.containsKey(string)) continue;
            l |= numericFunctions.get(string).longValue();
        }
        return l;
    }

    public static long getStringFunctions(List<String> list) {
        long l = 0L;
        for (String string : list) {
            if (!stringFunctions.containsKey(string)) continue;
            l |= stringFunctions.get(string).longValue();
        }
        return l;
    }

    public static long getDateTimeFunctions(List<String> list) {
        long l = 0L;
        for (String string : list) {
            if (!dateTimeFunctions.containsKey(string)) continue;
            l |= dateTimeFunctions.get(string).longValue();
        }
        return l;
    }

    public static long getOuterJoinmap(List<UserProtos.OuterJoinSupport> list) {
        long l = 0L;
        for (UserProtos.OuterJoinSupport outerJoinSupport : list) {
            switch (outerJoinSupport.getNumber()) {
                case 7: {
                    l |= 0x40L;
                    break;
                }
                case 3: {
                    l |= 4L;
                    break;
                }
                case 6: {
                    l |= 0x20L;
                    break;
                }
                case 1: {
                    l |= 1L;
                    break;
                }
                case 4: {
                    l |= 8L;
                    break;
                }
                case 5: {
                    l |= 0x10L;
                    break;
                }
                case 2: {
                    l |= 2L;
                    break;
                }
            }
        }
        return l;
    }

    public static long getDateTimemap(List<UserProtos.DateTimeLiteralsSupport> list) {
        long l = 0L;
        if (null != list) {
            for (UserProtos.DateTimeLiteralsSupport dateTimeLiteralsSupport : list) {
                switch (dateTimeLiteralsSupport.getNumber()) {
                    case 1: {
                        l |= 1L;
                        break;
                    }
                    case 2: {
                        l |= 2L;
                        break;
                    }
                    case 3: {
                        l |= 4L;
                        break;
                    }
                    case 4: {
                        l |= 8L;
                        break;
                    }
                    case 5: {
                        l |= 0x10L;
                        break;
                    }
                    case 6: {
                        l |= 0x20L;
                        break;
                    }
                    case 7: {
                        l |= 0x40L;
                        break;
                    }
                    case 8: {
                        l |= 0x80L;
                        break;
                    }
                    case 9: {
                        l |= 0x100L;
                        break;
                    }
                    case 10: {
                        l |= 0x200L;
                        break;
                    }
                    case 11: {
                        l |= 0x400L;
                        break;
                    }
                    case 12: {
                        l |= 0x800L;
                        break;
                    }
                    case 14: {
                        l |= 0x2000L;
                        break;
                    }
                    case 15: {
                        l |= 0x4000L;
                        break;
                    }
                    case 16: {
                        l |= 0x8000L;
                        break;
                    }
                }
            }
        }
        return l;
    }

    public static long getSubQuerymap(List<UserProtos.SubQuerySupport> list) {
        long l = 0L;
        for (UserProtos.SubQuerySupport subQuerySupport : list) {
            switch (subQuerySupport.getNumber()) {
                case 1: {
                    l |= 0x10L;
                    break;
                }
                case 2: {
                    l |= 1L;
                    break;
                }
                case 3: {
                    l |= 2L;
                    break;
                }
                case 4: {
                    l |= 4L;
                    break;
                }
                case 5: {
                    l |= 8L;
                }
            }
        }
        return l;
    }

    public static HashMap<Integer, Long> checkAndSetDataconversion(List<UserProtos.ConvertSupport> list) throws ErrorException {
        if (null != list) {
            for (UserProtos.ConvertSupport convertSupport : list) {
                TypeProtos.MinorType minorType = convertSupport.getFrom();
                TypeProtos.MinorType minorType2 = convertSupport.getTo();
                switch (minorType.getNumber()) {
                    case 6: 
                    case 32: {
                        supportedDataTypeConversions.put(106, supportedDataTypeConversions.get(106) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 23: {
                        supportedDataTypeConversions.put(107, supportedDataTypeConversions.get(107) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 20: {
                        supportedDataTypeConversions.put(108, supportedDataTypeConversions.get(108) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 21: {
                        supportedDataTypeConversions.put(109, supportedDataTypeConversions.get(109) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 12: {
                        supportedDataTypeConversions.put(111, supportedDataTypeConversions.get(111) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 33: 
                    case 34: 
                    case 43: {
                        supportedDataTypeConversions.put(112, supportedDataTypeConversions.get(112) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 11: 
                    case 19: {
                        supportedDataTypeConversions.put(113, supportedDataTypeConversions.get(113) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 18: {
                        supportedDataTypeConversions.put(114, supportedDataTypeConversions.get(114) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 5: 
                    case 31: {
                        supportedDataTypeConversions.put(115, supportedDataTypeConversions.get(115) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 17: 
                    case 39: {
                        supportedDataTypeConversions.put(117, supportedDataTypeConversions.get(117) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 38: {
                        supportedDataTypeConversions.put(116, supportedDataTypeConversions.get(116) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 4: 
                    case 30: {
                        supportedDataTypeConversions.put(122, supportedDataTypeConversions.get(122) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 13: 
                    case 14: {
                        supportedDataTypeConversions.put(123, supportedDataTypeConversions.get(123) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 15: 
                    case 16: {
                        supportedDataTypeConversions.put(124, supportedDataTypeConversions.get(123) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 3: 
                    case 29: {
                        supportedDataTypeConversions.put(125, supportedDataTypeConversions.get(123) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 24: {
                        supportedDataTypeConversions.put(127, supportedDataTypeConversions.get(127) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 26: {
                        supportedDataTypeConversions.put(126, supportedDataTypeConversions.get(126) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 22: {
                        supportedDataTypeConversions.put(128, supportedDataTypeConversions.get(128) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                    case 25: {
                        supportedDataTypeConversions.put(130, supportedDataTypeConversions.get(130) | datatypeToCVT.get(minorType2.name()));
                        break;
                    }
                }
            }
        }
        return supportedDataTypeConversions;
    }

    public static long getSystemFunctions(List<String> list) {
        long l = 0L;
        for (String string : list) {
            if (!systemFunctions.containsKey(string)) continue;
            l |= systemFunctions.get(string).longValue();
        }
        return l;
    }

    public static long getGroupbysupport(UserProtos.GroupBySupport groupBySupport) {
        long l = 0L;
        switch (groupBySupport) {
            case GB_SELECT_ONLY: {
                l |= 1L;
                break;
            }
            case GB_BEYOND_SELECT: {
                l |= 2L;
                break;
            }
            case GB_UNRELATED: {
                l |= 3L;
                break;
            }
            default: {
                l |= 0L;
            }
        }
        return l;
    }

    private static void initiateNumericFunctionsMap() {
        numericFunctions.put("ABS", 1L);
        numericFunctions.put("ACOS", 2L);
        numericFunctions.put("ASIN", 4L);
        numericFunctions.put("ATAN", 8L);
        numericFunctions.put("ATAN2", 16L);
        numericFunctions.put("CEILING", 32L);
        numericFunctions.put("COS", 64L);
        numericFunctions.put("COT", 128L);
        numericFunctions.put("DEGREES", 262144L);
        numericFunctions.put("EXP", 256L);
        numericFunctions.put("FLOOR", 512L);
        numericFunctions.put("LOG", 1024L);
        numericFunctions.put("LOG10", 524288L);
        numericFunctions.put("MOD", 2048L);
        numericFunctions.put("PI", 65536L);
        numericFunctions.put("POWER", 0x100000L);
        numericFunctions.put("RADIANS", 0x200000L);
        numericFunctions.put("RAND", 131072L);
        numericFunctions.put("ROUND", 0x400000L);
        numericFunctions.put("SIGN", 4096L);
        numericFunctions.put("SIN", 8192L);
        numericFunctions.put("SQRT", 16384L);
        numericFunctions.put("TAN", 32768L);
        numericFunctions.put("TRUNCATE", 0x800000L);
    }

    private static void initiateStringFunctionsMap() {
        stringFunctions.put("ASCII", 8192L);
        stringFunctions.put("CHAR", 16384L);
        stringFunctions.put("CHAR_LENGTH", 0x100000L);
        stringFunctions.put("CHARACTER_LENGTH", 0x200000L);
        stringFunctions.put("CONCAT", 1L);
        stringFunctions.put("DIFFERENCE", 32768L);
        stringFunctions.put("INSERT", 2L);
        stringFunctions.put("LCASE", 64L);
        stringFunctions.put("LEFT", 4L);
        stringFunctions.put("BIT_LENGTH", 524288L);
        stringFunctions.put("LENGTH", 16L);
        stringFunctions.put("LOCATE", 32L);
        stringFunctions.put("LOCATE_2", 65536L);
        stringFunctions.put("LTRIM", 8L);
        stringFunctions.put("OCTET_LENGTH", 0x400000L);
        stringFunctions.put("POSITION", 0x800000L);
        stringFunctions.put("REPEAT", 128L);
        stringFunctions.put("REPLACE", 256L);
        stringFunctions.put("RIGHT", 512L);
        stringFunctions.put("RTRIM", 1024L);
        stringFunctions.put("SOUNDEX", 131072L);
        stringFunctions.put("SPACE", 262144L);
        stringFunctions.put("SUBSTRING", 2048L);
        stringFunctions.put("UCASE", 4096L);
    }

    private static void initiateDateTimeFunctionsMap() {
        dateTimeFunctions.put("CURDATE", 2L);
        dateTimeFunctions.put("CURTIME", 512L);
        dateTimeFunctions.put("DATE", 131072L);
        dateTimeFunctions.put("CURRENT_DATE", 131072L);
        dateTimeFunctions.put("CURRENT_TIME", 262144L);
        dateTimeFunctions.put("DAYNAME", 32768L);
        dateTimeFunctions.put("DAYOFMONTH", 4L);
        dateTimeFunctions.put("DAYOFWEEK", 8L);
        dateTimeFunctions.put("DAYOFYEAR", 16L);
        dateTimeFunctions.put("EXTRACT", 0x100000L);
        dateTimeFunctions.put("HOUR", 1024L);
        dateTimeFunctions.put("MINUTE", 2048L);
        dateTimeFunctions.put("MONTH", 32L);
        dateTimeFunctions.put("MONTHNAME", 65536L);
        dateTimeFunctions.put("NOW", 1L);
        dateTimeFunctions.put("QUARTER", 64L);
        dateTimeFunctions.put("SECOND", 4096L);
        dateTimeFunctions.put("TIME", 262144L);
        dateTimeFunctions.put("TIMESTAMP", 524288L);
        dateTimeFunctions.put("TIMESTAMPADD", 8192L);
        dateTimeFunctions.put("TIMESTAMPDIFF", 16384L);
        dateTimeFunctions.put("WEEK", 128L);
        dateTimeFunctions.put("YEAR", 256L);
    }

    private static void initiateDatatypeToCVTMap() {
        datatypeToCVT.put("BIGINT", 16384L);
        datatypeToCVT.put("UINT8", 16384L);
        datatypeToCVT.put("BIT", 4096L);
        datatypeToCVT.put("DATE", 32768L);
        datatypeToCVT.put("DECIMAL18", 4L);
        datatypeToCVT.put("DECIMAL28DENSE", 4L);
        datatypeToCVT.put("DECIMAL28SPARSE", 4L);
        datatypeToCVT.put("DECIMAL38DENSE", 4L);
        datatypeToCVT.put("DECIMAL38SPARSE", 4L);
        datatypeToCVT.put("DECIMAL9", 4L);
        datatypeToCVT.put("VARDECIMAL", 4L);
        datatypeToCVT.put("FIXED16CHAR", 0x200000L);
        datatypeToCVT.put("FIXEDBINARY", 1024L);
        datatypeToCVT.put("FIXEDCHAR", 1L);
        datatypeToCVT.put("FLOAT4", 32L);
        datatypeToCVT.put("FLOAT8", 128L);
        datatypeToCVT.put("MONEY", 128L);
        datatypeToCVT.put("GENERIC_OBJECT", 256L);
        datatypeToCVT.put("LATE", 256L);
        datatypeToCVT.put("LIST", 256L);
        datatypeToCVT.put("MAP", 256L);
        datatypeToCVT.put("NULL", 256L);
        datatypeToCVT.put("UNION", 256L);
        datatypeToCVT.put("VARCHAR", 256L);
        datatypeToCVT.put("INT", 8L);
        datatypeToCVT.put("UINT4", 8L);
        datatypeToCVT.put("INTERVAL", 0x100000L);
        datatypeToCVT.put("INTERVALDAY", 0x100000L);
        datatypeToCVT.put("INTERVALYEAR", 524288L);
        datatypeToCVT.put("SMALLINT", 16L);
        datatypeToCVT.put("UINT2", 16L);
        datatypeToCVT.put("TIME", 65536L);
        datatypeToCVT.put("TIMETZ", 65536L);
        datatypeToCVT.put("TIMESTAMP", 131072L);
        datatypeToCVT.put("TIMESTAMPTZ", 131072L);
        datatypeToCVT.put("TINYINT", 8192L);
        datatypeToCVT.put("UINT1", 8192L);
        datatypeToCVT.put("VAR16CHAR", 0x800000L);
        datatypeToCVT.put("VARBINARY", 2048L);
    }

    private static void initiateSystemFunctionMap() {
        systemFunctions.put("DBNAME", 2L);
        systemFunctions.put("IFNULL", 4L);
        systemFunctions.put("USERNAME", 1L);
    }

    private static void initiateDataTypeSupport() {
        supportedDataTypeConversions.put(106, 0L);
        supportedDataTypeConversions.put(107, 0L);
        supportedDataTypeConversions.put(108, 0L);
        supportedDataTypeConversions.put(109, 0L);
        supportedDataTypeConversions.put(111, 0L);
        supportedDataTypeConversions.put(112, 0L);
        supportedDataTypeConversions.put(113, 0L);
        supportedDataTypeConversions.put(114, 0L);
        supportedDataTypeConversions.put(115, 0L);
        supportedDataTypeConversions.put(117, 0L);
        supportedDataTypeConversions.put(116, 0L);
        supportedDataTypeConversions.put(118, 0L);
        supportedDataTypeConversions.put(119, 0L);
        supportedDataTypeConversions.put(120, 0L);
        supportedDataTypeConversions.put(121, 0L);
        supportedDataTypeConversions.put(122, 0L);
        supportedDataTypeConversions.put(123, 0L);
        supportedDataTypeConversions.put(124, 0L);
        supportedDataTypeConversions.put(125, 0L);
        supportedDataTypeConversions.put(126, 0L);
        supportedDataTypeConversions.put(127, 0L);
        supportedDataTypeConversions.put(128, 0L);
        supportedDataTypeConversions.put(129, 0L);
        supportedDataTypeConversions.put(130, 0L);
    }

    static {
        DRJDBCConnectionHelper.initiateNumericFunctionsMap();
        DRJDBCConnectionHelper.initiateStringFunctionsMap();
        DRJDBCConnectionHelper.initiateDateTimeFunctionsMap();
        DRJDBCConnectionHelper.initiateDatatypeToCVTMap();
        DRJDBCConnectionHelper.initiateSystemFunctionMap();
        DRJDBCConnectionHelper.initiateDataTypeSupport();
    }
}

