/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.google.common.base.Joiner;
import com.google.protobuf.ProtocolStringList;
import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.commons.SettingsKeys;
import com.mapr.drill.drill.core.DRJDBCConnectionHelper;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.core.DRJDBCEnvironment;
import com.mapr.drill.drill.core.DRJDBCPropertyKey;
import com.mapr.drill.drill.core.DRJDBCStatement;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.core.impl.DSIConnection;
import com.mapr.drill.dsi.core.impl.DSILogger;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.core.utilities.ConnSettingRequestMap;
import com.mapr.drill.dsi.core.utilities.ConnSettingResponseMap;
import com.mapr.drill.dsi.core.utilities.PropertyUtilities;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.exceptions.BadAttrValException;
import com.mapr.drill.dsi.exceptions.BadAuthException;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.dsi.exceptions.NumericOverflowException;
import com.mapr.drill.jdbc.common.CommonCoreUtils;
import com.mapr.drill.jdbc.common.ProductInfoHandler;
import com.mapr.drill.jdbc.utils.DSCatalogStripUtil;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Warning;
import com.mapr.drill.support.WarningCode;
import com.mapr.drill.support.exceptions.DiagState;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.drill.common.Version;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private static final String LOG_PREFIX_NAME = "DrillJDBC_connection_";
    private static final int DOUBLE_DIGIT_MIN = 10;
    private static final String ZERO_STR = "0";
    private static final String DOT = ".";
    private static final int VERSION_PATCH_MIN_LEN = 4;
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 65535;
    private static final int USE_QUERY_METHOD_VALUE = 1;
    private static final int USE_METADATA_API_VALUE = 0;
    private static final String UNRELATED = "OB_UNRELATED";
    private static final String EXPRESSION = "OB_EXPRESSION";
    private static final String DEFAULT_CATALOG_NAME = "DRILL";
    private DRJDBCClient m_client;
    private DRJDBCConnectionSettings m_settings;
    protected ILogger m_logger;
    private Set<String> m_definedSettings = new HashSet<String>();
    private ProductInfoHandler m_productInfoHandler = new ProductInfoHandler("MapRDrillJDBCDriver.lic", "MapR Drill JDBC Driver", "1.6.10.1003", DRJDBCDriver.class);
    private String m_catalogSearchPattern;

    public DRJDBCConnection(DRJDBCEnvironment dRJDBCEnvironment) throws ErrorException {
        super(dRJDBCEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), dRJDBCEnvironment);
        ++s_connectionID;
        this.setDefaultProperties();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_client) {
            this.m_client.closeSession();
        }
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        String string;
        String[] stringArray;
        CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, String.valueOf(1), String.valueOf(6), String.valueOf(10), String.valueOf(1003));
        try {
            this.m_productInfoHandler.validateLicense();
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.LICENSE_VALIDATION_ERROR.name(), (Throwable)exception);
        }
        this.m_settings = this.getConnectionSettings(connSettingRequestMap);
        Properties properties = new Properties();
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        DRJDBCPropertyKey.initConnStrKeys(this.m_definedSettings);
        if (this.m_settings.isDirect().booleanValue()) {
            treeMap.put("drillbit", connSettingRequestMap.getProperty("drillbit").getString().trim());
        } else {
            treeMap.put("zk", connSettingRequestMap.getProperty("zk").getString().trim());
        }
        if (connSettingRequestMap.containsKey("UID")) {
            treeMap.put("user", connSettingRequestMap.getProperty("UID").getString());
        }
        if (connSettingRequestMap.containsKey("PWD")) {
            treeMap.put("password", connSettingRequestMap.getProperty("PWD").getString());
        }
        if (null != this.getOptionalSetting("DelegationUID", connSettingRequestMap)) {
            treeMap.put("impersonation_target", connSettingRequestMap.getProperty("DelegationUID").getString());
        }
        if (null != this.getOptionalSetting("AuthMech", connSettingRequestMap)) {
            treeMap.put("auth", connSettingRequestMap.getProperty("AuthMech").getString());
        } else if (null != this.getOptionalSetting("auth", connSettingRequestMap)) {
            treeMap.put("auth", connSettingRequestMap.getProperty("auth").getString());
        }
        if (null != this.getOptionalSetting("KrbRealm", connSettingRequestMap)) {
            treeMap.put("realm", connSettingRequestMap.getProperty("KrbRealm").getString());
        } else if (null != this.getOptionalSetting("realm", connSettingRequestMap)) {
            treeMap.put("realm", connSettingRequestMap.getProperty("realm").getString());
        }
        if (null != this.getOptionalSetting("KrbServiceName", connSettingRequestMap)) {
            treeMap.put("service_name", connSettingRequestMap.getProperty("KrbServiceName").getString());
        } else if (null != this.getOptionalSetting("service_name", connSettingRequestMap)) {
            treeMap.put("service_name", connSettingRequestMap.getProperty("service_name").getString());
        }
        if (null != this.getOptionalSetting("KrbHostFQDN", connSettingRequestMap)) {
            treeMap.put("service_host", connSettingRequestMap.getProperty("KrbHostFQDN").getString());
        } else if (null != this.getOptionalSetting("service_host", connSettingRequestMap)) {
            treeMap.put("service_host", connSettingRequestMap.getProperty("service_host").getString());
        }
        if (null != this.getOptionalSetting("KrbPrincipal", connSettingRequestMap)) {
            treeMap.put("principal", connSettingRequestMap.getProperty("KrbPrincipal").getString());
        } else if (null != this.getOptionalSetting("principal", connSettingRequestMap)) {
            treeMap.put("principal", connSettingRequestMap.getProperty("principal").getString());
        }
        if (null != this.getOptionalSetting("KrbKeytab", connSettingRequestMap)) {
            treeMap.put("keytab", connSettingRequestMap.getProperty("KrbKeytab").getString());
        } else if (null != this.getOptionalSetting("keytab", connSettingRequestMap)) {
            treeMap.put("keytab", connSettingRequestMap.getProperty("keytab").getString());
        }
        if (null != this.getOptionalSetting("schema", connSettingRequestMap)) {
            treeMap.put("schema", connSettingRequestMap.getProperty("schema").getString());
        }
        properties.putAll((Map<?, ?>)treeMap);
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (this.m_definedSettings.contains(stringArray.toLowerCase())) continue;
            string = connSettingRequestMap.getProperty((String)stringArray).getString().trim();
            properties.put(stringArray, string);
        }
        this.m_client = new DRJDBCClient(this.m_settings, properties, this.getWarningListener(), this.getConnectionLog());
        this.initDatabaseMetadataInfo();
        stringArray = null;
        if (this.m_client.hasMetadataAPISupport()) {
            stringArray = this.m_client.getCatalogNames();
        }
        this.m_catalogSearchPattern = null != stringArray ? DSCatalogStripUtil.generateCatalogsPattern(stringArray) : DSCatalogStripUtil.generateCatalogPattern(DEFAULT_CATALOG_NAME);
        string = DEFAULT_CATALOG_NAME;
        if (null != stringArray && 0 < stringArray.length) {
            string = stringArray[0];
        }
        if (SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED == this.m_settings.getCatalogSupport()) {
            try {
                this.setProperty(22, new Variant(0, string));
            }
            catch (Exception exception) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getMessage());
            }
        }
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new DRJDBCStatement(this);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_client) {
            this.m_client.closeSession();
        }
    }

    @Override
    public ILogger getConnectionLog() {
        if (this.m_logger == null) {
            this.m_logger = new DSILogger(LOG_PREFIX_NAME + Integer.toString(s_connectionID));
            this.m_logger.setLocale(this.getLocale());
        }
        return this.m_logger;
    }

    public DRJDBCConnectionSettings getConnectionSettings() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_settings;
    }

    public DRJDBCClient getDrillClient() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_client;
    }

    @Override
    public String toNativeSQL(String string) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        return this.m_settings.isRemoveCatalog() ? DSCatalogStripUtil.stripCatalog(string, this.m_catalogSearchPattern) : string;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String string : DRJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    private DRJDBCConnectionSettings getConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        boolean bl;
        String string = null;
        Variant variant = this.getOptionalSetting("drillbit", connSettingRequestMap);
        if (variant != null) {
            string = "drillbit=" + variant.getString();
        }
        String string2 = null;
        variant = this.getOptionalSetting("zk", connSettingRequestMap);
        if (variant != null) {
            string2 = "zk=" + variant.getString();
        }
        String string3 = null;
        variant = this.getOptionalSetting("UID", connSettingRequestMap);
        if (variant != null) {
            string3 = variant.getString();
        }
        String string4 = null;
        variant = this.getOptionalSetting("PWD", connSettingRequestMap);
        if (variant != null) {
            string4 = variant.getString();
        }
        Boolean bl2 = null;
        variant = this.getOptionalSetting("castAnyToVarchar", connSettingRequestMap);
        if (variant != null && !(bl2 = Boolean.valueOf(Boolean.parseBoolean(variant.getString()))).booleanValue() && !variant.getString().equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.getWarningListener().postWarning(new Warning(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, 101, DRJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{variant.getString(), "castAnyToVarchar", "true or false on whether to cast data type ANY to data typeVARCHAR. Falling back to default value false"}));
        }
        String string5 = null;
        variant = this.getOptionalSetting("excludedSchemas", connSettingRequestMap);
        if (null != variant) {
            string5 = variant.getString();
        }
        String string6 = null;
        variant = this.getOptionalSetting("includedSchemas", connSettingRequestMap);
        if (null != variant) {
            string6 = variant.getString();
        }
        DRJDBCConnectionSettings.MetadataQueryMode metadataQueryMode = DRJDBCConnectionSettings.MetadataQueryMode.CHECK_SERVER;
        variant = this.getOptionalSetting("GetMetadataWithQueries", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                switch (variant.getInt()) {
                    case 1: {
                        metadataQueryMode = DRJDBCConnectionSettings.MetadataQueryMode.USE_QUERY_METHOD;
                        break;
                    }
                    case 0: {
                        metadataQueryMode = DRJDBCConnectionSettings.MetadataQueryMode.USE_METADATA_API;
                        break;
                    }
                    default: {
                        metadataQueryMode = DRJDBCConnectionSettings.MetadataQueryMode.CHECK_SERVER;
                        break;
                    }
                }
            }
            catch (NumericOverflowException numericOverflowException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, numericOverflowException.getMessage());
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, incorrectTypeException.getMessage());
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{"Entered value- " + variant.getString() + " is incorrect. Expected either 1 or 0"}, (Throwable)errorException);
            }
        }
        int n = 65535;
        variant = this.getOptionalSetting("StringColumnLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                n = variant.getInt();
            }
        }
        catch (Exception exception) {
            LogUtilities.logInfo("Setting default string column length: " + n, this.getConnectionLog());
        }
        int n2 = 2;
        variant = this.getOptionalSetting("NumNettyDirectArenas", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                n2 = variant.getInt();
            }
        }
        catch (Exception exception) {
            LogUtilities.logInfo("Setting default number of direct arenas: " + n2, this.getConnectionLog());
        }
        boolean bl3 = true;
        variant = this.getOptionalSetting("RemoveQryCatalog", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                bl3 = 0 != variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = 0L;
        variant = this.getOptionalSetting("NettyMaxDirectMem", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0L < variant.getLong()) {
                l = variant.getLong();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SettingsKeys.CATALOG_SUPPORT_ENUM cATALOG_SUPPORT_ENUM = SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED;
        variant = this.getOptionalSetting("CatalogSupport", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                String string7 = variant.getString().trim();
                if (SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED.name().equalsIgnoreCase(string7)) {
                    cATALOG_SUPPORT_ENUM = SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED;
                } else if (SettingsKeys.CATALOG_SUPPORT_ENUM.NOT_SUPPORTED.name().equalsIgnoreCase(string7)) {
                    cATALOG_SUPPORT_ENUM = SettingsKeys.CATALOG_SUPPORT_ENUM.NOT_SUPPORTED;
                } else if (SettingsKeys.CATALOG_SUPPORT_ENUM.LEGACY.name().equalsIgnoreCase(string7)) {
                    cATALOG_SUPPORT_ENUM = SettingsKeys.CATALOG_SUPPORT_ENUM.LEGACY;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDrillCatalogSupport(SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED == cATALOG_SUPPORT_ENUM);
        boolean bl4 = true;
        variant = this.getOptionalSetting("UseComplexTypeToJson", connSettingRequestMap);
        try {
            if (null != variant && 0 == variant.getInt()) {
                bl4 = false;
            }
        }
        catch (Exception exception) {
            LogUtilities.logDebug("The value for property UseComplexTypeToJson is invalid.", this.m_logger);
        }
        variant = this.getOptionalSetting("UpdateColMetadataOnSchemaChange", connSettingRequestMap);
        switch ("MapR".toLowerCase()) {
            case "mapr": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                bl = 0 != variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl5 = true;
        variant = this.getOptionalSetting("ParseAndSkipRowCountQryResultSets", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                bl5 = 0 != variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 65535;
        variant = this.getOptionalSetting("RepeatedModeColumnDisplaySize", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                n3 = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl6 = true;
        variant = this.getOptionalSetting("EnableRowCountQuerySupport", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty()) {
                bl6 = 0 != variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DRJDBCConnectionSettings.DRJDBCConnectionSettingsBuilder().setDrillbit(string).setZooKeeper(string2).setUsername(string3).setPassword(string4).setAnyToVarchar(bl2).setExcludedSchemas(string5).setIncludedSchemas(string6).setQueryMode(metadataQueryMode).setStringColumnLength(n).setNettyDArenas(n2).setMaxDirectMem(l).setCatalogSupport(cATALOG_SUPPORT_ENUM).setUseComplexTypeToJson(bl4).setRemoveCatalog(bl3).setUpdateColMetadataOnSchemaChange(bl).setFetchResultsetForRowCountQueries(bl5).setRepeatModeColumnSize(n3).setRowCountQuerySupport(bl6).setLogger(this.m_logger).setWarningListener(this.getWarningListener()).build();
    }

    private void initDatabaseMetadataInfo() throws ErrorException {
        try {
            Version version;
            String string = this.m_client.getServerName();
            if (null != string) {
                this.setProperty(41, new Variant(0, string));
            }
            if (null != (version = this.m_client.getServerVersionInfo())) {
                int n = version.getMajorVersion();
                int n2 = version.getMinorVersion();
                int n3 = version.getPatchVersion();
                String string2 = (n < 10 ? ZERO_STR : "") + n + DOT + (n2 < 10 ? ZERO_STR : "") + n2 + DOT;
                String string3 = String.valueOf(n3);
                for (int i = 0; i < 4 - string3.length(); ++i) {
                    string2 = string2 + ZERO_STR;
                }
                string2 = string2 + n3;
                this.setProperty(42, new Variant(0, string2));
            }
            if (this.m_client.hasMetadataAPISupport()) {
                this.setConnectionPropertiesWithNativeAPI();
            }
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{exception.getMessage()}, (Throwable)exception);
        }
    }

    private void setDrillCatalogSupport(boolean bl) throws ErrorException {
        try {
            if (bl) {
                this.setProperty(9, new Variant(0, "Y"));
                this.setProperty(11, new Variant(0, "catalog"));
                this.setProperty(12, new Variant(3, 4L));
            } else {
                this.setProperty(9, new Variant(0, "N"));
                this.setProperty(11, new Variant(0, ""));
                this.setProperty(12, new Variant(3, 0L));
            }
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getMessage());
        }
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            PropertyUtilities.setReadOnly(this, true);
            PropertyUtilities.setCatalogSupport(this, false);
            PropertyUtilities.setSavepointSupport(this, false);
            PropertyUtilities.setStoredProcedureSupport(this, false);
            PropertyUtilities.setStoredFunctionsCallsSupport(this, false);
            PropertyUtilities.setSchemaSupport(this, true);
            this.setProperty(100, new Variant(3, 5L));
            this.setProperty(101, new Variant(0, "DrillJDBC"));
            this.setProperty(41, new Variant(0, DEFAULT_CATALOG_NAME));
            this.setProperty(139, new Variant(0, "User"));
            this.setProperty(26, new Variant(3, 0L));
            this.setProperty(45, new Variant(3, 0L));
            this.setProperty(58, new Variant(0, "`"));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0000')));
            this.setProperty(139, new Variant(0, "User"));
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getMessage());
        }
    }

    private void setConnectionPropertiesWithNativeAPI() throws Exception {
        List list;
        List list2;
        ProtocolStringList protocolStringList;
        ProtocolStringList protocolStringList2;
        List list3;
        ProtocolStringList protocolStringList3;
        List list4;
        Joiner joiner;
        Object object2;
        List list5;
        List list6;
        HashMap<Integer, Long> hashMap;
        UserProtos.ServerMeta serverMeta = null;
        serverMeta = ((UserProtos.GetServerMetaResp)this.m_client.getServerMeta().get()).getServerMeta();
        if (null == serverMeta) {
            throw new Exception("Failed to get servermetadata");
        }
        if (serverMeta.getAllTablesSelectable()) {
            this.setProperty(2, new Variant(0, "Y"));
        } else {
            this.setProperty(2, new Variant(0, "N"));
        }
        if (serverMeta.hasCatalogAtStart()) {
            if (serverMeta.getCatalogAtStart()) {
                this.setProperty(8, new Variant(2, Character.valueOf('\u0001')));
            } else {
                this.setProperty(8, new Variant(2, Character.valueOf('\u0002')));
            }
        }
        if (serverMeta.hasCatalogSeparator()) {
            this.setProperty(10, new Variant(0, serverMeta.getCatalogSeparator()));
        }
        if (serverMeta.hasCatalogTerm()) {
            this.setProperty(11, new Variant(0, serverMeta.getCatalogTerm()));
        }
        if (serverMeta.hasColumnAliasingSupported()) {
            if (serverMeta.getColumnAliasingSupported()) {
                this.setProperty(14, new Variant(0, "Y"));
            } else {
                this.setProperty(14, new Variant(0, "N"));
            }
        }
        if (serverMeta.hasNullPlusNonNullEqualsNull()) {
            if (serverMeta.getNullPlusNonNullEqualsNull()) {
                this.setProperty(15, new Variant(2, Character.valueOf('\u0000')));
            } else {
                this.setProperty(15, new Variant(2, Character.valueOf('\u0001')));
            }
        }
        if ((hashMap = DRJDBCConnectionHelper.checkAndSetDataconversion(list6 = serverMeta.getConvertSupportList())).containsKey(106) && null != hashMap.get(106)) {
            this.setProperty(106, new Variant(3, hashMap.get(106)));
        }
        if (hashMap.containsKey(107) && null != hashMap.get(107)) {
            this.setProperty(107, new Variant(3, hashMap.get(107)));
        }
        if (hashMap.containsKey(108) && null != hashMap.get(108)) {
            this.setProperty(108, new Variant(3, hashMap.get(108)));
        }
        if (hashMap.containsKey(109) && null != hashMap.get(109)) {
            this.setProperty(109, new Variant(3, hashMap.get(109)));
        }
        if (hashMap.containsKey(111) && null != hashMap.get(111)) {
            this.setProperty(111, new Variant(3, hashMap.get(111)));
        }
        if (hashMap.containsKey(112) && null != hashMap.get(112)) {
            this.setProperty(112, new Variant(3, hashMap.get(112)));
        }
        if (hashMap.containsKey(113) && null != hashMap.get(113)) {
            this.setProperty(113, new Variant(3, hashMap.get(113)));
        }
        if (hashMap.containsKey(114) && null != hashMap.get(114)) {
            this.setProperty(114, new Variant(3, hashMap.get(114)));
        }
        if (hashMap.containsKey(115) && null != hashMap.get(115)) {
            this.setProperty(115, new Variant(3, hashMap.get(115)));
        }
        if (hashMap.containsKey(117) && null != hashMap.get(117)) {
            this.setProperty(117, new Variant(3, hashMap.get(117)));
        }
        if (hashMap.containsKey(116) && null != hashMap.get(116)) {
            this.setProperty(116, new Variant(3, hashMap.get(116)));
        }
        if (hashMap.containsKey(118) && null != hashMap.get(118)) {
            this.setProperty(118, new Variant(3, hashMap.get(118)));
        }
        if (hashMap.containsKey(119) && null != hashMap.get(119)) {
            this.setProperty(119, new Variant(3, hashMap.get(119)));
        }
        if (hashMap.containsKey(120) && null != hashMap.get(120)) {
            this.setProperty(120, new Variant(3, hashMap.get(120)));
        }
        if (hashMap.containsKey(121) && null != hashMap.get(121)) {
            this.setProperty(121, new Variant(3, hashMap.get(121) | 0x40L));
        }
        if (hashMap.containsKey(122) && null != hashMap.get(122)) {
            this.setProperty(122, new Variant(3, hashMap.get(122)));
        }
        if (hashMap.containsKey(123) && null != hashMap.get(123)) {
            this.setProperty(123, new Variant(3, hashMap.get(123)));
        }
        if (hashMap.containsKey(124) && null != hashMap.get(124)) {
            this.setProperty(124, new Variant(3, hashMap.get(124)));
        }
        if (hashMap.containsKey(125) && null != hashMap.get(125)) {
            this.setProperty(125, new Variant(3, hashMap.get(125)));
        }
        if (hashMap.containsKey(126) && null != hashMap.get(126)) {
            this.setProperty(126, new Variant(3, hashMap.get(126)));
        }
        if (hashMap.containsKey(127) && null != hashMap.get(127)) {
            this.setProperty(127, new Variant(3, hashMap.get(127)));
        }
        if (hashMap.containsKey(128) && null != hashMap.get(128)) {
            this.setProperty(128, new Variant(3, hashMap.get(128)));
        }
        if (hashMap.containsKey(129) && null != hashMap.get(129)) {
            this.setProperty(129, new Variant(3, hashMap.get(129)));
        }
        if (hashMap.containsKey(130) && null != hashMap.get(130)) {
            this.setProperty(130, new Variant(3, hashMap.get(130)));
        }
        if (serverMeta.hasCorrelationNamesSupport()) {
            switch (serverMeta.getCorrelationNamesSupport().getNumber()) {
                case 2: {
                    this.setProperty(28, new Variant(2, Character.valueOf('\u0001')));
                    break;
                }
                case 1: {
                    this.setProperty(28, new Variant(2, Character.valueOf('\u0000')));
                    break;
                }
                default: {
                    this.setProperty(28, new Variant(2, Character.valueOf('\u0002')));
                }
            }
        }
        if (null != (list5 = serverMeta.getDateTimeLiteralsSupportList())) {
            this.setProperty(43, new Variant(3, DRJDBCConnectionHelper.getDateTimemap(list5)));
        }
        if (null != serverMeta.getCollateSupportList()) {
            for (Object object2 : serverMeta.getCollateSupportList()) {
                if (1 != object2.getNumber()) continue;
                this.setProperty(56, new Variant(2, Character.valueOf('\u0004')));
                break;
            }
        } else if (serverMeta.hasGroupBySupport()) {
            this.setProperty(56, new Variant(2, Character.valueOf((char)DRJDBCConnectionHelper.getGroupbysupport(serverMeta.getGroupBySupport()))));
        }
        if (serverMeta.hasIdentifierCasing()) {
            switch (serverMeta.getIdentifierCasing().getNumber()) {
                case 1: {
                    this.setProperty(57, new Variant(2, Character.valueOf('\u0002')));
                    break;
                }
                case 2: {
                    this.setProperty(57, new Variant(2, Character.valueOf('\u0004')));
                    break;
                }
                case 3: {
                    this.setProperty(57, new Variant(2, Character.valueOf('\u0001')));
                    break;
                }
                case 4: {
                    this.setProperty(57, new Variant(2, Character.valueOf('\u0003')));
                    break;
                }
            }
        }
        ProtocolStringList protocolStringList4 = serverMeta.getSqlKeywordsList();
        object2 = "";
        if (null != protocolStringList4) {
            joiner = Joiner.on((String)",").skipNulls();
            object2 = joiner.join((Iterable)protocolStringList4);
            this.setProperty(62, new Variant(0, object2));
        }
        if (serverMeta.hasLikeEscapeClauseSupported()) {
            if (serverMeta.getLikeEscapeClauseSupported()) {
                this.setProperty(63, new Variant(0, "Y"));
            } else {
                this.setProperty(63, new Variant(0, "N"));
            }
        }
        if (serverMeta.hasMaxBinaryLiteralLength()) {
            this.setProperty(65, new Variant(3, serverMeta.getMaxBinaryLiteralLength()));
        }
        if (serverMeta.hasMaxCatalogNameLength()) {
            this.setProperty(66, new Variant(2, Character.valueOf((char)serverMeta.getMaxCatalogNameLength())));
        }
        if (serverMeta.hasMaxCharLiteralLength()) {
            this.setProperty(67, new Variant(3, serverMeta.getMaxCharLiteralLength()));
        }
        if (serverMeta.hasMaxColumnNameLength()) {
            this.setProperty(68, new Variant(2, Character.valueOf((char)serverMeta.getMaxColumnNameLength())));
        }
        if (serverMeta.hasMaxColumnsInGroupBy()) {
            this.setProperty(69, new Variant(2, Character.valueOf((char)serverMeta.getMaxColumnsInGroupBy())));
        }
        if (serverMeta.hasMaxColumnsInOrderBy()) {
            this.setProperty(71, new Variant(2, Character.valueOf((char)serverMeta.getMaxColumnsInOrderBy())));
        }
        if (serverMeta.hasMaxColumnsInSelect()) {
            this.setProperty(72, new Variant(2, Character.valueOf((char)serverMeta.getMaxColumnsInSelect())));
        }
        if (serverMeta.hasMaxCursorNameLength()) {
            this.setProperty(75, new Variant(2, Character.valueOf((char)serverMeta.getMaxCursorNameLength())));
        }
        if (serverMeta.hasMaxStatements()) {
            this.setProperty(64, new Variant(3, serverMeta.getMaxStatements()));
        }
        if (serverMeta.hasMaxRowSize()) {
            this.setProperty(79, new Variant(3, serverMeta.getMaxRowSize()));
        }
        if (serverMeta.hasBlobIncludedInMaxRowSize()) {
            if (serverMeta.getBlobIncludedInMaxRowSize()) {
                this.setProperty(80, new Variant(0, "Y"));
            } else {
                this.setProperty(80, new Variant(0, "N"));
            }
        }
        if (serverMeta.hasMaxSchemaNameLength()) {
            this.setProperty(81, new Variant(2, Character.valueOf((char)serverMeta.getMaxSchemaNameLength())));
        }
        if (serverMeta.hasMaxStatementLength()) {
            this.setProperty(82, new Variant(3, serverMeta.getMaxStatementLength()));
        }
        if (serverMeta.hasMaxTableNameLength()) {
            this.setProperty(83, new Variant(2, Character.valueOf((char)serverMeta.getMaxTableNameLength())));
        }
        if (serverMeta.hasMaxTablesInSelect()) {
            this.setProperty(84, new Variant(2, Character.valueOf((char)serverMeta.getMaxTablesInSelect())));
        }
        if (serverMeta.hasMaxUserNameLength()) {
            this.setProperty(85, new Variant(2, Character.valueOf((char)serverMeta.getMaxUserNameLength())));
        }
        if (serverMeta.hasNullCollation()) {
            switch (serverMeta.getNullCollation().getNumber()) {
                case 2: {
                    this.setProperty(89, new Variant(2, Character.valueOf('\u0004')));
                    break;
                }
                case 1: {
                    this.setProperty(89, new Variant(2, Character.valueOf('\u0002')));
                    break;
                }
                case 3: {
                    this.setProperty(89, new Variant(2, Character.valueOf('\u0000')));
                    break;
                }
                default: {
                    this.setProperty(89, new Variant(2, Character.valueOf('\u0001')));
                }
            }
        }
        if (null != (joiner = serverMeta.getNumericFunctionsList())) {
            this.setProperty(90, new Variant(3, DRJDBCConnectionHelper.getNumericFunctionCapability((List<String>)joiner)));
        }
        if (null != (list4 = serverMeta.getOuterJoinSupportList())) {
            this.setProperty(92, new Variant(3, DRJDBCConnectionHelper.getOuterJoinmap(list4)));
        }
        if (serverMeta.hasQuotedIdentifierCasing()) {
            switch (serverMeta.getQuotedIdentifierCasing().getNumber()) {
                case 1: {
                    this.setProperty(98, new Variant(2, Character.valueOf('\u0002')));
                }
                case 2: {
                    this.setProperty(98, new Variant(2, Character.valueOf('\u0004')));
                }
                case 3: {
                    this.setProperty(98, new Variant(2, Character.valueOf('\u0001')));
                }
            }
            this.setProperty(98, new Variant(2, Character.valueOf('\u0003')));
        }
        if (serverMeta.hasSchemaTerm()) {
            this.setProperty(99, new Variant(0, serverMeta.getSchemaTerm()));
        }
        if (serverMeta.hasSearchEscapeString()) {
            this.setProperty(151, new Variant(0, serverMeta.getSearchEscapeString()));
        }
        if (serverMeta.hasSpecialCharacters()) {
            this.setProperty(102, new Variant(0, serverMeta.getSpecialCharacters()));
        }
        if (null != (protocolStringList3 = serverMeta.getStringFunctionsList())) {
            this.setProperty(104, new Variant(3, DRJDBCConnectionHelper.getStringFunctions((List<String>)protocolStringList3)));
        }
        if (null != (list3 = serverMeta.getSubquerySupportList())) {
            this.setProperty(105, new Variant(3, DRJDBCConnectionHelper.getSubQuerymap(list3)));
        }
        if (null != (protocolStringList2 = serverMeta.getSystemFunctionsList())) {
            this.setProperty(131, new Variant(3, DRJDBCConnectionHelper.getSystemFunctions((List<String>)protocolStringList2)));
        }
        if (serverMeta.hasTableTerm()) {
            this.setProperty(132, new Variant(0, serverMeta.getTableTerm()));
        }
        if (null != (protocolStringList = serverMeta.getDateTimeFunctionsList())) {
            this.setProperty(135, new Variant(3, DRJDBCConnectionHelper.getDateTimeFunctions((List<String>)protocolStringList)));
        }
        if (serverMeta.hasTransactionSupported()) {
            if (serverMeta.getTransactionSupported()) {
                this.setProperty(136, new Variant(2, Character.valueOf('\u0002')));
            } else {
                this.setProperty(136, new Variant(2, Character.valueOf('\u0000')));
            }
        }
        if (null != (list2 = serverMeta.getUnionSupportList())) {
            int n = 0;
            for (UserProtos.UnionSupport unionSupport : list2) {
                switch (unionSupport.getNumber()) {
                    case 1: {
                        n = (int)((long)n | 1L);
                        break;
                    }
                    case 2: {
                        n = (int)((long)n | 2L);
                    }
                }
            }
            this.setProperty(138, new Variant(2, Character.valueOf((char)n)));
        }
        if (serverMeta.getReadOnly()) {
            this.setProperty(40, new Variant(0, "Y"));
        } else {
            this.setProperty(40, new Variant(0, "N"));
        }
        if (serverMeta.hasIdentifierQuoteString()) {
            this.setProperty(58, new Variant(0, serverMeta.getIdentifierQuoteString()));
        }
        if (null != (list = serverMeta.getOrderBySupportList())) {
            this.setOrderBysupport(list);
        }
        this.setProperty(88, new Variant(2, Character.valueOf('\u0001')));
    }

    private void setOrderBysupport(List<UserProtos.OrderBySupport> list) throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        for (UserProtos.OrderBySupport orderBySupport : list) {
            switch (orderBySupport.name()) {
                case "OB_UNRELATED": {
                    this.setProperty(93, new Variant(0, "N"));
                    break;
                }
                case "OB_EXPRESSION": {
                    this.setProperty(55, new Variant(0, "N"));
                    break;
                }
            }
        }
    }

    @Override
    protected void doReset() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.setDefaultProperties();
    }
}

