/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.jdbc41;

import com.mapr.drill.dsi.dataengine.interfaces.IResultSet;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.jdbc.common.SStatement;
import com.mapr.drill.jdbc.common.SUpdatableForwardResultSet;
import com.mapr.drill.jdbc.jdbc41.S41ResultSetMetaData;
import com.mapr.drill.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41UpdatableForwardResultSet
extends SUpdatableForwardResultSet {
    public S41UpdatableForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S41ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, n, clazz);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.findColumn(string), clazz);
    }
}

