/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.impl;

import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.core.impl.DSIDriverSingleton;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.dataengine.filters.DSIMetadataFilterFactory;
import com.mapr.drill.dsi.dataengine.filters.IFilter;
import com.mapr.drill.dsi.dataengine.impl.DSIMetadataResultSet;
import com.mapr.drill.dsi.dataengine.interfaces.IDataEngine;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IQueryExecutor;
import com.mapr.drill.dsi.dataengine.interfaces.IResultSet;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceID;
import com.mapr.drill.dsi.dataengine.utilities.OrderType;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.dsi.exceptions.NumericOverflowException;
import com.mapr.drill.dsi.exceptions.ParsingException;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DSIDataEngine
implements IDataEngine {
    private IStatement m_statement;
    private ILogger m_logger;

    protected DSIDataEngine(IStatement iStatement) {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), iStatement);
        this.m_statement = iStatement;
        this.m_logger = iStatement.getLog();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl) throws ErrorException {
        return this.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceID, arrayList, string, string2, bl});
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
        if (MetadataSourceID.TYPE_INFO == metadataSourceID) {
            this.mapDatetimeTypes(arrayList2);
        }
        ArrayList<IFilter> arrayList3 = new ArrayList<IFilter>();
        HashMap<MetadataSourceColumnTag, String> hashMap = new HashMap<MetadataSourceColumnTag, String>();
        DSIMetadataFilterFactory dSIMetadataFilterFactory = new DSIMetadataFilterFactory(this.shouldPerformFiltering());
        dSIMetadataFilterFactory.createFilters(metadataSourceID, arrayList2, string, string2, bl, arrayList3, hashMap);
        IMetadataSource iMetadataSource = this.makeNewMetadataSource(metadataSourceID, hashMap, string, string2, bl);
        return this.getMetadataResultImplementation(metadataSourceID, hashMap, iMetadataSource, arrayList3, orderType);
    }

    @Override
    public abstract IQueryExecutor prepare(String var1) throws ParsingException, ErrorException;

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, list);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void setDirectExecute() {
    }

    @Override
    public void setMetadataNeeded(boolean bl) {
    }

    protected ILogger getLog() {
        return this.m_logger;
    }

    protected IStatement getParentStatement() {
        return this.m_statement;
    }

    protected IWarningListener getWarningListener() {
        return this.m_statement.getWarningListener();
    }

    protected abstract IMetadataSource makeNewMetadataSource(MetadataSourceID var1, Map<MetadataSourceColumnTag, String> var2, String var3, String var4, boolean var5) throws ErrorException;

    private IResultSet getMetadataResultImplementation(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType) throws ErrorException {
        boolean bl = false;
        try {
            bl = 2 == this.m_statement.getParentConnection().getParentEnvironment().getProperty(3).getInt();
        }
        catch (NumericOverflowException numericOverflowException) {
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        switch (metadataSourceID) {
            case TABLES: 
            case PROCEDURES: 
            case COLUMNS: 
            case COLUMN_PRIVILEGES: 
            case PROCEDURE_COLUMNS: 
            case PRIMARY_KEYS: 
            case FOREIGN_KEYS: 
            case FUNCTION_COLUMNS_JDBC4: 
            case FUNCTIONS_JDBC4: 
            case PSEUDO_COLUMNS_JDBC41: 
            case STATISTICS: 
            case TABLE_PRIVILEGES: 
            case TYPE_INFO: 
            case SPECIAL_COLUMNS: 
            case CATALOG_ONLY: 
            case SCHEMA_ONLY: 
            case TABLETYPE_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                return new DSIMetadataResultSet(this.m_statement, metadataSourceID, iMetadataSource, list, orderType, bl);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceID.toString(), ExceptionType.DEFAULT);
    }

    private void mapDatetimeTypes(List<String> list) {
        block5: for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (null == string) continue;
            switch (Short.valueOf(string)) {
                case 9: {
                    list.set(i, String.valueOf(91));
                    continue block5;
                }
                case 10: {
                    list.set(i, String.valueOf(92));
                    continue block5;
                }
                case 11: {
                    list.set(i, String.valueOf(93));
                    continue block5;
                }
            }
        }
    }

    private boolean shouldPerformFiltering() {
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            return 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            return true;
        }
    }
}

