/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.filters;

import com.mapr.drill.dsi.dataengine.filters.IFilter;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;

public class SmallIntFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private Integer m_value = null;

    public SmallIntFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string) {
        this.m_columnTag = metadataSourceColumnTag;
        if (null != string) {
            this.m_value = Integer.valueOf(string.toString());
        }
    }

    @Override
    public boolean filter(DataWrapper dataWrapper) {
        if (null == this.m_value) {
            return true;
        }
        try {
            if (MetadataSourceColumnTag.SCOPE == this.m_columnTag) {
                if (dataWrapper.isNull()) {
                    return true;
                }
                return this.m_value <= dataWrapper.getSmallInt();
            }
            return this.m_value.equals(dataWrapper.getSmallInt());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            assert (false);
            return false;
        }
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

