/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCTableTypeOnlyMetadataSource
implements IMetadataSource {
    private static final String[] DRILL_TABLE_TYPES = new String[]{"TABLE", "VIEW", "SYSTEM_TABLE", "SYSTEM_VIEW"};
    private ILogger m_logger;
    private int m_pos = -1;

    public DRJDBCTableTypeOnlyMetadataSource(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2, this.m_pos});
        switch (metadataSourceColumnTag) {
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(DRILL_TABLE_TYPES[this.m_pos], dataWrapper, l, l2);
            }
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return DRILL_TABLE_TYPES.length - 1 > this.m_pos;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DRILL_TABLE_TYPES.length - 1 > this.m_pos) {
            ++this.m_pos;
            return true;
        }
        return false;
    }
}

