/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRJDBCResultSet;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IQueryExecutor;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionContexts;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionResults;
import com.mapr.drill.dsi.dataengine.utilities.ParameterInputValue;
import com.mapr.drill.dsi.dataengine.utilities.ParameterMetadata;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.exceptions.BadDefaultParamException;
import com.mapr.drill.dsi.exceptions.ExecutingException;
import com.mapr.drill.dsi.exceptions.OperationCanceledException;
import com.mapr.drill.dsi.exceptions.ParsingException;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCQueryExecutor
implements IQueryExecutor {
    private DRJDBCClient m_client;
    private ILogger m_logger;
    private String m_query;
    private ExecutionResults m_results;
    private boolean m_isDirectExecute;
    private final Object m_isCancelledLock = new Object();
    private boolean m_isCancelled;
    private DRJDBCExecutionContext m_context;
    private IWarningListener m_stmtWarningListener;
    private UserProtos.PreparedStatementHandle m_prepareStatementHandle;
    private UserProtos.PreparedStatement m_prepareStatement;

    public DRJDBCQueryExecutor(DRJDBCClient dRJDBCClient, ILogger iLogger, String string, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, string, bl);
        this.m_client = dRJDBCClient;
        this.m_logger = iLogger;
        this.m_results = null;
        this.m_query = string;
        this.m_results = new ExecutionResults();
        this.m_isDirectExecute = bl;
        this.m_stmtWarningListener = iWarningListener;
        this.m_prepareStatementHandle = null;
        this.m_prepareStatement = null;
        if (!this.m_isDirectExecute) {
            String[] stringArray = this.m_query.trim().split(" ", 2);
            String string2 = this.m_query;
            DRJDBCResultSet dRJDBCResultSet = null;
            if (this.m_client.hasMetadataAPISupport() && stringArray[0].equalsIgnoreCase("SELECT")) {
                LogUtilities.logInfo("Using native preparestatement", iLogger);
                this.m_prepareStatement = this.m_client.createPrepareStatement(string2);
                this.m_prepareStatementHandle = this.m_prepareStatement.getServerHandle();
                if (null == this.m_prepareStatementHandle) {
                    throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.PREPARE_STATEMENT_ERR.name(), new String[]{"Failed to get a prepare statement handle"});
                }
                dRJDBCResultSet = new DRJDBCResultSet(this.m_stmtWarningListener, this.m_client, this.m_logger, this.m_prepareStatement);
            } else {
                LogUtilities.logInfo("Using query mode while creating prepare statement", iLogger);
                if (stringArray[0].equalsIgnoreCase("SELECT")) {
                    string2 = "SELECT * FROM (" + this.m_query + ") T LIMIT 0";
                }
                this.m_context = this.m_client.executeStatementDirect(string2);
                this.m_context.m_queryID = this.m_context.m_resultListener.getQueryId();
                dRJDBCResultSet = new DRJDBCResultSet(this.m_stmtWarningListener, this.m_client, this.m_context, this.m_logger);
                dRJDBCResultSet.openCursor();
                dRJDBCResultSet.doMoveToNextRow();
            }
            this.m_results.addResultSet(dRJDBCResultSet);
        } else {
            DRJDBCResultSet dRJDBCResultSet = new DRJDBCResultSet(this.m_stmtWarningListener, this.m_client, this.m_logger);
            this.m_results.addResultSet(dRJDBCResultSet);
        }
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.setIsCancelled(true);
        if (null != this.m_context) {
            if (null != this.m_context.m_queryID) {
                this.m_client.cancel(this.m_context.m_queryID);
            } else {
                this.m_context.m_resultListener.releaseQuerIdLatchForCancel();
            }
        }
        if (this.m_results.getResultItr().hasNext()) {
            ((DRJDBCResultSet)this.m_results.getResultItr().next().getResult()).cancel();
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.setIsCancelled(false);
        if (this.m_results.getResultItr().hasNext()) {
            ((DRJDBCResultSet)this.m_results.getResultItr().next().getResult()).clearCancel();
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts);
        DRJDBCResultSet dRJDBCResultSet = null;
        if (!this.m_isDirectExecute && null != this.m_prepareStatementHandle) {
            this.m_context = this.m_client.executePrepareStatement(this.m_prepareStatementHandle);
            dRJDBCResultSet = (DRJDBCResultSet)this.m_results.getResultItr().next().getResult();
            dRJDBCResultSet.updateContextWithColoumnMetadataReset(this.m_context);
        } else if (this.m_isDirectExecute) {
            this.m_context = this.m_client.executeStatementDirect(this.m_query);
            this.m_results = new ExecutionResults();
            dRJDBCResultSet = new DRJDBCResultSet(this.m_client, this.m_context, this.m_logger);
            this.m_results.addResultSet(dRJDBCResultSet);
        } else {
            this.m_context = this.m_client.executeStatementDirect(this.m_query);
            dRJDBCResultSet = (DRJDBCResultSet)this.m_results.getResultItr().next().getResult();
            dRJDBCResultSet.updateContextWithColoumnMetadataReset(this.m_context);
        }
        this.m_context.m_queryID = this.m_context.m_resultListener.getQueryId();
        if (this.isCancelled()) {
            this.m_client.cancel(this.m_context.m_queryID);
            throw new OperationCanceledException(101, "OP_CANCELLED_ERR");
        }
        dRJDBCResultSet.openCursor();
        dRJDBCResultSet.doMoveToNextRow();
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return new ArrayList<ParameterMetadata>();
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return 0;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_results == null) {
            this.m_results = new ExecutionResults();
        }
        return this.m_results;
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled() {
        Object object = this.m_isCancelledLock;
        synchronized (object) {
            return this.m_isCancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsCancelled(boolean bl) {
        Object object = this.m_isCancelledLock;
        synchronized (object) {
            this.m_isCancelled = bl;
        }
    }
}

