/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.dataengine.DRJDBCQueryExecutor;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCCatalogOnlyMetadataClientAPI;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCCatalogOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCColumnsMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCColumnsMetadataSourceClientAPI;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCSchemaMetadataSourceClientAPI;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCSchemaOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTableTypeOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTablesMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTablesMetadataSourceClientAPI;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTypeInfoMetadataSource;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.dataengine.impl.DSIDataEngine;
import com.mapr.drill.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IQueryExecutor;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceID;
import com.mapr.drill.dsi.exceptions.ParsingException;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCDataEngine
extends DSIDataEngine {
    private DRJDBCClient m_client;
    private boolean m_isDirectExecution;

    public DRJDBCDataEngine(IStatement iStatement, DRJDBCClient dRJDBCClient, ILogger iLogger) throws ErrorException {
        super(iStatement);
        LogUtilities.logFunctionEntrance(this.getLog(), iStatement, dRJDBCClient);
        this.m_client = dRJDBCClient;
        this.m_isDirectExecution = false;
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        return new DRJDBCQueryExecutor(this.m_client, this.getLog(), string, this.getWarningListener(), this.m_isDirectExecution);
    }

    @Override
    public void setDirectExecute() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isDirectExecution = true;
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        IMetadataSource iMetadataSource = null;
        switch (metadataSourceID) {
            case TYPE_INFO: {
                iMetadataSource = new DRJDBCTypeInfoMetadataSource(this.getLog());
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                if (this.m_client.hasMetadataAPISupport() && !this.hasSchemaRestriction()) {
                    iMetadataSource = new DRJDBCSchemaMetadataSourceClientAPI(this.getLog(), this.m_client, map);
                    break;
                }
                iMetadataSource = new DRJDBCSchemaOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case CATALOG_ONLY: {
                if (this.m_client.hasMetadataAPISupport()) {
                    iMetadataSource = new DRJDBCCatalogOnlyMetadataClientAPI(this.getLog(), this.m_client, map);
                    break;
                }
                iMetadataSource = new DRJDBCCatalogOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case COLUMNS: {
                if (this.m_client.hasMetadataAPISupport()) {
                    iMetadataSource = new DRJDBCColumnsMetadataSourceClientAPI(this.getLog(), this.m_client, map);
                    break;
                }
                iMetadataSource = new DRJDBCColumnsMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case TABLES: {
                if (this.m_client.hasMetadataAPISupport() && !this.hasSchemaRestriction()) {
                    iMetadataSource = new DRJDBCTablesMetadataSourceClientAPI(this.getLog(), this.m_client, map);
                    break;
                }
                iMetadataSource = new DRJDBCTablesMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case TABLETYPE_ONLY: {
                iMetadataSource = new DRJDBCTableTypeOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case PRIMARY_KEYS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case FOREIGN_KEYS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case COLUMN_PRIVILEGES: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case TABLE_PRIVILEGES: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case STATISTICS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            default: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return iMetadataSource;
    }

    private boolean hasSchemaRestriction() {
        DRJDBCConnectionSettings dRJDBCConnectionSettings = this.m_client.getSettings();
        String string = dRJDBCConnectionSettings.m_includedSchemas;
        String string2 = dRJDBCConnectionSettings.m_excludedSchemas;
        return null != string && !string.trim().isEmpty() || null != string2 && !string2.trim().isEmpty();
    }
}

