/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.common;

import com.mapr.drill.dsi.core.impl.DSIDriverSingleton;
import com.mapr.drill.dsi.core.interfaces.IDriver;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.mapr.drill.dsi.dataengine.interfaces.IErrorResult;
import com.mapr.drill.dsi.dataengine.interfaces.IQueryExecutor;
import com.mapr.drill.dsi.dataengine.interfaces.IResultSet;
import com.mapr.drill.dsi.dataengine.interfaces.IRowCountResult;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionContexts;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionResult;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionResultType;
import com.mapr.drill.dsi.dataengine.utilities.ExecutionResults;
import com.mapr.drill.dsi.dataengine.utilities.ParameterInputValue;
import com.mapr.drill.dsi.dataengine.utilities.ParameterMetadata;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.jdbc.common.SConnection;
import com.mapr.drill.jdbc.common.SForwardResultSet;
import com.mapr.drill.jdbc.common.SWarningListener;
import com.mapr.drill.jdbc.common.utilities.WrapperUtilities;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IMessageSource;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import com.mapr.drill.utilities.FunctionID;
import com.mapr.drill.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class SStatement
implements Statement {
    private static final int MAX_ROWS_UNLIMITED = 0;
    private static final String INSERT_TOKEN = "insert";
    private static final int RESULT_SET_UPDATE_COUNT = -1;
    protected Iterator<ExecutionResult> m_resultIterator = null;
    protected List<ResultContext> m_resultSets = new ArrayList<ResultContext>();
    protected IStatement m_statement = null;
    protected IQueryExecutor m_queryExecutor = null;
    protected SWarningListener m_warningListener = null;
    protected IMessageSource m_messageSource = null;
    protected boolean m_escapeProcessingEnabled = true;
    protected ILogger m_logger = null;
    protected SConnection m_parentConnection = null;
    private int m_currentResultSetIndex = 0;
    private int m_concurrency = 1007;
    private List<String> m_batchSQLStatements = new ArrayList<String>();
    protected JDBCVersion m_jdbcVersion;
    private final Object m_closeLock = new Object();
    protected boolean m_isCanceled = false;
    protected boolean m_isInCancelableFunction = false;
    protected final Object m_cancelLock = new Object();
    private final Object m_resultSetsLock = new Object();
    protected volatile boolean m_closeOnCompletion = false;

    static boolean isInsertStatement(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        return INSERT_TOKEN.equalsIgnoreCase(string2);
    }

    protected SStatement(IStatement iStatement, SConnection sConnection, int n) {
        this.m_logger = sConnection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, iStatement, sConnection, n);
        this.m_parentConnection = sConnection;
        this.m_statement = iStatement;
        this.m_concurrency = n;
        this.m_messageSource = DSIDriverSingleton.getInstance().getMessageSource();
        this.m_warningListener = new SWarningListener(this.m_messageSource, null);
        this.m_warningListener.setLocale(sConnection.getDSIConnection().getLocale());
        this.m_statement.registerWarningListener(this.m_warningListener);
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = this.m_parentConnection.nativeSQL(string);
            }
            this.m_batchSQLStatements.add(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                if (this.m_isInCancelableFunction) {
                    this.m_isCanceled = true;
                }
            }
            object = this.m_queryExecutor;
            if (null != object) {
                object.cancelExecute();
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_batchSQLStatements.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
                this.clearResults();
                if (null != this.m_parentConnection) {
                    this.m_parentConnection.removeStatement(this);
                    this.m_parentConnection = null;
                }
                if (null != this.m_statement) {
                    this.m_statement.close();
                    this.m_statement = null;
                }
                this.replaceQueryExecutor(null);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            ExecutionResults executionResults = this.executeNoParams(string, ThrowCondition.None);
            this.m_resultIterator = executionResults.getResultItr();
            if (!this.m_resultIterator.hasNext()) {
                return false;
            }
            this.addResultPair(this.createResultPair(this.m_resultIterator.next()));
            return ExecutionResultType.RESULT_SET == this.m_resultSets.get((int)0).m_resultType || ExecutionResultType.ERROR_RESULT_SET == this.m_resultSets.get((int)0).m_resultType;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n == 2 || !SStatement.isInsertStatement(string)) {
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (!SStatement.isInsertStatement(string)) {
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (!SStatement.isInsertStatement(string)) {
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            object.setMetadataNeeded(false);
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor(object.prepareBatch(this.m_batchSQLStatements));
            object.close();
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList);
            this.clearResults();
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            object2 = this.processBatchResults(this.m_queryExecutor.getResults());
            return object2;
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.m_batchSQLStatements.clear();
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            ExecutionResults executionResults = this.executeNoParams(string, ThrowCondition.SingleResult);
            ExecutionResult executionResult = executionResults.getResultItr().next();
            if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            ResultSet resultSet = this.createResultSet(executionResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            return resultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            ExecutionResults executionResults = this.executeNoParams(string, ThrowCondition.SingleRowCount);
            this.m_resultIterator = executionResults.getResultItr();
            ExecutionResult executionResult = this.m_resultIterator.next();
            if (ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            this.addResultPair(this.createResultPair(executionResult));
            if (iRowCountResult.hasRowCount()) {
                return this.castRowCount(iRowCountResult.getRowCount());
            }
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n == 2 || !SStatement.isInsertStatement(string)) {
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (!SStatement.isInsertStatement(string)) {
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (!SStatement.isInsertStatement(string)) {
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized Object getAttribute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            Variant variant = this.m_statement.getCustomProperty(n);
            switch (variant.getType()) {
                case 5: {
                    return variant.getShort();
                }
                case 2: {
                    return Character.valueOf(variant.getChar());
                }
                case 6: {
                    return variant.getInt();
                }
                case 3: 
                case 7: {
                    return variant.getLong();
                }
                case 4: {
                    return variant.getBigInteger();
                }
            }
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract ResultSet getGeneratedKeys() throws SQLException;

    protected ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_statement.getProperty(2);
            long l = variant.getLong();
            if (Integer.MAX_VALUE < l || Integer.MIN_VALUE > l) {
                return 0;
            }
            return (int)l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getMoreResults(true);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1: {
                    return this.getMoreResults(true);
                }
                case 3: {
                    this.closeAllResultsToCurrent();
                    return this.getMoreResults(true);
                }
                case 2: {
                    IDriver iDriver = DSIDriverSingleton.getInstance();
                    Variant variant = iDriver.getProperty(1005);
                    if (variant.getShort() != 1) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                    }
                    return this.getMoreResults(false);
                }
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MORERESULTS_VALUE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public SConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public IQueryExecutor getQueryExecutor() {
        return this.m_queryExecutor;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(3);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_RESULT_SET == resultContext.m_resultType) {
                    throw ((IErrorResult)resultContext.m_result).getError();
                }
                if (ExecutionResultType.RESULT_SET == resultContext.m_resultType) {
                    ((SForwardResultSet)resultContext.m_result).initializeColumnNameMap();
                    return (ResultSet)resultContext.m_result;
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_concurrency;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection.getHoldability();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public IStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_ROW_COUNT == resultContext.m_resultType) {
                    throw ((IErrorResult)resultContext.m_result).getError();
                }
                if (ExecutionResultType.ROW_COUNT == resultContext.m_resultType) {
                    return this.castRowCount(((IRowCountResult)resultContext.m_result).getRowCount());
                }
            }
            return -1;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized void setAttribute(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            int n2 = this.m_statement.getCustomPropertyType(n);
            this.m_statement.setCustomProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCursorName(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, bl);
            this.checkIfOpen();
            this.m_escapeProcessingEnabled = bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1000: {
                    break;
                }
                case 1001: 
                case 1002: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            int n2 = this.getMaxRows();
            if (0 == n2) {
                if (n < 0) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE_UNLIMITED_MAX, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
                }
            } else if (n < 0 || n > n2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), String.valueOf(0), String.valueOf(n2));
            }
            this.m_statement.setProperty(6, new Variant(4, n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(101);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(1, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FIELD_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        long l = 0L;
        try {
            l = this.getStatementPropertyLong(103);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(102);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(2, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MAX_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(104);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(3, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_TIMEOUT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    void closeIfPrepared() throws SQLException {
    }

    void closeResults() throws SQLException {
        for (int i = this.m_resultSets.size() - 1; i >= 0; --i) {
            ResultContext resultContext = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
            ((ResultSet)resultContext.m_result).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markResultSetClosed(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        Object object = this.m_resultSetsLock;
        synchronized (object) {
            for (ResultContext resultContext : this.m_resultSets) {
                if (resultContext.m_result == resultSet) {
                    resultContext.m_isResultClosed = true;
                }
                if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
                bl = false;
            }
        }
        if (bl && this.m_closeOnCompletion) {
            this.close();
        }
    }

    protected void addResultPair(ResultContext resultContext) {
        if (null != this.m_resultSets && !this.m_resultSets.contains(resultContext)) {
            this.m_resultSets.add(resultContext);
        }
    }

    protected void addResultSet(ResultSet resultSet) {
        this.addResultPair(new ResultContext(resultSet));
    }

    protected void checkCondition(String string, ThrowCondition throwCondition) throws ErrorException, SQLException {
        if (ThrowCondition.None != throwCondition) {
            ExecutionResults executionResults = this.m_queryExecutor.getResults();
            Iterator<ExecutionResult> iterator = executionResults.getResultItr();
            if (!iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(0), string);
            }
            ExecutionResult executionResult = iterator.next();
            if (iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, "1 <", string);
            }
            ExecutionResultType executionResultType = executionResult.getType();
            if (ThrowCondition.SingleResult == throwCondition && ExecutionResultType.RESULT_SET != executionResultType && ExecutionResultType.ERROR_RESULT_SET != executionResultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            if (ThrowCondition.SingleRowCount == throwCondition && ExecutionResultType.ROW_COUNT != executionResultType && ExecutionResultType.ERROR_ROW_COUNT != executionResultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
        }
    }

    protected void checkIfNullSQL(String string) throws SQLException {
        if (null == string) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_SQL_STRING, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfOpen() throws SQLException {
        boolean bl;
        Object object = this.m_closeLock;
        synchronized (object) {
            if (null == this.m_statement) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STATEMENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            bl = null == this.m_parentConnection;
        }
        if (bl) {
            this.close();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    protected void clearResults() {
        if (null != this.m_resultSets) {
            for (ResultContext resultContext : this.m_resultSets) {
                try {
                    if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
                    ((ResultSet)resultContext.m_result).close();
                }
                catch (Exception exception) {}
            }
            this.m_resultSets.clear();
            if (null != this.m_resultIterator) {
                while (this.m_resultIterator.hasNext()) {
                    ExecutionResult executionResult = this.m_resultIterator.next();
                    if (ExecutionResultType.RESULT_SET != executionResult.getType()) continue;
                    ((IResultSet)executionResult.getResult()).close();
                }
                this.m_resultIterator = null;
            }
        }
        this.m_currentResultSetIndex = 0;
    }

    protected ResultContext createResultPair(ExecutionResult executionResult) throws SQLException {
        if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            return new ResultContext(iRowCountResult);
        }
        if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
            ResultSet resultSet = this.createResultSet(executionResult);
            return new ResultContext(resultSet);
        }
        if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
            IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
            return new ResultContext(iErrorResult, true);
        }
        IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
        return new ResultContext(iErrorResult, false);
    }

    protected abstract ResultSet createResultSet(ExecutionResult var1) throws SQLException;

    protected boolean createsUpdatableResults() {
        return 1007 != this.m_concurrency;
    }

    protected int[] processBatchResults(ExecutionResults executionResults) throws ErrorException, SQLException {
        Object object;
        this.m_resultIterator = executionResults.getResultItr();
        ArrayList<Object> arrayList = null;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        long l = 0L;
        boolean bl = false;
        Short s = null;
        while (this.m_resultIterator.hasNext()) {
            Object object2;
            object = this.m_resultIterator.next();
            if (ExecutionResultType.ROW_COUNT == ((ExecutionResult)object).getType()) {
                object2 = (IRowCountResult)((ExecutionResult)object).getResult();
                long l2 = object2.getRowCount();
                if (-1L == l2 || Integer.MAX_VALUE < l2) {
                    arrayList2.add(-2);
                    bl = true;
                } else {
                    arrayList2.add((int)l2);
                }
                if (Integer.MAX_VALUE <= l || Integer.MAX_VALUE >= (l += (long)((Integer)arrayList2.get(arrayList2.size() - 1)).intValue())) continue;
                l = Integer.MAX_VALUE;
                continue;
            }
            if (null == arrayList) {
                arrayList = new ArrayList<Object>();
            }
            if (ExecutionResultType.RESULT_SET == ((ExecutionResult)object).getType()) {
                object2 = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                arrayList.add(object2);
            } else {
                object2 = (IErrorResult)((ExecutionResult)object).getResult();
                arrayList.add(ExceptionConverter.getInstance().toSQLException(object2.getError(), this.m_warningListener));
            }
            if (null == s) {
                try {
                    object2 = DSIDriverSingleton.getInstance();
                    s = object2.getProperty(1001).getShort();
                }
                catch (Exception exception) {
                    s = 1;
                }
            }
            if (1 == s) break;
            arrayList2.add(-3);
        }
        object = new int[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            object[i] = (Integer)arrayList2.get(i);
        }
        BatchUpdateException batchUpdateException = null;
        if (null != arrayList) {
            Iterator iterator = arrayList.iterator();
            SQLException sQLException = (SQLException)iterator.next();
            SQLException sQLException2 = batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), (int[])object);
            while (iterator.hasNext()) {
                SQLException sQLException3 = (SQLException)iterator.next();
                sQLException2.setNextException(sQLException3);
                sQLException2 = sQLException3;
            }
        }
        if (bl) {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(-1L)));
        } else {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(l)));
        }
        if (null != batchUpdateException) {
            throw batchUpdateException;
        }
        return object;
    }

    private void closeAllResultsToCurrent() throws SQLException {
        for (int i = 0; i < this.m_currentResultSetIndex; ++i) {
            ResultContext resultContext = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
            ((ResultSet)resultContext.m_result).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionResults executeNoParams(String string, ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            if (ThrowCondition.None == throwCondition) {
                object.setMetadataNeeded(false);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = this.m_parentConnection.nativeSQL(string);
            }
            this.replaceQueryExecutor(object.prepare(string));
            object.close();
            if (this.m_queryExecutor.getNumParams() != 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkCondition(string, throwCondition);
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
            }
        }
    }

    private boolean getMoreResults(boolean bl) throws SQLException {
        if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
            ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
            if (bl && ExecutionResultType.RESULT_SET == resultContext.m_resultType && !resultContext.m_isResultClosed) {
                ((ResultSet)resultContext.m_result).close();
            }
            ++this.m_currentResultSetIndex;
            if (null != this.m_resultIterator && this.m_resultIterator.hasNext()) {
                ResultContext resultContext2 = this.createResultPair(this.m_resultIterator.next());
                this.addResultPair(resultContext2);
            }
            if (this.m_resultSets.size() == this.m_currentResultSetIndex) {
                return false;
            }
            resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
            return ExecutionResultType.RESULT_SET == resultContext.m_resultType || ExecutionResultType.ERROR_RESULT_SET == resultContext.m_resultType;
        }
        return false;
    }

    private int getStatementPropertyInt(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private long getStatementPropertyLong(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void replaceQueryExecutor(IQueryExecutor iQueryExecutor) {
        IQueryExecutor iQueryExecutor2 = this.m_queryExecutor;
        if (iQueryExecutor2 != null) {
            iQueryExecutor2.close();
        }
        this.m_queryExecutor = iQueryExecutor;
    }

    private void setStatementProperty(int n, int n2, Object object) throws SQLException {
        try {
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_SET_PROPERTY);
            this.m_statement.setProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private int castRowCount(long l) {
        return l > Integer.MAX_VALUE ? -2 : (int)l;
    }

    protected static enum ThrowCondition {
        None,
        SingleResult,
        SingleRowCount;

    }

    protected static class ResultContext {
        protected ExecutionResultType m_resultType;
        protected boolean m_isResultClosed = false;
        protected Object m_result = null;

        ResultContext(IRowCountResult iRowCountResult) {
            this.m_resultType = ExecutionResultType.ROW_COUNT;
            this.m_result = iRowCountResult;
        }

        ResultContext(ResultSet resultSet) {
            this.m_resultType = ExecutionResultType.RESULT_SET;
            this.m_result = resultSet;
        }

        ResultContext(IErrorResult iErrorResult, boolean bl) {
            this.m_resultType = bl ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
            this.m_result = iErrorResult;
        }
    }
}

