/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.filters;

import com.mapr.drill.dsi.dataengine.filters.IFilter;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import java.util.regex.Pattern;

public class StringPatternFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private Pattern m_regEx = null;
    private String m_valueAsRegexStr = null;
    boolean m_hasPatternFilter = false;

    public StringPatternFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, String string2) {
        this.m_columnTag = metadataSourceColumnTag;
        if (null != string) {
            this.m_valueAsRegexStr = this.convertToRegexString(string, string2);
        }
    }

    @Override
    public boolean filter(DataWrapper dataWrapper) {
        if (null == this.m_valueAsRegexStr) {
            return true;
        }
        if (dataWrapper.isNull()) {
            return false;
        }
        if (null == this.m_regEx) {
            this.m_regEx = Pattern.compile(this.m_valueAsRegexStr);
        }
        try {
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    return this.m_regEx.matcher(dataWrapper.getChar()).matches();
                }
                case -9: 
                case 12: {
                    return this.m_regEx.matcher(dataWrapper.getVarChar()).matches();
                }
                case -10: 
                case -1: {
                    return this.m_regEx.matcher(dataWrapper.getLongVarChar()).matches();
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }

    public boolean hasPatternFilter() {
        return this.m_hasPatternFilter;
    }

    private String convertToRegexString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (n2 < string.length()) {
            if (string.regionMatches(n2, string2, 0, string2.length())) {
                if (n2 > n) {
                    stringBuilder.append(Pattern.quote(string.substring(n, n2)));
                }
                if (bl) {
                    stringBuilder.append(Pattern.quote(string2));
                    bl = false;
                } else {
                    bl = true;
                }
                n = n2 += string2.length();
                continue;
            }
            char c = string.charAt(n2);
            if ('_' == c || '%' == c) {
                if (n2 > n) {
                    stringBuilder.append(Pattern.quote(string.substring(n, n2)));
                }
                if (bl) {
                    stringBuilder.append(c);
                } else {
                    if ('_' == c) {
                        stringBuilder.append('.');
                    } else {
                        stringBuilder.append(".*");
                    }
                    this.m_hasPatternFilter = true;
                }
                n = ++n2;
            } else {
                ++n2;
            }
            bl = false;
        }
        if (!bl && n2 > n) {
            stringBuilder.append(Pattern.quote(string.substring(n, n2)));
        }
        return "\\A" + stringBuilder.toString() + "\\z";
    }
}

