/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities;

import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.dsi.exceptions.NumericOverflowException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class Variant {
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long UINT32_MIN_VALUE = 0L;
    public static final BigInteger UINT64_MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger UINT64_MIN_VALUE = BigInteger.ZERO;
    private static final BigInteger CHAR_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(0L);
    private static final BigInteger CHAR_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(65535L);
    private static final BigInteger SHORT_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger SHORT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    public static final int TYPE_WSTRING = 0;
    public static final int TYPE_UINT16 = 2;
    public static final int TYPE_UINT32 = 3;
    public static final int TYPE_UINT64 = 4;
    public static final int TYPE_INT16 = 5;
    public static final int TYPE_INT32 = 6;
    public static final int TYPE_INT64 = 7;
    public static final int TYPE_NULL = 8;
    private int m_type;
    private Object m_value;

    public Variant(int n, Object object) throws IncorrectTypeException, NumericOverflowException {
        switch (n) {
            case 0: {
                if (object == null || object instanceof String) break;
                throw new IncorrectTypeException();
            }
            case 5: {
                if (object instanceof Short) break;
                throw new IncorrectTypeException();
            }
            case 2: {
                if (object instanceof Character) break;
                throw new IncorrectTypeException();
            }
            case 6: {
                if (object instanceof Integer) break;
                throw new IncorrectTypeException();
            }
            case 3: {
                if (!(object instanceof Long)) {
                    throw new IncorrectTypeException();
                }
                long l = (Long)object;
                if (0xFFFFFFFFL >= l && 0L <= l) break;
                throw new NumericOverflowException();
            }
            case 7: {
                if (object instanceof Long) break;
                throw new IncorrectTypeException();
            }
            case 4: {
                if (object instanceof Long) {
                    long l = (Long)object;
                    if (0L > l) {
                        throw new NumericOverflowException();
                    }
                    object = BigInteger.valueOf((Long)object);
                    break;
                }
                if (object instanceof BigInteger) {
                    BigInteger bigInteger = (BigInteger)object;
                    if (UINT64_MAX_VALUE.compareTo(bigInteger) >= 0 && UINT64_MIN_VALUE.compareTo(bigInteger) <= 0) break;
                    throw new NumericOverflowException();
                }
                throw new IncorrectTypeException();
            }
            case 8: {
                if (null == object) break;
                throw new IncorrectTypeException();
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
        this.m_type = n;
        this.m_value = object;
    }

    public char getChar() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                int n = ((Short)this.m_value).intValue();
                if (0 <= n) {
                    return (char)n;
                }
                throw new NumericOverflowException();
            }
            case 3: {
                long l = (Long)this.m_value;
                if (65535L >= l) {
                    return (char)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int n = (Integer)this.m_value;
                if (65535 >= n && 0 <= n) {
                    return (char)n;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long l = (Long)this.m_value;
                if (65535L >= l && 0L <= l) {
                    return (char)l;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigInteger = (BigInteger)this.m_value;
                if (CHAR_MAX_VALUE_AS_BIGINT.compareTo(bigInteger) < 0 || CHAR_MIN_VALUE_AS_BIGINT.compareTo(bigInteger) > 0) {
                    throw new NumericOverflowException();
                }
                return (char)bigInteger.shortValue();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (65535L >= l && 0L <= l) {
                        return (char)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public int getInt() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).intValue();
            }
            case 3: {
                long l = (Long)this.m_value;
                if (Integer.MAX_VALUE >= l) {
                    return (int)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                return (Integer)this.m_value;
            }
            case 7: {
                long l = (Long)this.m_value;
                if (Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigInteger = (BigInteger)this.m_value;
                if (INT_MAX_VALUE_AS_BIGINT.compareTo(bigInteger) < 0 || INT_MIN_VALUE_AS_BIGINT.compareTo(bigInteger) > 0) {
                    throw new NumericOverflowException();
                }
                return bigInteger.intValue();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
                        return (int)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public long getLong() throws IncorrectTypeException, NumericOverflowException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).longValue();
            }
            case 3: {
                return (Long)this.m_value;
            }
            case 6: {
                return ((Integer)this.m_value).longValue();
            }
            case 7: {
                return (Long)this.m_value;
            }
            case 4: {
                BigInteger bigInteger = (BigInteger)this.m_value;
                if (LONG_MAX_VALUE_AS_BIGINT.compareTo(bigInteger) < 0 || LONG_MIN_VALUE_AS_BIGINT.compareTo(bigInteger) > 0) {
                    throw new NumericOverflowException();
                }
                return bigInteger.longValue();
            }
            case 0: {
                try {
                    return Long.parseLong((String)this.m_value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public BigInteger getBigInteger() throws IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return BigInteger.valueOf(((Character)this.m_value).charValue());
            }
            case 5: {
                return BigInteger.valueOf(((Short)this.m_value).shortValue());
            }
            case 3: {
                return BigInteger.valueOf((Long)this.m_value);
            }
            case 6: {
                return BigInteger.valueOf(((Integer)this.m_value).intValue());
            }
            case 7: {
                return BigInteger.valueOf((Long)this.m_value);
            }
            case 4: {
                return (BigInteger)this.m_value;
            }
            case 0: {
                try {
                    return new BigInteger((String)this.m_value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public short getShort() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                char c = ((Character)this.m_value).charValue();
                if (Short.MAX_VALUE >= c) {
                    return (short)c;
                }
                throw new NumericOverflowException();
            }
            case 5: {
                return (Short)this.m_value;
            }
            case 3: {
                long l = (Long)this.m_value;
                if (32767L >= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int n = (Integer)this.m_value;
                if (Short.MAX_VALUE >= n && Short.MIN_VALUE <= n) {
                    return (short)n;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long l = (Long)this.m_value;
                if (32767L >= l && -32768L <= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigInteger = (BigInteger)this.m_value;
                if (SHORT_MAX_VALUE_AS_BIGINT.compareTo(bigInteger) < 0 || SHORT_MIN_VALUE_AS_BIGINT.compareTo(bigInteger) > 0) {
                    throw new NumericOverflowException();
                }
                return bigInteger.shortValue();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (32767L >= l && -32768L <= l) {
                        return (short)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public String getString() {
        if (null == this.m_value) {
            return null;
        }
        if (2 == this.m_type) {
            int n = Character.getNumericValue(((Character)this.m_value).charValue());
            return String.valueOf(n);
        }
        return this.m_value.toString();
    }

    public byte[] getStringAsUTF8() throws IncorrectTypeException, UnsupportedEncodingException {
        if (null == this.m_value) {
            return null;
        }
        return this.getString().getBytes("UTF-8");
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        String string = null;
        switch (this.m_type) {
            case 0: {
                string = "TYPE_WSTRING";
                break;
            }
            case 2: {
                string = "TYPE_UINT16";
                break;
            }
            case 3: {
                string = "TYPE_UINT32";
                break;
            }
            case 4: {
                string = "TYPE_UINT64";
                break;
            }
            case 5: {
                string = "TYPE_INT16";
                break;
            }
            case 6: {
                string = "TYPE_INT32";
                break;
            }
            case 7: {
                string = "TYPE_INT64";
                break;
            }
            default: {
                string = "TYPE_NULL";
            }
        }
        if (null == this.m_value) {
            return "Variant[type: " + string + ", value: null]";
        }
        return "Variant[type: " + string + ", value: " + this.getString() + "]";
    }

    public boolean equals(Object object) {
        if (null == object || !(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        if (null == this.m_value) {
            return null == variant.m_value;
        }
        return this.m_value.equals(variant.m_value);
    }

    public int hashCode() {
        if (null != this.m_value) {
            return this.m_value.hashCode();
        }
        return 0;
    }
}

