/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.api.DRJDBCDataTypeUtils;
import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.commons.SettingsKeys;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCMetadataSourceClientAPI;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.TypeUtilities;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCColumnsMetadataSourceClientAPI
extends DRJDBCMetadataSourceClientAPI<UserProtos.ColumnMetadata> {
    protected static final long DEFAULT_BUFFER_LENGTH = 9L;

    public DRJDBCColumnsMetadataSourceClientAPI(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
        this.m_client = dRJDBCClient;
        this.m_currIdx = -1;
        this.m_numData = 0;
        this.m_data = null;
        this.m_settings = this.m_client.getSettings();
        this.getData(map.get((Object)MetadataSourceColumnTag.CATALOG_NAME), map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME), map.get((Object)MetadataSourceColumnTag.TABLE_NAME), map.get((Object)MetadataSourceColumnTag.COLUMN_NAME));
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        UserProtos.ColumnMetadata columnMetadata = (UserProtos.ColumnMetadata)this.m_data.get(this.m_currIdx);
        short s = DRJDBCDataTypeUtils.mapDrillTypeNameToSqltype(columnMetadata.getDataType());
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                if (SettingsKeys.CATALOG_SUPPORT_ENUM.NOT_SUPPORTED == this.m_settings.m_catalogSupport) {
                    dataWrapper.setNull(12);
                    return false;
                }
                if (columnMetadata.hasCatalogName()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getCatalogName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find catalog name.");
            }
            case SCHEMA_NAME: {
                if (columnMetadata.hasSchemaName()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getSchemaName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find schema name.");
            }
            case TABLE_NAME: {
                if (columnMetadata.hasTableName()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getTableName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find table name.");
            }
            case COLUMN_NAME: {
                if (columnMetadata.hasColumnName()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getColumnName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find column name.");
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(s);
                return false;
            }
            case DATA_TYPE_NAME: {
                if (columnMetadata.hasDataType()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getDataType(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find data type name.");
            }
            case COLUMN_DEF: {
                if (columnMetadata.hasDefaultValue()) {
                    return DSITypeUtilities.outputVarCharStringData(columnMetadata.getDefaultValue(), dataWrapper, l, l2);
                }
                dataWrapper.setNull(0);
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                if (columnMetadata.hasCharOctetLength()) {
                    dataWrapper.setInteger(columnMetadata.getCharOctetLength());
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case IS_NULLABLE: {
                if (columnMetadata.getIsNullable()) {
                    return DSITypeUtilities.outputVarCharStringData("YES", dataWrapper, l, l2);
                }
                return DSITypeUtilities.outputVarCharStringData("NO", dataWrapper, l, l2);
            }
            case ORDINAL_POSITION: {
                if (columnMetadata.hasOrdinalPosition()) {
                    dataWrapper.setInteger(columnMetadata.getOrdinalPosition());
                }
                return false;
            }
            case SQL_DATETIME_SUB: {
                if (TypeUtilities.isDateTimeType(s) || TypeUtilities.isIntervalType(s)) {
                    short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                    dataWrapper.setSmallInt(s2);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case REMARKS: {
                dataWrapper.setNull(0);
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_AUTOINCREMENT: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
            case IS_GENERATEDCOLUMN: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
            case NULLABLE: {
                if (columnMetadata.hasIsNullable()) {
                    if (columnMetadata.getIsNullable()) {
                        dataWrapper.setInteger(1L);
                    } else {
                        dataWrapper.setInteger(0L);
                    }
                } else {
                    dataWrapper.setInteger(2L);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(s));
                return false;
            }
            case NUM_PREC_RADIX: {
                if (columnMetadata.hasNumericPrecisionRadix()) {
                    dataWrapper.setInteger(columnMetadata.getNumericPrecisionRadix());
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case COLUMN_SIZE: {
                if (TypeUtilities.isCharacterOrBinaryType(s)) {
                    if (columnMetadata.hasCharMaxLength()) {
                        dataWrapper.setInteger(columnMetadata.getCharMaxLength());
                    } else {
                        dataWrapper.setInteger(this.m_settings.m_stringColumnLength);
                    }
                } else if (TypeUtilities.isDateTimeType(s)) {
                    int n = 0;
                    if (columnMetadata.hasDateTimePrecision()) {
                        n = columnMetadata.getDateTimePrecision();
                    }
                    if (0 >= n) {
                        switch (s) {
                            case 91: {
                                dataWrapper.setInteger(10L);
                                break;
                            }
                            case 92: {
                                dataWrapper.setInteger(DRJDBCDataTypeUtils.TIME_PRECISION.shortValue());
                                break;
                            }
                            case 93: {
                                dataWrapper.setInteger(DRJDBCDataTypeUtils.TIMESTAMP_PRECISION.shortValue());
                                break;
                            }
                        }
                    } else {
                        dataWrapper.setInteger(n);
                    }
                } else if (TypeUtilities.isNumberType(s)) {
                    if (columnMetadata.hasNumericPrecision()) {
                        dataWrapper.setInteger(columnMetadata.getNumericPrecision());
                    }
                } else {
                    dataWrapper.setInteger(columnMetadata.getColumnSize());
                }
                return false;
            }
            case DECIMAL_DIGITS: {
                if (TypeUtilities.isIntegerType(s)) {
                    dataWrapper.setInteger(0L);
                } else if (TypeUtilities.isApproximateNumericType(s) || TypeUtilities.isExactNumericType(s)) {
                    int n = columnMetadata.getNumericScale();
                    if (columnMetadata.hasNumericScale()) {
                        dataWrapper.setInteger(n);
                    } else {
                        dataWrapper.setInteger(0L);
                    }
                } else if (TypeUtilities.isIntervalType(s)) {
                    if (columnMetadata.hasIntervalPrecision()) {
                        dataWrapper.setInteger(columnMetadata.getIntervalPrecision());
                    } else {
                        dataWrapper.setInteger(4L);
                    }
                } else if (TypeUtilities.isDateTimeType(s)) {
                    int n = 0;
                    if (columnMetadata.hasDateTimePrecision()) {
                        n = columnMetadata.getDateTimePrecision();
                    }
                    if (0 >= n) {
                        switch (s) {
                            case 92: {
                                dataWrapper.setInteger(DRJDBCDataTypeUtils.TIME_TYPE_SCALE.shortValue());
                                break;
                            }
                            case 93: {
                                dataWrapper.setInteger(DRJDBCDataTypeUtils.TIME_TYPE_SCALE.shortValue());
                                break;
                            }
                            default: {
                                dataWrapper.setInteger(4L);
                                break;
                            }
                        }
                    } else {
                        dataWrapper.setInteger(n);
                    }
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case BUFFER_LENGTH: {
                if (TypeUtilities.isCharacterOrBinaryType(s)) {
                    if (columnMetadata.hasColumnSize()) {
                        if (!TypeUtilities.isLOBType(s) && !TypeUtilities.isBinaryType(s)) {
                            dataWrapper.setInteger(columnMetadata.getColumnSize());
                        } else {
                            dataWrapper.setInteger(columnMetadata.getColumnSize() * 2);
                        }
                    }
                } else {
                    dataWrapper.setInteger(9L);
                }
                return false;
            }
        }
        this.throwMetadataColumnNotFoundException(metadataSourceColumnTag);
        return false;
    }

    private void getData(String string, String string2, String string3, String string4) throws ErrorException {
        UserProtos.LikeFilter likeFilter = null;
        UserProtos.LikeFilter likeFilter2 = null;
        UserProtos.LikeFilter likeFilter3 = null;
        UserProtos.LikeFilter likeFilter4 = null;
        if (null != string && !string.isEmpty() && SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED == this.m_settings.m_catalogSupport) {
            likeFilter = UserProtos.LikeFilter.newBuilder().setPattern(string).setEscape("\\").build();
        }
        if (null != string2 && !string2.isEmpty()) {
            likeFilter2 = UserProtos.LikeFilter.newBuilder().setPattern(string2).setEscape("\\").build();
        }
        if (null != string3 && !string3.isEmpty()) {
            likeFilter3 = UserProtos.LikeFilter.newBuilder().setPattern(string3).setEscape("\\").build();
        }
        if (null != string4 && !string4.isEmpty()) {
            likeFilter4 = UserProtos.LikeFilter.newBuilder().setPattern(string4).setEscape("\\").build();
        }
        UserProtos.GetColumnsResp getColumnsResp = this.m_client.getColumns(likeFilter, likeFilter2, likeFilter3, likeFilter4);
        this.m_data = getColumnsResp.getColumnsList();
        if (null == this.m_data) {
            this.throwNullDataResponseException(getColumnsResp.getClass().getSimpleName());
        }
        this.m_numData = this.m_data.size();
    }
}

