/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.support.security;

import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.ObjectWrapper;
import com.mapr.drill.support.security.ICredentialFactory;
import com.mapr.drill.support.security.ICredentials;
import com.mapr.drill.support.security.MapRAuthenticatedCredentials;
import com.mapr.drill.support.security.MapRLocalCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;

public class MapRCredentialFactory
implements ICredentialFactory {
    private GSSManager m_gssManager = GSSManager.getInstance();
    private final ILogger m_logger;
    private MapRLocalCredentials m_acceptorCredentials = null;
    private GSSContext m_remoteContext = null;

    public MapRCredentialFactory(ILogger iLogger) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ICredentials getLocalCredentials() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return new MapRLocalCredentials(this.m_logger, this.m_gssManager, false);
    }

    @Override
    public ICredentials getAuthenticatedCredentials(byte[] byArray, ObjectWrapper<byte[]> objectWrapper) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == byArray) {
            byArray = new byte[]{};
        }
        if (null == this.m_acceptorCredentials) {
            this.m_acceptorCredentials = new MapRLocalCredentials(this.m_logger, this.m_gssManager, true);
            this.m_remoteContext = this.m_gssManager.createContext(this.m_acceptorCredentials.getCredentialHandle());
            this.m_remoteContext.requestCredDeleg(true);
        }
        objectWrapper.setValue(this.m_remoteContext.acceptSecContext(byArray, 0, byArray.length));
        if (this.m_remoteContext.isEstablished()) {
            return new MapRAuthenticatedCredentials(this.m_logger, this.m_gssManager, this.m_remoteContext);
        }
        return null;
    }
}

