/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.support.conv;

import com.mapr.drill.support.conv.ConversionResult;
import com.mapr.drill.support.conv.ConverterConstants;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateTimeConverter {
    private DateTimeConverter() {
    }

    public static int calculateFractionalSeconds(int n, int n2) {
        return n - n % ConverterConstants.FRACTIONAL_MOD[n2];
    }

    public static String toChar(Date date, long l, Calendar calendar, ConversionResult conversionResult) {
        calendar.clear();
        calendar.set(1, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String string = simpleDateFormat.format(date);
        if (date.getTime() < l2) {
            string = '-' + string;
        }
        if ((long)string.length() > l) {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return string;
    }

    public static String toChar(Timestamp timestamp, long l, int n, Calendar calendar, ConversionResult conversionResult) {
        int n2;
        char[] cArray = new char[]{'-', '0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        int n3 = calendar.get(1);
        int n4 = calendar.get(2) + 1;
        int n5 = calendar.get(5);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        if (n3 <= 9999) {
            n2 = 6;
            cArray[6] = (char)(48 + n3 / 1000);
        } else if (n3 <= 999999) {
            if (n3 <= 99999) {
                n2 = 5;
                cArray[5] = (char)(48 + n3 / 10000 % 10);
                cArray[6] = (char)(48 + n3 / 1000 % 10);
            } else {
                n2 = 4;
                cArray[4] = (char)(48 + n3 / 100000 % 10);
                cArray[5] = (char)(48 + n3 / 10000 % 10);
                cArray[6] = (char)(48 + n3 / 1000 % 10);
            }
        } else if (n3 <= 9999999) {
            n2 = 3;
            cArray[3] = (char)(48 + n3 / 1000000 % 10);
            cArray[4] = (char)(48 + n3 / 100000 % 10);
            cArray[5] = (char)(48 + n3 / 10000 % 10);
            cArray[6] = (char)(48 + n3 / 1000 % 10);
        } else if (n3 <= 99999999) {
            n2 = 2;
            cArray[2] = (char)(48 + n3 / 10000000 % 10);
            cArray[3] = (char)(48 + n3 / 1000000 % 10);
            cArray[4] = (char)(48 + n3 / 100000 % 10);
            cArray[5] = (char)(48 + n3 / 10000 % 10);
            cArray[6] = (char)(48 + n3 / 1000 % 10);
        } else {
            n2 = 1;
            cArray[1] = (char)(48 + n3 / 100000000 % 10);
            cArray[2] = (char)(48 + n3 / 10000000 % 10);
            cArray[3] = (char)(48 + n3 / 1000000 % 10);
            cArray[4] = (char)(48 + n3 / 100000 % 10);
            cArray[5] = (char)(48 + n3 / 10000 % 10);
            cArray[6] = (char)(48 + n3 / 1000 % 10);
        }
        cArray[7] = (char)(48 + n3 / 100 % 10);
        cArray[8] = (char)(48 + n3 / 10 % 10);
        cArray[9] = (char)(48 + n3 % 10);
        cArray[11] = (char)(48 + n4 / 10);
        cArray[12] = (char)(48 + n4 % 10);
        cArray[14] = (char)(48 + n5 / 10);
        cArray[15] = (char)(48 + n5 % 10);
        cArray[17] = (char)(48 + n6 / 10);
        cArray[18] = (char)(48 + n6 % 10);
        cArray[20] = (char)(48 + n7 / 10);
        cArray[21] = (char)(48 + n7 % 10);
        cArray[23] = (char)(48 + n8 / 10);
        cArray[24] = (char)(48 + n8 % 10);
        calendar.clear();
        calendar.set(1, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        if (timestamp.getTime() < l2) {
            cArray[--n2] = 45;
        }
        int n9 = 25 - n2;
        if (0 < n) {
            int n10 = timestamp.getNanos();
            cArray[26] = (char)(48 + n10 / 100000000);
            cArray[27] = (char)(48 + n10 / 10000000 % 10);
            cArray[28] = (char)(48 + n10 / 1000000 % 10);
            cArray[29] = (char)(48 + n10 / 100000 % 10);
            cArray[30] = (char)(48 + n10 / 10000 % 10);
            cArray[31] = (char)(48 + n10 / 1000 % 10);
            cArray[32] = (char)(48 + n10 / 100 % 10);
            cArray[33] = (char)(48 + n10 / 10 % 10);
            cArray[34] = (char)(48 + n10 % 10);
            n9 = 26 + n - n2;
        }
        if ((long)n9 > l) {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            n9 = (int)l;
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        String string = new String(cArray, n2, n9);
        return string;
    }

    public static String toChar(Time time, long l, int n, Calendar calendar, ConversionResult conversionResult) {
        int n2;
        assert (n >= 0) : "Negative source precision.";
        char[] cArray = new char[]{'0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0'};
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        calendar.set(1970, 0, 1);
        int n3 = calendar.get(11);
        int n4 = calendar.get(12);
        int n5 = calendar.get(13);
        int n6 = calendar.get(14);
        cArray[0] = (char)(48 + n3 / 10);
        cArray[1] = (char)(48 + n3 % 10);
        cArray[3] = (char)(48 + n4 / 10);
        cArray[4] = (char)(48 + n4 % 10);
        cArray[6] = (char)(48 + n5 / 10);
        cArray[7] = (char)(48 + n5 % 10);
        for (n2 = 11; n2 > 8; --n2) {
            cArray[n2] = (char)(48 + n6 % 10);
            n6 /= 10;
        }
        if (0 >= n) {
            n = -1;
        } else if (3 < n) {
            n = 3;
        }
        n2 = 9 + n;
        if ((long)n2 <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            n2 = (int)l;
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
        }
        String string = new String(cArray, 0, n2);
        return string;
    }

    public static Date toDate(Timestamp timestamp, Calendar calendar, ConversionResult conversionResult) {
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return new Date(calendar.getTimeInMillis());
    }

    public static Time toTime(Timestamp timestamp, Calendar calendar, int n, ConversionResult conversionResult) {
        assert (n >= 0) : "negative precision";
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        if (calendar instanceof GregorianCalendar) {
            calendar.set(0, 1);
        }
        calendar.set(1970, 0, 1);
        int n2 = timestamp.getNanos();
        int n3 = n2 % ConverterConstants.FRACTIONAL_MOD[Math.min(n, 3)];
        if (0 != n3) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        calendar.set(14, (n2 - n3) / 1000000);
        return new Time(calendar.getTimeInMillis());
    }

    public static Time toTime(Time time, ConversionResult conversionResult, int n, Calendar calendar) {
        assert (n >= 0);
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        calendar.set(1970, 0, 1);
        int n2 = calendar.get(14);
        int n3 = n2 - n2 % ConverterConstants.MILLIS_MOD[Math.min(n, 3)];
        calendar.set(14, n3);
        if (n2 != n3) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        Time time2 = new Time(calendar.getTimeInMillis());
        return time2;
    }

    public static Timestamp toTimestamp(Date date, ConversionResult conversionResult, Calendar calendar) {
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(0);
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return timestamp;
    }

    public static Timestamp toTimestamp(Timestamp timestamp, ConversionResult conversionResult, int n) {
        int n2;
        assert (n >= 0);
        int n3 = timestamp.getNanos();
        if (n3 != (n2 = DateTimeConverter.calculateFractionalSeconds(n3, n))) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        Timestamp timestamp2 = new Timestamp(timestamp.getTime());
        timestamp2.setNanos(n2);
        return timestamp2;
    }

    public static Timestamp toTimestamp(Time time, ConversionResult conversionResult, Calendar calendar, int n) {
        assert (n >= 0);
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        int n2 = timestamp.getNanos();
        int n3 = DateTimeConverter.calculateFractionalSeconds(n2, n);
        if (n2 != n3) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return timestamp;
    }
}

