/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.support.channels;

import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.channels.AbstractSocketChannel;
import com.mapr.drill.support.channels.ISocketChannelReadCallback;
import com.mapr.drill.support.channels.SocketChannelMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class PlainSocketChannel
extends AbstractSocketChannel {
    protected static final int READ_BUFFER_CAPACITY = 512000;
    private ByteBuffer m_readBuffer = ByteBuffer.allocateDirect(512000);

    public PlainSocketChannel(SocketChannel socketChannel, ISocketChannelReadCallback iSocketChannelReadCallback, ILogger iLogger) throws ErrorException {
        super(socketChannel, iSocketChannelReadCallback, iLogger);
        this.m_readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean write(ByteBuffer byteBuffer) throws ErrorException {
        if (null == this.m_internal || this.isClosed()) {
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name());
        }
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            try {
                n = this.m_internal.write(byteBuffer);
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Writing " + n + " bytes", this.m_log);
                }
                if (0 != n) continue;
                return true;
            }
            catch (IOException iOException) {
                String string;
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug(iOException, this.m_log);
                }
                if (null != (string = iOException.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), string, (Throwable)iOException);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), iOException);
            }
        }
        return true;
    }

    @Override
    public void read() throws ErrorException {
        int n = -2;
        do {
            try {
                n = this.m_internal.read(this.m_readBuffer);
            }
            catch (IOException iOException) {
                LogUtilities.logFatal(iOException, this.m_log);
                String string = iOException.getMessage();
                if (null != string) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), string, (Throwable)iOException);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), iOException);
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Bytes read from channel: " + n, this.m_log);
            }
            if (-1 != n) continue;
            this.readCallback(this.m_readBuffer);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        } while (n > 0);
        this.readCallback(this.m_readBuffer);
    }

    @Override
    public int getReadBufferCapacity() {
        return 512000;
    }
}

