/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.common.utilities;

import com.mapr.drill.dsi.core.utilities.ClientInfoData;
import com.mapr.drill.dsi.dataengine.impl.DSISimpleResultSet;
import com.mapr.drill.dsi.dataengine.interfaces.IColumn;
import com.mapr.drill.dsi.dataengine.utilities.ColumnMetadata;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.utilities.MetaDataFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientInfoPropertiesMetadataSource
extends DSISimpleResultSet {
    private List<ClientInfoPropertyColumnInfo> m_columnData = null;
    private List<ColumnMetadata> m_columns = null;
    private int m_numRows;

    public ClientInfoPropertiesMetadataSource(Map<String, ClientInfoData> map) {
        this.initializeData(map);
        this.m_columns = MetaDataFactory.createClientInfoPropertiesMetadata();
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        switch (n) {
            case 0: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_name, dataWrapper, l, l2);
            }
            case 1: {
                dataWrapper.setInteger(this.m_columnData.get((int)this.getCurrentRow()).m_maxLength);
                return false;
            }
            case 2: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_defaultValue, dataWrapper, l, l2);
            }
            case 3: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_description, dataWrapper, l, l2);
            }
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_numRows;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return (ArrayList)this.m_columns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return this.getCurrentRow() + 1 < this.m_numRows;
    }

    @Override
    public boolean hasRowCount() {
        return true;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.m_columnData = null;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        return this.getCurrentRow() < this.m_numRows;
    }

    private void initializeData(Map<String, ClientInfoData> map) {
        this.m_columnData = new ArrayList<ClientInfoPropertyColumnInfo>();
        Set<String> set = map.keySet();
        Object[] objectArray = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray, 0, objectArray.length);
        ClientInfoPropertyColumnInfo clientInfoPropertyColumnInfo = null;
        ClientInfoData clientInfoData = null;
        for (Object object : objectArray) {
            clientInfoData = map.get(object);
            clientInfoPropertyColumnInfo = new ClientInfoPropertyColumnInfo();
            clientInfoPropertyColumnInfo.m_name = clientInfoData.getName();
            clientInfoPropertyColumnInfo.m_defaultValue = clientInfoData.getDefaultValue();
            clientInfoPropertyColumnInfo.m_maxLength = clientInfoData.getMaxLength();
            clientInfoPropertyColumnInfo.m_description = clientInfoData.getDescription();
            this.m_columnData.add(clientInfoPropertyColumnInfo);
        }
        this.m_numRows = objectArray.length;
    }

    private static class ClientInfoPropertyColumnInfo {
        public String m_name;
        public int m_maxLength;
        public String m_defaultValue;
        public String m_description;

        private ClientInfoPropertyColumnInfo() {
        }
    }
}

