/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.utilities;

import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeUtilities {
    public static final int BIT_DISPLAY_SIZE = 1;
    public static final int DOUBLE_FLOAT_DISPLAY_SIZE = 24;
    public static final int REAL_DISPLAY_SIZE = 14;
    public static final int BIGINT_DISPLAY_SIZE = 20;
    public static final int GUID_DISPLAY_SIZE = 36;
    public static final int UINT_DISPLAY_SIZE = 10;
    public static final int SINT_DISPLAY_SIZE = 11;
    public static final int USMALLINT_DISPLAY_SIZE = 5;
    public static final int SSMALLINT_DISPLAY_SIZE = 6;
    public static final int UTINYINT_DISPLAY_SIZE = 3;
    public static final int STINYINT_DISPLAY_SIZE = 4;
    public static final int DATE_DISPLAY_SIZE = 10;
    public static final int TIME_NO_FRAC_PREC_DISPLAY_SIZE = 8;
    public static final int TIME_WITH_FRAC_PREC_DISPLAY_SIZE = 9;
    public static final int TIMESTAMP_NO_FRAC_PREC_DISPLAY_SIZE = 19;
    public static final int TIMESTAMP_WITH_FRAC_PREC_DISPLAY_SIZE = 20;
    public static final int BIT_COLUMN_SIZE = 1;
    public static final int DATE_COLUMN_SIZE = 10;
    public static final int DOUBLE_FLOAT_COLUMN_SIZE = 15;
    public static final int GUID_COLUMN_SIZE = 36;
    public static final int INTEGER_COLUMN_SIZE = 10;
    public static final int REAL_COLUMN_SIZE = 7;
    public static final int SMALLINT_COLUMN_SIZE = 5;
    public static final int TINYINT_COLUMN_SIZE = 3;
    public static final int SBIGINT_COLUMN_SIZE = 19;
    public static final int UBIGINT_COLUMN_SIZE = 20;
    public static final int INTERVAL_YEAR_COLUMN_SIZE = 2;
    public static final int INTERVAL_YEAR_TO_MONTH_COLUMN_SIZE = 5;
    public static final int INTERVAL_MONTH_COLUMN_SIZE = 2;
    public static final int INTERVAL_DAY_COLUMN_SIZE = 2;
    public static final int INTERVAL_DAY_TO_HOUR_COLUMN_SIZE = 5;
    public static final int INTERVAL_DAY_TO_MINUTE_COLUMN_SIZE = 8;
    public static final int INTERVAL_DAY_TO_SECOND_COLUMN_SIZE = 18;
    public static final int INTERVAL_HOUR_COLUMN_SIZE = 2;
    public static final int INTERVAL_HOUR_TO_MINUTE_COLUMN_SIZE = 5;
    public static final int INTERVAL_HOUR_TO_SECOND_COLUMN_SIZE = 15;
    public static final int INTERVAL_MINUTE_COLUMN_SIZE = 2;
    public static final int INTERVAL_MINUTE_TO_SECOND_COLUMN_SIZE = 12;
    public static final int INTERVAL_SECOND_COLUMN_SIZE = 9;
    private static final Map<String, Integer> s_stringToSQLTypeMap = TypeUtilities.initializeStringToSQLTypeMap();
    private static final Set<Integer> s_supportedSqlTypes = TypeUtilities.initializeSupportedSqlTypes();

    public static long getColumnSize(TypeMetadata typeMetadata, long l) throws ErrorException {
        switch (typeMetadata.getType()) {
            case -10: 
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                return l;
            }
            case 92: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return 8L;
                }
                return 9 + s;
            }
            case 91: {
                return 10L;
            }
            case 93: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return 19L;
                }
                return 20 + s;
            }
            case 2: 
            case 3: {
                return typeMetadata.getPrecision();
            }
            case 7: {
                return 7L;
            }
            case 6: 
            case 8: {
                return 15L;
            }
            case -11: {
                return 36L;
            }
            case -7: 
            case 16: {
                return 1L;
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    return 19L;
                }
                return 20L;
            }
            case 4: {
                return 10L;
            }
            case 5: {
                return 5L;
            }
            case -6: {
                return 3L;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return typeMetadata.getIntervalPrecision();
            }
            case 106: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision();
                }
                return typeMetadata.getIntervalPrecision() + s + 1;
            }
            case 107: 
            case 108: 
            case 111: {
                return typeMetadata.getIntervalPrecision() + 3;
            }
            case 109: {
                return typeMetadata.getIntervalPrecision() + 6;
            }
            case 110: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 9;
                }
                return typeMetadata.getIntervalPrecision() + s + 10;
            }
            case 112: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 6;
                }
                return typeMetadata.getIntervalPrecision() + s + 7;
            }
            case 113: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 3;
                }
                return typeMetadata.getIntervalPrecision() + s + 4;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), new String[]{typeMetadata.getTypeName(), Short.toString(typeMetadata.getType())}, ExceptionType.DATA);
    }

    public static int getSizeInBytes(int n) {
        switch (n) {
            case 92: {
                return 6;
            }
            case 91: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 40;
            }
            case 7: {
                return 4;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case -11: {
                return 16;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -5: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case -6: {
                return 1;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 34;
            }
        }
        assert (false);
        return 0;
    }

    public static long getDisplaySize(TypeMetadata typeMetadata, long l) throws ErrorException {
        switch (typeMetadata.getType()) {
            case 2003: {
                return -4L;
            }
            case -4: 
            case -3: 
            case -2: {
                return l * 2L;
            }
            case -7: 
            case 16: {
                return 1L;
            }
            case -5: {
                return 20L;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                return l;
            }
            case -11: {
                return 36L;
            }
            case 2: 
            case 3: {
                short s = typeMetadata.getScale();
                short s2 = typeMetadata.getPrecision();
                if (s2 == s) {
                    return s2 + 3;
                }
                if (0 == s) {
                    return s2 + 1;
                }
                return s2 + 2;
            }
            case 6: 
            case 8: {
                return 24L;
            }
            case 4: {
                if (!typeMetadata.isSigned()) {
                    return 10L;
                }
                return 11L;
            }
            case 7: {
                return 14L;
            }
            case 5: {
                if (!typeMetadata.isSigned()) {
                    return 5L;
                }
                return 6L;
            }
            case -6: {
                if (!typeMetadata.isSigned()) {
                    return 3L;
                }
                return 4L;
            }
            case 91: {
                return 10L;
            }
            case 92: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return 8L;
                }
                return 9 + s;
            }
            case 93: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return 19L;
                }
                return 20 + s;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return typeMetadata.getIntervalPrecision() + 1;
            }
            case 107: 
            case 108: 
            case 111: {
                return typeMetadata.getIntervalPrecision() + 4;
            }
            case 109: {
                return typeMetadata.getIntervalPrecision() + 7;
            }
            case 110: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 10;
                }
                return typeMetadata.getIntervalPrecision() + s + 11;
            }
            case 112: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 7;
                }
                return typeMetadata.getIntervalPrecision() + s + 8;
            }
            case 113: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 4;
                }
                return typeMetadata.getIntervalPrecision() + s + 5;
            }
            case 106: {
                short s = typeMetadata.getPrecision();
                if (0 == s) {
                    return typeMetadata.getIntervalPrecision() + 1;
                }
                return typeMetadata.getIntervalPrecision() + s + 2;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), new String[]{typeMetadata.getTypeName(), Short.toString(typeMetadata.getType())}, ExceptionType.DATA);
    }

    private static Map<String, Integer> initializeStringToSQLTypeMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("SQL_CHAR", 1);
        hashMap.put("SQL_VARCHAR", 12);
        hashMap.put("SQL_LONGVARCHAR", -1);
        hashMap.put("SQL_BINARY", -2);
        hashMap.put("SQL_VARBINARY", -3);
        hashMap.put("SQL_LONGVARBINARY", -4);
        hashMap.put("SQL_BIT", -7);
        hashMap.put("SQL_BOOLEAN", 16);
        hashMap.put("SQL_TINYINT", -6);
        hashMap.put("SQL_SMALLINT", 5);
        hashMap.put("SQL_INTEGER", 4);
        hashMap.put("SQL_BIGINT", -5);
        hashMap.put("SQL_DECIMAL", 3);
        hashMap.put("SQL_NUMERIC", 2);
        hashMap.put("SQL_FLOAT", 6);
        hashMap.put("SQL_DOUBLE", 8);
        hashMap.put("SQL_REAL", 7);
        hashMap.put("SQL_GUID", -11);
        hashMap.put("SQL_TYPE_DATE", 91);
        hashMap.put("SQL_TYPE_TIME", 92);
        hashMap.put("SQL_TYPE_TIMESTAMP", 93);
        hashMap.put("SQL_DATE", 91);
        hashMap.put("SQL_TIME", 92);
        hashMap.put("SQL_TIMESTAMP", 93);
        hashMap.put("SQL_WCHAR", -8);
        hashMap.put("SQL_WVARCHAR", -9);
        hashMap.put("SQL_WLONGVARCHAR", -10);
        hashMap.put("NULL", 0);
        hashMap.put("SQL_INTERVAL_MONTH", 102);
        hashMap.put("SQL_INTERVAL_YEAR", 101);
        hashMap.put("SQL_INTERVAL_YEAR_TO_MONTH", 107);
        hashMap.put("SQL_INTERVAL_DAY", 103);
        hashMap.put("SQL_INTERVAL_DAY_TO_HOUR", 108);
        hashMap.put("SQL_INTERVAL_DAY_TO_MINUTE", 109);
        hashMap.put("SQL_INTERVAL_DAY_TO_SECOND", 110);
        hashMap.put("SQL_INTERVAL_HOUR", 104);
        hashMap.put("SQL_INTERVAL_HOUR_TO_MINUTE", 111);
        hashMap.put("SQL_INTERVAL_HOUR_TO_SECOND", 112);
        hashMap.put("SQL_INTERVAL_MINUTE", 105);
        hashMap.put("SQL_INTERVAL_MINUTE_TO_SECOND", 113);
        hashMap.put("SQL_INTERVAL_SECOND", 106);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Set<Integer> initializeSupportedSqlTypes() {
        return Collections.unmodifiableSet(new HashSet<Integer>(s_stringToSQLTypeMap.values()));
    }

    public static short getIntervalCodeFromConciseType(int n) {
        switch (n) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case 103: {
                return 3;
            }
            case 108: {
                return 8;
            }
            case 109: {
                return 9;
            }
            case 110: {
                return 10;
            }
            case 104: {
                return 4;
            }
            case 111: {
                return 11;
            }
            case 112: {
                return 12;
            }
            case 105: {
                return 5;
            }
            case 113: {
                return 13;
            }
            case 102: {
                return 2;
            }
            case 106: {
                return 6;
            }
            case 101: {
                return 1;
            }
            case 107: {
                return 7;
            }
        }
        return 0;
    }

    public static Set<Integer> getSupportedSqlTypes() {
        return s_supportedSqlTypes;
    }

    public static int getVerboseTypeFromConciseType(int n) {
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                return 9;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 10;
            }
        }
        return n;
    }

    public static boolean isApproximateNumericType(int n) {
        return n == 7 || n == 6 || n == 8;
    }

    public static boolean isBinaryType(int n) {
        return n == -2 || n == -3 || n == -4;
    }

    public static boolean isBooleanType(int n) {
        return n == -7 || n == 16;
    }

    public static boolean isCharacterOrBinaryType(int n) {
        return TypeUtilities.isBinaryType(n) || TypeUtilities.isCharacterType(n);
    }

    public static boolean isCharacterType(int n) {
        return n == 12 || n == 1 || n == -8 || n == -9 || n == -1 || n == -10;
    }

    public static boolean isDateTimeType(int n) {
        return n == 91 || n == 92 || n == 93;
    }

    public static boolean isExactNumericType(int n) {
        return n == 2 || n == 3;
    }

    public static boolean isNumberType(int n) {
        return n == 2 || n == 3 || n == -6 || n == 5 || n == 4 || n == -5 || n == 8 || n == 6 || n == 7;
    }

    public static boolean isIntegerType(int n) {
        return n == -6 || n == 5 || n == 4 || n == -5;
    }

    public static boolean isIntervalType(int n) {
        switch (n) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLOBType(int n) {
        return n == -4 || n == -1 || n == -10;
    }

    public static boolean isTimeType(int n) {
        return n == 93 || n == 92;
    }

    public static int mapDataTypes(int n) {
        if (TypeUtilities.isIntervalType(n)) {
            return 1111;
        }
        if (-8 == n) {
            return 1;
        }
        if (-9 == n) {
            return 12;
        }
        if (-10 == n) {
            return -1;
        }
        if (-11 == n) {
            return 1111;
        }
        return n;
    }

    public static Integer getTypeForSqlTypeString(String string) {
        if (null == string) {
            throw new NullPointerException();
        }
        String string2 = string.trim().toUpperCase();
        if (!s_stringToSQLTypeMap.containsKey(string2)) {
            return null;
        }
        return s_stringToSQLTypeMap.get(string2);
    }

    public static String sqlTypeToString(short s) {
        switch (s) {
            case 2003: {
                return "SQL_ARRAY";
            }
            case -5: {
                return "SQL_BIGINT";
            }
            case 3: {
                return "SQL_DECIMAL";
            }
            case 8: {
                return "SQL_DOUBLE";
            }
            case 6: {
                return "SQL_FLOAT";
            }
            case 4: {
                return "SQL_INTEGER";
            }
            case 2: {
                return "SQL_NUMERIC";
            }
            case 0: {
                return "NULL";
            }
            case 7: {
                return "SQL_REAL";
            }
            case 5: {
                return "SQL_SMALLINT";
            }
            case -2: {
                return "SQL_BINARY";
            }
            case -7: {
                return "SQL_BIT";
            }
            case 16: {
                return "SQL_BOOLEAN";
            }
            case 1: {
                return "SQL_CHAR";
            }
            case -4: {
                return "SQL_LONGVARBINARY";
            }
            case -1: {
                return "SQL_LONGVARCHAR";
            }
            case 91: {
                return "SQL_TYPE_DATE";
            }
            case 92: {
                return "SQL_TYPE_TIME";
            }
            case 93: {
                return "SQL_TYPE_TIMESTAMP";
            }
            case -6: {
                return "SQL_TINYINT";
            }
            case -3: {
                return "SQL_VARBINARY";
            }
            case 12: {
                return "SQL_VARCHAR";
            }
            case -11: {
                return "SQL_GUID";
            }
            case -8: {
                return "SQL_WCHAR";
            }
            case -9: {
                return "SQL_WVARCHAR";
            }
            case -10: {
                return "SQL_WLONGVARCHAR";
            }
            case 103: {
                return "SQL_INTERVAL_DAY";
            }
            case 108: {
                return "SQL_INTERVAL_DAY_TO_HOUR";
            }
            case 109: {
                return "SQL_INTERVAL_DAY_TO_MINUTE";
            }
            case 110: {
                return "SQL_INTERVAL_DAY_TO_SECOND";
            }
            case 104: {
                return "SQL_INTERVAL_HOUR";
            }
            case 111: {
                return "SQL_INTERVAL_HOUR_TO_MINUTE";
            }
            case 112: {
                return "SQL_INTERVAL_HOUR_TO_SECOND";
            }
            case 105: {
                return "SQL_INTERVAL_MINUTE";
            }
            case 113: {
                return "SQL_INTERVAL_MINUTE_TO_SECOND";
            }
            case 102: {
                return "SQL_INTERVAL_MONTH";
            }
            case 106: {
                return "SQL_INTERVAL_SECOND";
            }
            case 101: {
                return "SQL_INTERVAL_YEAR";
            }
            case 107: {
                return "SQL_INTERVAL_YEAR_TO_MONTH";
            }
        }
        return null;
    }
}

