/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRJDBCResultSet;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCTableTypeOnlyMetadataSource
implements IMetadataSource {
    private DRJDBCClient m_client;
    private ILogger m_logger;
    private DRJDBCExecutionContext m_context;
    private DRJDBCResultSet m_results;
    private boolean m_isFetching = false;

    public DRJDBCTableTypeOnlyMetadataSource(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
        this.m_client = dRJDBCClient;
        this.m_context = this.m_client.executeStatementDirect("select DISTINCT TABLE_TYPE from INFORMATION_SCHEMA.`TABLES` WHERE TABLE_TYPE LIKE '%'");
        this.m_results = new DRJDBCResultSet(this.m_client, this.m_context, this.m_logger);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.close();
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.closeCursor();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case TABLE_TYPE: {
                return this.m_results.getData(0, l, l2, dataWrapper);
            }
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            try {
                return this.hasMoreRows();
            }
            catch (ErrorException errorException) {
                return false;
            }
        }
        this.m_isFetching = true;
        try {
            this.m_results.moveToNextRow();
            return this.m_results.moveToNextRow();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }
}

