/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCNumberConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCDoubleConverter
extends DRJDBCNumberConverter {
    private static final String TYPE_NAME = "Decimal";

    public static DRJDBCDoubleConverter getInstance() {
        return DRJDBCConverterHelper.INSTANCE;
    }

    @Override
    public BigDecimal getAsBigDecimal(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return BigDecimal.valueOf(DRJDBCDoubleConverter.getData(sqlAccessor, n));
    }

    @Override
    public byte getAsByte(SqlAccessor sqlAccessor, int n) throws ErrorException {
        double d = DRJDBCDoubleConverter.getData(sqlAccessor, n);
        DRJDBCDoubleConverter.verifyByteRange(d, TYPE_NAME);
        return (byte)d;
    }

    @Override
    public double getAsDouble(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCDoubleConverter.getData(sqlAccessor, n);
    }

    @Override
    public float getAsFloat(SqlAccessor sqlAccessor, int n) throws ErrorException {
        double d = DRJDBCDoubleConverter.getData(sqlAccessor, n);
        DRJDBCDoubleConverter.verifyFloatRange(d, TYPE_NAME);
        return (float)d;
    }

    @Override
    public int getAsInt(SqlAccessor sqlAccessor, int n) throws ErrorException {
        double d = DRJDBCDoubleConverter.getData(sqlAccessor, n);
        DRJDBCDoubleConverter.verifyIntRange(d, TYPE_NAME);
        return (int)d;
    }

    @Override
    public long getAsLong(SqlAccessor sqlAccessor, int n) throws ErrorException {
        double d = DRJDBCDoubleConverter.getData(sqlAccessor, n);
        DRJDBCDoubleConverter.verifyLongRange(d, TYPE_NAME);
        return (long)d;
    }

    @Override
    public short getAsShort(SqlAccessor sqlAccessor, int n) throws ErrorException {
        double d = DRJDBCDoubleConverter.getData(sqlAccessor, n);
        DRJDBCDoubleConverter.verifyShortRange(d, TYPE_NAME);
        return (short)d;
    }

    private DRJDBCDoubleConverter() {
    }

    public static double getData(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return sqlAccessor.getDouble(n);
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static class DRJDBCConverterHelper {
        private static final DRJDBCDoubleConverter INSTANCE = new DRJDBCDoubleConverter();

        private DRJDBCConverterHelper() {
        }
    }
}

