/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema;

import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCBigIntConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCDecimalConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCDoubleConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCFloatConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCIRBConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCIntConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCSmallIntConverter;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCTinyIntConverter;
import com.mapr.drill.support.exceptions.ErrorException;
import org.apache.drill.common.types.TypeProtos;

public class DRJDBCConverterFactory {
    public static DRJDBCIRBConverter generateNumericConverter(TypeProtos.MinorType minorType) throws ErrorException {
        switch (minorType) {
            case UINT8: 
            case BIGINT: {
                return DRJDBCBigIntConverter.getInstance();
            }
            case DECIMAL18: 
            case DECIMAL28DENSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL38SPARSE: 
            case DECIMAL9: {
                return DRJDBCDecimalConverter.getInstance();
            }
            case FLOAT4: {
                return DRJDBCFloatConverter.getInstance();
            }
            case FLOAT8: {
                return DRJDBCDoubleConverter.getInstance();
            }
            case UINT2: 
            case SMALLINT: {
                return DRJDBCSmallIntConverter.getInstance();
            }
            case UINT4: 
            case INT: {
                return DRJDBCIntConverter.getInstance();
            }
            case UINT1: 
            case TINYINT: {
                return DRJDBCTinyIntConverter.getInstance();
            }
        }
        return null;
    }
}

