/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

import com.mapr.drill.drill.api.DRJDBCDataTypeUtils;
import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCColumnMetadata;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCConverterFactory;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.exceptions.OperationCanceledException;
import com.mapr.drill.jdbc.common.CommonResultSet;
import com.mapr.drill.jdbc.utils.TimeExtend;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Warning;
import com.mapr.drill.support.WarningCode;
import com.mapr.drill.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCResultSet
extends CommonResultSet {
    private DRJDBCClient m_client;
    private final ILogger m_logger;
    private DRJDBCExecutionContext m_context;
    private UserBitShared.QueryResult.QueryState m_status;
    private boolean m_hasStartedFetch;
    private RecordBatchLoader m_recordBatchLoader;
    private int m_currentRecordBatchTotalRows;
    private int m_currentRowFetched;
    private SqlAccessor[] m_currentTableData;
    private ArrayList<DRJDBCColumnMetadata> m_columnMetadata;
    private int m_columnsNum;
    private final Object m_isCancelledLock = new Object();
    private boolean m_isCancelled;

    public DRJDBCResultSet(DRJDBCClient dRJDBCClient, DRJDBCExecutionContext dRJDBCExecutionContext, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, dRJDBCExecutionContext);
        this.m_client = dRJDBCClient;
        this.m_logger = iLogger;
        this.m_context = dRJDBCExecutionContext;
        this.m_status = UserBitShared.QueryResult.QueryState.FAILED;
        this.m_hasStartedFetch = false;
        this.m_recordBatchLoader = new RecordBatchLoader(dRJDBCExecutionContext.m_buffalloc);
        this.m_currentRecordBatchTotalRows = 0;
        this.m_currentRowFetched = 0;
        this.m_currentTableData = null;
        this.m_columnMetadata = null;
        this.m_columnsNum = 0;
    }

    public DRJDBCResultSet(DRJDBCClient dRJDBCClient, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient);
        this.m_client = dRJDBCClient;
        this.m_logger = iLogger;
        this.m_status = UserBitShared.QueryResult.QueryState.FAILED;
        this.m_hasStartedFetch = false;
        this.m_currentRecordBatchTotalRows = 0;
        this.m_currentRowFetched = 0;
        this.m_currentTableData = null;
        this.m_columnMetadata = null;
        this.m_columnsNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_isCancelledLock;
        synchronized (object) {
            this.m_isCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_isCancelledLock;
        synchronized (object) {
            this.m_isCancelled = false;
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_context.m_resultListener.terminate();
        this.m_recordBatchLoader.clear();
        super.close();
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        DRJDBCColumnMetadata dRJDBCColumnMetadata = this.m_columnMetadata.get(n);
        short s = DRJDBCDataTypeUtils.mapDrillTypeNameToSqltype(dRJDBCColumnMetadata.getTypeMetadata().getTypeName());
        int n2 = this.m_currentRowFetched - 1;
        SqlAccessor sqlAccessor = this.m_currentTableData[n];
        if (sqlAccessor.isNull(n2)) {
            dataWrapper.setNull(s);
            return false;
        }
        try {
            switch (s) {
                case 1: {
                    dataWrapper.setChar(sqlAccessor.getString(n2));
                    return false;
                }
                case 12: {
                    dataWrapper.setVarChar(sqlAccessor.getObject(n2).toString());
                    return false;
                }
                case 3: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setDecimal(dRJDBCColumnMetadata.getConverter().getAsBigDecimal(sqlAccessor, n2));
                    } else {
                        dataWrapper.setDecimal(sqlAccessor.getBigDecimal(n2));
                    }
                    return false;
                }
                case -7: {
                    boolean bl = false;
                    int n3 = sqlAccessor.getInt(n2);
                    if (n3 == 1) {
                        bl = true;
                    }
                    dataWrapper.setBit(bl);
                    return false;
                }
                case 16: {
                    dataWrapper.setBoolean(sqlAccessor.getBoolean(n2));
                    return false;
                }
                case -6: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setTinyInt(dRJDBCColumnMetadata.getConverter().getAsByte(sqlAccessor, n2));
                    } else {
                        dataWrapper.setTinyInt(sqlAccessor.getByte(n2));
                    }
                    return false;
                }
                case 5: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setSmallInt(dRJDBCColumnMetadata.getConverter().getAsShort(sqlAccessor, n2));
                    } else {
                        dataWrapper.setSmallInt(sqlAccessor.getShort(n2));
                    }
                    return false;
                }
                case 4: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setInteger(dRJDBCColumnMetadata.getConverter().getAsInt(sqlAccessor, n2));
                    } else {
                        dataWrapper.setInteger(sqlAccessor.getInt(n2));
                    }
                    return false;
                }
                case -5: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setBigInt(dRJDBCColumnMetadata.getConverter().getAsLong(sqlAccessor, n2));
                    } else {
                        dataWrapper.setBigInt(sqlAccessor.getLong(n2));
                    }
                    return false;
                }
                case 7: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setReal(dRJDBCColumnMetadata.getConverter().getAsFloat(sqlAccessor, n2));
                    } else {
                        dataWrapper.setReal(sqlAccessor.getFloat(n2));
                    }
                    return false;
                }
                case 6: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setFloat(dRJDBCColumnMetadata.getConverter().getAsFloat(sqlAccessor, n2));
                    } else {
                        dataWrapper.setFloat(sqlAccessor.getDouble(n2));
                    }
                    return false;
                }
                case 8: {
                    if (dRJDBCColumnMetadata.hasConverter()) {
                        dataWrapper.setDouble(dRJDBCColumnMetadata.getConverter().getAsDouble(sqlAccessor, n2));
                    } else {
                        dataWrapper.setDouble(sqlAccessor.getDouble(n2));
                    }
                    return false;
                }
                case -2: {
                    dataWrapper.setBinary(sqlAccessor.getBytes(n2));
                    return false;
                }
                case -3: {
                    dataWrapper.setVarBinary(sqlAccessor.getBytes(n2));
                    return false;
                }
                case 91: {
                    dataWrapper.setDate(Date.valueOf(sqlAccessor.getString(n2)));
                    return false;
                }
                case 92: {
                    String string = sqlAccessor.getString(n2);
                    try {
                        dataWrapper.setTime(Time.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 101, DRJDBCMessageKey.DATA_TRUNCATED_ERR.name(), new String[]{string, "hh:mm:ss"}));
                        try {
                            java.util.Date date = new SimpleDateFormat("hh:mm:ss.SSS").parse(string);
                            dataWrapper.setTime(new TimeExtend(date.getTime()));
                            LogUtilities.logTrace("Successfully parsed returned time " + string + " using hh:mm:ss.SSS format", this.m_logger);
                        }
                        catch (ParseException parseException) {
                            LogUtilities.logError("Unable to parse returned time: " + string + " because it is not in a proper time format", this.m_logger);
                            throw new Exception("Unable to parse invalid formatted time: " + string);
                        }
                    }
                    return false;
                }
                case 93: {
                    dataWrapper.setTimestamp(Timestamp.valueOf(sqlAccessor.getString(n2)));
                    return false;
                }
            }
            dataWrapper.setNull(s);
            return false;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_FETCH_ERR.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    public ArrayList<DRJDBCColumnMetadata> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, "Column Metadata: " + this.m_columnMetadata);
        return this.m_columnMetadata;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentRowFetched < this.m_currentRecordBatchTotalRows) {
            ++this.m_currentRowFetched;
            return true;
        }
        this.m_currentRowFetched = 1;
        return this.doLoadRecordBatchData();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    public boolean supportsHasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    public void openCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkCancelState();
        if (!this.m_hasStartedFetch) {
            return this.doLoadRecordBatchData();
        }
        return this.hasMoreRows();
    }

    protected void updateContext(DRJDBCExecutionContext dRJDBCExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, dRJDBCExecutionContext);
        this.m_context = dRJDBCExecutionContext;
        this.m_status = UserBitShared.QueryResult.QueryState.FAILED;
        this.m_hasStartedFetch = false;
        this.m_recordBatchLoader = new RecordBatchLoader(dRJDBCExecutionContext.m_buffalloc);
        this.m_currentRecordBatchTotalRows = 0;
        this.m_currentRowFetched = 0;
        this.m_currentTableData = null;
        this.m_columnsNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancelState() throws OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_isCancelledLock;
        synchronized (object) {
            if (this.m_isCancelled) {
                this.m_context.m_resultListener.terminate();
                throw new OperationCanceledException(101, "OP_CANCELLED_ERR");
            }
        }
    }

    private void checkQueryStatus(UserBitShared.QueryResult.QueryState queryState) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, queryState);
        this.m_context.m_resultListener.terminate();
        if (UserBitShared.QueryResult.QueryState.CANCELED == queryState) {
            throw new OperationCanceledException(101, "OP_CANCELLED_ERR");
        }
        if (UserBitShared.QueryResult.QueryState.FAILED == queryState) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.QUERY_EXECUTION_ERR.name(), "QueryState is FAILED");
        }
    }

    private boolean doLoadRecordBatchData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_recordBatchLoader || null == this.m_context.m_buffalloc) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.BUFFER_ALLOC_ERR.name(), new String[]{"Null BufferAllocator | Null RecordBatchLoader"});
        }
        QueryDataBatch queryDataBatch = null;
        queryDataBatch = this.m_context.m_resultListener.getNextBatch();
        this.checkCancelState();
        if (null == queryDataBatch) {
            if (this.m_context.m_resultListener.hasExecutionResult()) {
                this.m_status = this.m_context.m_resultListener.getStatus();
                this.checkQueryStatus(this.m_status);
            }
            return false;
        }
        if (!this.m_hasStartedFetch) {
            if (this.m_columnMetadata == null) {
                this.m_columnMetadata = this.m_client.getResultSetMetadata(queryDataBatch);
            }
            this.m_hasStartedFetch = true;
        }
        this.m_currentTableData = null;
        try {
            this.m_recordBatchLoader.load(queryDataBatch.getHeader().getDef(), queryDataBatch.getData());
        }
        catch (SchemaChangeException schemaChangeException) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.SCHEMA_CHANGE_ERR.name(), new String[]{schemaChangeException.getMessage()}, (Throwable)schemaChangeException);
        }
        this.m_columnsNum = this.m_columnMetadata.size();
        LogUtilities.logDebug("Schema change check: Column count. Expecting: " + this.m_columnsNum + " Received: " + this.m_recordBatchLoader.getSchema().getFieldCount(), this.m_logger);
        if (this.m_recordBatchLoader.getSchema().getFieldCount() < this.m_columnsNum) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.SCHEMA_CHANGE_ERR.name(), new String[]{"Column count mismatch due to late-disappearing columns."});
        }
        if (this.m_recordBatchLoader.getSchema().getFieldCount() > this.m_columnsNum) {
            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, DRJDBCMessageKey.SCHEMA_CHANGE_ERR.name(), new String[]{"Column count mismatch. Late-appearing columns were not returned in this resultset."}));
        }
        this.m_currentTableData = new SqlAccessor[this.m_columnsNum];
        for (int i = 0; i < this.m_columnsNum; ++i) {
            SqlAccessor sqlAccessor = TypeHelper.getSqlAccessor((ValueVector)this.m_recordBatchLoader.getValueAccessorById(null, new int[]{i}).getValueVector());
            if (sqlAccessor.getType().hasMinorType()) {
                short s;
                TypeProtos.MinorType minorType = sqlAccessor.getType().getMinorType();
                short s2 = DRJDBCDataTypeUtils.mapDrillTypeNameToSqltype(minorType.name());
                if (s2 != (s = this.m_columnMetadata.get(i).getTypeMetadata().getType())) {
                    String string = "Schema change check: Data Type. Column data type mismatch at column index " + i + ". Expecting Type: " + s + " Received: " + s2;
                    LogUtilities.logDebug(string, this.m_logger);
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, DRJDBCMessageKey.SCHEMA_CHANGE_ERR.name(), new String[]{string}));
                    if (this.m_columnMetadata.get(i).isNumberType()) {
                        this.m_columnMetadata.get(i).setConverter(DRJDBCConverterFactory.generateNumericConverter(minorType));
                    }
                } else {
                    this.m_columnMetadata.get(i).setConverter(null);
                }
            } else {
                LogUtilities.logDebug("Schema change check: Data Type. Unable to to verify minor type.", this.m_logger);
            }
            this.m_currentTableData[i] = sqlAccessor;
        }
        this.m_currentRecordBatchTotalRows = queryDataBatch.getHeader().getRowCount();
        return true;
    }
}

