/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.dataengine.DRJDBCQueryExecutor;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCCatalogOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCColumnsMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCSchemaOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTableTypeOnlyMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTablesMetadataSource;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCTypeInfoMetadataSource;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.dataengine.impl.DSIDataEngine;
import com.mapr.drill.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.interfaces.IQueryExecutor;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceID;
import com.mapr.drill.dsi.exceptions.ParsingException;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCDataEngine
extends DSIDataEngine {
    private DRJDBCClient m_client;
    private boolean m_isDirectExecution;

    public DRJDBCDataEngine(IStatement iStatement, DRJDBCClient dRJDBCClient, ILogger iLogger) throws ErrorException {
        super(iStatement);
        LogUtilities.logFunctionEntrance(this.getLog(), iStatement, dRJDBCClient);
        this.m_client = dRJDBCClient;
        this.m_isDirectExecution = false;
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        return new DRJDBCQueryExecutor(this.m_client, this.getLog(), string, this.m_isDirectExecution);
    }

    @Override
    public void setDirectExecute() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isDirectExecution = true;
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        IMetadataSource iMetadataSource = null;
        switch (metadataSourceID) {
            case TYPE_INFO: {
                iMetadataSource = new DRJDBCTypeInfoMetadataSource(this.getLog());
                break;
            }
            case CATALOG_SCHEMA_ONLY: {
                break;
            }
            case SCHEMA_ONLY: {
                iMetadataSource = new DRJDBCSchemaOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case CATALOG_ONLY: {
                iMetadataSource = new DRJDBCCatalogOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case COLUMNS: {
                iMetadataSource = new DRJDBCColumnsMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case TABLES: {
                iMetadataSource = new DRJDBCTablesMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case TABLETYPE_ONLY: {
                iMetadataSource = new DRJDBCTableTypeOnlyMetadataSource(this.getLog(), this.m_client, map);
                break;
            }
            case PRIMARY_KEYS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case FOREIGN_KEYS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case COLUMN_PRIVILEGES: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case TABLE_PRIVILEGES: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            case STATISTICS: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                break;
            }
            default: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return iMetadataSource;
    }
}

