/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;

public class DRJDBCConnectionSettings {
    public String m_drillbit;
    public String m_zooKeeper;
    public Boolean m_isDirect;
    public String m_username;
    public String m_password;
    public Boolean m_isAnyToVarchar;
    public String m_excludedSchemas;
    public String m_includedSchemas;
    public int m_stringColumnLength;

    public DRJDBCConnectionSettings(String string, String string2, String string3, String string4, Boolean bl, String string5, String string6, int n, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, string2, string3, bl, string5, string6);
        if (string == null && string2 == null) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{null, null, "A connection type is required. Please format like such: drillbit=host:port or zk=zk_quorum:zk_port/schema/drillbit_node"});
        }
        if (string2 != null && string2.toLowerCase().trim().startsWith("zk")) {
            this.m_zooKeeper = string2.trim();
            this.m_isDirect = false;
        } else {
            this.m_drillbit = string.trim();
            this.m_isDirect = true;
        }
        this.m_username = string3;
        this.m_password = string4;
        this.m_isAnyToVarchar = bl == null ? Boolean.valueOf(false) : bl;
        this.m_excludedSchemas = string5;
        this.m_includedSchemas = string6;
        this.m_stringColumnLength = n;
    }
}

