/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.core.DRJDBCEnvironment;
import com.mapr.drill.drill.core.DRJDBCPropertyKey;
import com.mapr.drill.drill.core.DRJDBCStatement;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.core.impl.DSIConnection;
import com.mapr.drill.dsi.core.impl.DSILogger;
import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.core.utilities.ConnSettingRequestMap;
import com.mapr.drill.dsi.core.utilities.ConnSettingResponseMap;
import com.mapr.drill.dsi.core.utilities.PropertyUtilities;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.dsi.exceptions.BadAuthException;
import com.mapr.drill.jdbc.common.CommonCoreUtils;
import com.mapr.drill.jdbc.common.ProductInfoHandler;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.Warning;
import com.mapr.drill.support.WarningCode;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.drill.common.Version;

public class DRJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private static final String LOG_PREFIX_NAME = "DrillJDBC_connection_";
    private static final int DOUBLE_DIGIT_MIN = 10;
    private static final String ZERO_STR = "0";
    private static final String DOT = ".";
    private static final int VERSION_PATCH_MIN_LEN = 4;
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 65535;
    private DRJDBCClient m_client;
    private DRJDBCConnectionSettings m_settings;
    protected ILogger m_logger;
    private Set<String> m_definedSettings = new HashSet<String>();
    private ProductInfoHandler m_productInfoHandler = new ProductInfoHandler("MapRDrillJDBCDriver.lic", "MapR Drill JDBC Driver", "1.5.9.1018", DRJDBCDriver.class);

    public DRJDBCConnection(DRJDBCEnvironment dRJDBCEnvironment) throws ErrorException {
        super(dRJDBCEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), dRJDBCEnvironment);
        ++s_connectionID;
        this.setDefaultProperties();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_client) {
            this.m_client.closeSession();
        }
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, String.valueOf(1), String.valueOf(5), String.valueOf(9), String.valueOf(1018));
        try {
            this.m_productInfoHandler.validateLicense();
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.LICENSE_VALIDATION_ERROR.name(), exception);
        }
        this.m_settings = this.getConnectionSettings(connSettingRequestMap);
        Properties properties = new Properties();
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        DRJDBCPropertyKey.initConnStrKeys(this.m_definedSettings);
        if (this.m_settings.m_isDirect.booleanValue()) {
            treeMap.put("drillbit", connSettingRequestMap.getProperty("drillbit").getString().trim());
        } else {
            treeMap.put("zk", connSettingRequestMap.getProperty("zk").getString().trim());
        }
        if (connSettingRequestMap.containsKey("UID")) {
            treeMap.put("user", connSettingRequestMap.getProperty("UID").getString());
        }
        if (connSettingRequestMap.containsKey("PWD")) {
            treeMap.put("password", connSettingRequestMap.getProperty("PWD").getString());
        }
        if (null != this.getOptionalSetting("DelegationUID", connSettingRequestMap)) {
            treeMap.put("impersonation_target", connSettingRequestMap.getProperty("DelegationUID").getString());
        }
        if (null != this.getOptionalSetting("AuthMech", connSettingRequestMap)) {
            treeMap.put("auth", connSettingRequestMap.getProperty("AuthMech").getString());
        } else if (null != this.getOptionalSetting("auth", connSettingRequestMap)) {
            treeMap.put("auth", connSettingRequestMap.getProperty("auth").getString());
        }
        if (null != this.getOptionalSetting("KrbRealm", connSettingRequestMap)) {
            treeMap.put("realm", connSettingRequestMap.getProperty("KrbRealm").getString());
        } else if (null != this.getOptionalSetting("realm", connSettingRequestMap)) {
            treeMap.put("realm", connSettingRequestMap.getProperty("realm").getString());
        }
        if (null != this.getOptionalSetting("KrbServiceName", connSettingRequestMap)) {
            treeMap.put("service_name", connSettingRequestMap.getProperty("KrbServiceName").getString());
        } else if (null != this.getOptionalSetting("service_name", connSettingRequestMap)) {
            treeMap.put("service_name", connSettingRequestMap.getProperty("service_name").getString());
        }
        if (null != this.getOptionalSetting("KrbHostFQDN", connSettingRequestMap)) {
            treeMap.put("service_host", connSettingRequestMap.getProperty("KrbHostFQDN").getString());
        } else if (null != this.getOptionalSetting("service_host", connSettingRequestMap)) {
            treeMap.put("service_host", connSettingRequestMap.getProperty("service_host").getString());
        }
        if (null != this.getOptionalSetting("KrbPrincipal", connSettingRequestMap)) {
            treeMap.put("principal", connSettingRequestMap.getProperty("KrbPrincipal").getString());
        } else if (null != this.getOptionalSetting("principal", connSettingRequestMap)) {
            treeMap.put("principal", connSettingRequestMap.getProperty("principal").getString());
        }
        if (null != this.getOptionalSetting("KrbKeytab", connSettingRequestMap)) {
            treeMap.put("keytab", connSettingRequestMap.getProperty("KrbKeytab").getString());
        } else if (null != this.getOptionalSetting("keytab", connSettingRequestMap)) {
            treeMap.put("keytab", connSettingRequestMap.getProperty("keytab").getString());
        }
        if (null != this.getOptionalSetting("schema", connSettingRequestMap)) {
            treeMap.put("schema", connSettingRequestMap.getProperty("schema").getString());
        }
        properties.putAll((Map<?, ?>)treeMap);
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.m_definedSettings.contains(string.toLowerCase())) continue;
            String string2 = connSettingRequestMap.getProperty(string).getString().trim();
            properties.put(string, string2);
        }
        this.m_client = new DRJDBCClient(this.m_settings, properties, this.getWarningListener(), this.getConnectionLog());
        this.initDatabaseMetadataInfo();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new DRJDBCStatement(this);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_client) {
            this.m_client.closeSession();
        }
    }

    @Override
    public ILogger getConnectionLog() {
        if (this.m_logger == null) {
            this.m_logger = new DSILogger(LOG_PREFIX_NAME + Integer.toString(s_connectionID));
            this.m_logger.setLocale(this.getLocale());
        }
        return this.m_logger;
    }

    public DRJDBCConnectionSettings getConnectionSettings() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_settings;
    }

    public DRJDBCClient getDrillClient() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_client;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String string : DRJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    private DRJDBCConnectionSettings getConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        String string = null;
        Variant variant = this.getOptionalSetting("drillbit", connSettingRequestMap);
        if (variant != null) {
            string = "drillbit=" + variant.getString();
        }
        String string2 = null;
        variant = this.getOptionalSetting("zk", connSettingRequestMap);
        if (variant != null) {
            string2 = "zk=" + variant.getString();
        }
        String string3 = null;
        variant = this.getOptionalSetting("UID", connSettingRequestMap);
        if (variant != null) {
            string3 = variant.getString();
        }
        String string4 = null;
        variant = this.getOptionalSetting("PWD", connSettingRequestMap);
        if (variant != null) {
            string4 = variant.getString();
        }
        Boolean bl = null;
        variant = this.getOptionalSetting("castAnyToVarchar", connSettingRequestMap);
        if (variant != null && !(bl = Boolean.valueOf(Boolean.parseBoolean(variant.getString()))).booleanValue() && !variant.getString().equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.getWarningListener().postWarning(new Warning(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, 101, DRJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{variant.getString(), "castAnyToVarchar", "true or false on whether to cast data type ANY to data typeVARCHAR. Falling back to default value false"}));
        }
        String string5 = null;
        variant = this.getOptionalSetting("excludedSchemas", connSettingRequestMap);
        if (null != variant) {
            string5 = variant.getString();
        }
        String string6 = null;
        variant = this.getOptionalSetting("includedSchemas", connSettingRequestMap);
        if (null != variant) {
            string6 = variant.getString();
        }
        int n = 65535;
        variant = this.getOptionalSetting("StringColumnLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                n = variant.getInt();
            }
        }
        catch (Exception exception) {
            LogUtilities.logInfo("Setting default string column length: " + n, this.getConnectionLog());
        }
        return new DRJDBCConnectionSettings(string, string2, string3, string4, bl, string5, string6, n, this.m_logger, this.getWarningListener());
    }

    private void initDatabaseMetadataInfo() throws ErrorException {
        try {
            Version version;
            String string = this.m_client.getServerName();
            if (null != string) {
                this.setProperty(41, new Variant(0, string));
            }
            if (null != (version = this.m_client.getServerVersionInfo())) {
                int n = version.getMajorVersion();
                int n2 = version.getMinorVersion();
                int n3 = version.getPatchVersion();
                String string2 = (n < 10 ? ZERO_STR : "") + n + DOT + (n2 < 10 ? ZERO_STR : "") + n2 + DOT;
                String string3 = String.valueOf(n3);
                for (int i = 0; i < 4 - string3.length(); ++i) {
                    string2 = string2 + ZERO_STR;
                }
                string2 = string2 + n3;
                this.setProperty(42, new Variant(0, string2));
            }
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{exception.getMessage()}, (Throwable)exception);
        }
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            PropertyUtilities.setReadOnly(this, true);
            PropertyUtilities.setCatalogSupport(this, false);
            PropertyUtilities.setSchemaSupport(this, true);
            this.setProperty(100, new Variant(3, 5L));
            PropertyUtilities.setSavepointSupport(this, false);
            PropertyUtilities.setStoredProcedureSupport(this, false);
            PropertyUtilities.setStoredFunctionsCallsSupport(this, false);
            this.setProperty(101, new Variant(0, "DrillJDBC"));
            this.setProperty(41, new Variant(0, "DRILL"));
            this.setProperty(58, new Variant(0, "`"));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0000')));
            this.setProperty(139, new Variant(0, "User"));
        }
        catch (Exception exception) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getMessage());
        }
    }
}

