/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.client;

import com.mapr.drill.drill.api.DRJDBCDataTypeUtils;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRQryResultListener;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCColumnMetadata;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.DiagState;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.drill.common.Version;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;

public class DRJDBCClient {
    protected DrillClient m_drillClient;
    protected DRJDBCConnectionSettings m_settings;
    protected ILogger m_logger;
    protected IWarningListener m_warningListener;
    private boolean m_hasOpenSession;

    public DRJDBCClient(DRJDBCConnectionSettings dRJDBCConnectionSettings, Properties properties, IWarningListener iWarningListener, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCConnectionSettings, properties);
        this.m_settings = dRJDBCConnectionSettings;
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_hasOpenSession = false;
        this.setSystemProperties(this.m_settings);
        if (this.m_settings.m_isDirect.booleanValue()) {
            this.openSession(properties.getProperty("drillbit"), properties);
        } else {
            this.openSession(properties.getProperty("zk"), properties);
        }
    }

    public void cancel(UserBitShared.QueryId queryId) {
        LogUtilities.logFunctionEntrance(this.m_logger, queryId);
        if (null != queryId) {
            this.m_drillClient.cancelQuery(queryId);
        }
    }

    public void closeSession() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasOpenSession) {
            this.m_drillClient.close();
            this.m_hasOpenSession = false;
        }
    }

    public DRJDBCExecutionContext executeStatementDirect(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        DRJDBCExecutionContext dRJDBCExecutionContext = new DRJDBCExecutionContext();
        dRJDBCExecutionContext.m_resultListener = new DRQryResultListener(this.m_logger);
        BufferAllocator bufferAllocator = this.m_drillClient.getAllocator();
        if (bufferAllocator == null) {
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.BUFFER_ALLOC_ERR.name(), new String[]{"Unable to getAllocator."});
        }
        dRJDBCExecutionContext.m_buffalloc = bufferAllocator;
        this.m_drillClient.runQuery(UserBitShared.QueryType.SQL, string, (UserResultsListener)dRJDBCExecutionContext.m_resultListener);
        return dRJDBCExecutionContext;
    }

    public ArrayList<DRJDBCColumnMetadata> getResultSetMetadata(QueryDataBatch queryDataBatch) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, queryDataBatch.hasData());
        UserBitShared.QueryData queryData = queryDataBatch.getHeader();
        UserBitShared.RecordBatchDefOrBuilder recordBatchDefOrBuilder = queryData.getDefOrBuilder();
        List list = recordBatchDefOrBuilder.getFieldList();
        ArrayList<DRJDBCColumnMetadata> arrayList = new ArrayList<DRJDBCColumnMetadata>();
        for (UserBitShared.SerializedField serializedField : list) {
            try {
                arrayList.add(DRJDBCDataTypeUtils.createColumn(null, null, null, serializedField, this.m_settings));
            }
            catch (Exception exception) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{exception.getMessage()}, (Throwable)exception);
            }
        }
        return arrayList;
    }

    public String getServerName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasOpenSession) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, "No valid connection");
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
        }
        return this.m_drillClient.getServerName();
    }

    public Version getServerVersionInfo() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasOpenSession) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 6, "No valid connection");
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{errorException.getMessage()}, (Throwable)errorException);
        }
        return this.m_drillClient.getServerVersion();
    }

    public DRJDBCConnectionSettings getSettings() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_settings;
    }

    private void openSession(String string, Properties properties) throws ErrorException {
        DrillConfig drillConfig = DrillConfig.forClient();
        ClusterCoordinator clusterCoordinator = null;
        BufferAllocator bufferAllocator = RootAllocatorFactory.newRoot((DrillConfig)drillConfig);
        this.m_drillClient = new DrillClient(drillConfig, clusterCoordinator, bufferAllocator, this.m_settings.m_isDirect.booleanValue());
        this.m_drillClient.setSupportComplexTypes(false);
        try {
            this.m_drillClient.connect(string, properties);
            this.m_hasOpenSession = true;
        }
        catch (RpcException rpcException) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 6, string);
            throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.CONN_GENERAL_ERR.name(), new String[]{rpcException.getMessage()}, (Throwable)errorException);
        }
    }

    private void setSystemProperties(DRJDBCConnectionSettings dRJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Properties properties = System.getProperties();
        if (!this.m_settings.m_isDirect.booleanValue()) {
            properties.setProperty("zookeeper.sasl.client", "false");
        }
        if ("MapR".equalsIgnoreCase("MapR")) {
            properties.setProperty("drill.customAuthFactories", "org.apache.drill.exec.rpc.security.maprsasl.MapRSaslFactory");
        }
    }
}

