/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.api;

import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCColumnMetadata;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.utilities.Nullable;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.dataengine.utilities.TypeUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.HashMap;
import org.apache.drill.exec.proto.UserBitShared;

public class DRJDBCDataTypeUtils {
    private static HashMap<String, Short> s_drillTypeToSQLType;

    public static DRJDBCColumnMetadata createColumn(String string, String string2, String string3, UserBitShared.SerializedField serializedField, DRJDBCConnectionSettings dRJDBCConnectionSettings) throws Exception {
        TypeMetadata typeMetadata = null;
        String string4 = serializedField.getMajorType().getMinorType().name();
        Short s = s_drillTypeToSQLType.get(string4);
        if (s == null) {
            string4 = "VARCHAR";
            s = 12;
        }
        typeMetadata = TypeMetadata.createTypeMetadata(s.shortValue());
        DRJDBCColumnMetadata dRJDBCColumnMetadata = new DRJDBCColumnMetadata(typeMetadata);
        String string5 = serializedField.getNamePart().getName();
        int n = serializedField.getBufferLength();
        if (TypeUtilities.isCharacterOrBinaryType(s.shortValue())) {
            n = dRJDBCConnectionSettings.m_stringColumnLength;
        }
        typeMetadata.setTypeName(string4);
        dRJDBCColumnMetadata.setCatalogName(string);
        dRJDBCColumnMetadata.setColumnLength(n);
        dRJDBCColumnMetadata.setLabel(string5);
        dRJDBCColumnMetadata.setName(string5);
        dRJDBCColumnMetadata.setNullable(Nullable.NULLABLE);
        dRJDBCColumnMetadata.setSchemaName(string2);
        dRJDBCColumnMetadata.setTableName(string3);
        return dRJDBCColumnMetadata;
    }

    public static short mapDrillTypeNameToSqltype(String string) throws ErrorException {
        Short s = s_drillTypeToSQLType.get(string.trim());
        if (null != s) {
            return s;
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_FETCH_ERR.name(), new String[]{string.trim() + " Data type is not supported."});
    }

    private static void initializeDrillTypeToSQLTypeMap() {
        s_drillTypeToSQLType = new HashMap();
        s_drillTypeToSQLType.put("CHAR", (short)1);
        s_drillTypeToSQLType.put("VARCHAR", (short)12);
        s_drillTypeToSQLType.put("DECIMAL9", (short)3);
        s_drillTypeToSQLType.put("DECIMAL18", (short)3);
        s_drillTypeToSQLType.put("DECIMAL28DENSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL38DENSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL28SPARSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL38SPARSE", (short)3);
        s_drillTypeToSQLType.put("BIT", (short)-7);
        s_drillTypeToSQLType.put("BOOLEAN", (short)16);
        s_drillTypeToSQLType.put("TINYINT", (short)-6);
        s_drillTypeToSQLType.put("SMALLINT", (short)5);
        s_drillTypeToSQLType.put("INT", (short)4);
        s_drillTypeToSQLType.put("BIGINT", (short)-5);
        s_drillTypeToSQLType.put("FLOAT4", (short)7);
        s_drillTypeToSQLType.put("FLOAT", (short)6);
        s_drillTypeToSQLType.put("FLOAT8", (short)8);
        s_drillTypeToSQLType.put("BINARY", (short)-2);
        s_drillTypeToSQLType.put("VARBINARY", (short)-3);
        s_drillTypeToSQLType.put("DATE", (short)91);
        s_drillTypeToSQLType.put("TIME", (short)92);
        s_drillTypeToSQLType.put("TIMESTAMP", (short)93);
        s_drillTypeToSQLType.put("TIMESTAMPTZ", (short)93);
        s_drillTypeToSQLType.put("INTERVALDAY", (short)12);
        s_drillTypeToSQLType.put("INTERVALYEAR", (short)12);
        s_drillTypeToSQLType.put("INTERVAL", (short)12);
    }

    static {
        DRJDBCDataTypeUtils.initializeDrillTypeToSQLTypeMap();
    }
}

