/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mapr.ycsb.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger _logger = LoggerFactory.getLogger(Command.class);
    private String name;
    private String cmd;
    private String runwith = "/bin/bash";
    private String script;
    private boolean background = false;
    @JsonProperty(value="linger_for")
    private int linger_for = 0;

    public String getName() {
        return this.name;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getRunwith() {
        return this.runwith;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isBackground() {
        return this.background;
    }

    public int getLingerFor() {
        return this.linger_for;
    }

    public Desc run(Config config) throws IOException {
        if (this.cmd != null) {
            return this.runCommand(config);
        }
        if (this.script != null) {
            return this.runScript(config);
        }
        throw new IllegalArgumentException("Either a command or a script must be specified.");
    }

    private Desc runScript(Config config) throws IOException {
        if (this.script.length() == 0) {
            throw new IllegalArgumentException("Can not run empty script.");
        }
        File scriptFile = File.createTempFile("ycsb", ".sh");
        FileUtils.writeStringToFile((File)scriptFile, (String)this.script, (Charset)StandardCharsets.UTF_8);
        CommandLine cmdLine = new CommandLine(new File(this.runwith));
        cmdLine.addArgument(scriptFile.getAbsolutePath());
        return this.start(config, cmdLine);
    }

    private Desc runCommand(Config config) throws IOException {
        if (this.cmd.length() == 0) {
            throw new IllegalArgumentException("Can not run empty command.");
        }
        CommandLine cmdLine = CommandLine.parse((String)this.cmd.toString());
        return this.start(config, cmdLine);
    }

    private Desc start(Config config, CommandLine cmdLine) throws IOException {
        _logger.info("Starting {}.", (Object)cmdLine.toString());
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(config.getWorkingDir());
        if (this.name == null) {
            this.name = new File(cmdLine.getExecutable()).getName();
        }
        File logFile = new File(config.getWorkingDir(), "./logs/" + this.name + "_" + (int)(Math.random() * 1024.0) + "_out.log");
        _logger.info("Logging output to '{}'", (Object)logFile);
        Desc desc = new Desc();
        desc.out = new FileOutputStream(logFile);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(desc.out));
        if (this.background) {
            desc.resultHandler = new DefaultExecuteResultHandler();
            desc.watchDog = new ExecuteWatchdog(-1L);
            executor.setWatchdog(desc.watchDog);
            executor.execute(cmdLine, (ExecuteResultHandler)desc.resultHandler);
        } else {
            executor.execute(cmdLine);
            desc.out.close();
            desc.out = null;
        }
        return desc;
    }

    public String toString() {
        return this.cmd != null ? this.cmd : this.script;
    }

    public class Desc {
        ExecuteWatchdog watchDog;
        OutputStream out;
        DefaultExecuteResultHandler resultHandler;

        public Command command() {
            return Command.this;
        }
    }
}

