/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.mapr.ycsb.config.Config;
import com.mapr.ycsb.db.DocumentBuilder;
import com.mapr.ycsb.db.DocumentSizeCalculator;
import com.mapr.ycsb.workload.Workload;
import java.util.Map;

public class Benchmark {
    private final Map<String, String> props;
    private final Workload[] workloads;
    private final Params params;
    private long documentCount;
    private long rowSize;
    private Config config;
    private boolean initialized_ = false;
    private DocumentBuilder.Config documentBuilderConfig = new DocumentBuilder.Config();

    @JsonCreator
    public Benchmark(@JsonProperty(value="param") Params params, @JsonProperty(value="common") Map<String, String> props, @JsonProperty(value="workloads") Workload[] workloads) {
        this.params = params;
        this.props = Maps.newHashMap(props);
        this.workloads = workloads;
    }

    @JsonIgnore
    public Benchmark setConfig(Config config) {
        this.config = config;
        return this;
    }

    public synchronized Benchmark checkInit() {
        if (!this.initialized_) {
            long fieldLength;
            long fieldCount;
            if (this.config == null) {
                throw new IllegalStateException("No configuration has been set yet!!!");
            }
            if ("json".equalsIgnoreCase(this.config.getTableInfo().getType()) && "withschema".equalsIgnoreCase(this.documentBuilderConfig.type)) {
                this.rowSize = DocumentSizeCalculator.calculate(this.config);
            } else if (this.config.getTableInfo().getMulticf()) {
                fieldCount = Long.parseLong(this.props.get("fieldcount"));
                fieldLength = Long.parseLong(this.props.get("fieldlength"));
                this.rowSize = this.params.keysize + (fieldCount - 1L) * (fieldLength + this.params.field_overhead) + (fieldLength * 90L + this.params.field_overhead);
            } else {
                fieldCount = Long.parseLong(this.props.get("fieldcount"));
                fieldLength = Long.parseLong(this.props.get("fieldlength"));
                this.rowSize = this.params.keysize + fieldCount * (fieldLength + this.params.field_overhead);
            }
            this.documentCount = this.params.datasize / this.rowSize;
            this.props.put("recordcount", String.valueOf(this.documentCount));
            for (Workload workload : this.workloads) {
                workload.merge(this.props);
            }
            this.initialized_ = true;
        }
        return this;
    }

    public Map<String, String> getProps() {
        this.checkInit();
        return this.props;
    }

    public Workload[] getWorkloads() {
        this.checkInit();
        return this.workloads;
    }

    public Params getParams() {
        this.checkInit();
        return this.params;
    }

    @JsonIgnore
    public long getDocumentCount() {
        this.checkInit();
        return this.documentCount;
    }

    @JsonIgnore
    public long getRowSize() {
        this.checkInit();
        return this.rowSize;
    }

    @JsonProperty(value="documentbuilder")
    public DocumentBuilder.Config getDocumentBuilderConfig() {
        return this.documentBuilderConfig;
    }

    public static class Params {
        public long datasize;
        public long keysize;
        public long field_overhead;
    }
}

